#define FULL_DOC1 \
"docp - directory-oriented file copy\
\nVersion 1.1, Copyright (c) 1992, Roy Bixler\
\n\
\nGeneral Idea:\
\n\
\n    Docp is a directory-oriented copy program.  It gives you better\
\n    control over which files you can copy or move.  In the simplest\
\n    case, all files are copied from the source directory to the target\
\n    directory.  A list of files can be specified to limit what is\
\n    copied.  This list can have wild-card file specifications (default\
\n    list = *.*) and may be applied against either the source or target\
\n    directory (default = source).  If a file specification in the list\
\n    starts with a '-', it is excluded from the copy.  File dates and\
\n    times can be used to limit the file list.  Recursive copies are\
\n    also supported.\
\n\
\nUsage:\
\n\
\n    docp [-abcdfghijlmnorstvwz?] source_dir target_dir [file_list]\
\n\
\nOptions:\
\n\
\n    Multiple criteria options ('-a', '-d', '-n', '-o', and '-w') are\
\n    AND'ed together.  For example, specifying '-an' means copy the\
\n    source files which are newer and have the archive bit set.  If\
\n    either condition is false, the copy will not be done.  If you wish\
\n    to copy either the newer files or the files with the archive bit\
\n    set, just do two separate 'docp' commands (i.e. 'docp -a' followed\
\n    by 'docp -n').\
\n\
\n    The options are described below:\
\n\
\n    -a - Use archive bit\
\n        Copy only files which have the archive bit set.  Once the copy\
\n        is complete, the archive bit for the source file will be\
\n        turned off.\
\n\
\n    -b - Batch mode.\
\n        Turn off all interactive prompts.  Where questions are\
\n        normally asked, the following default actions are taken\
\n        instead.  If the target directory does not exist, try to\
\n        create it.  If a target file is read-only, delete the target\
\n        and re-try the copy.  Also, if the target device fills up, the\
\n        program simply prints a message and aborts.\
\n\
\n    -c - Check\
\n        Check the operation of the 'docp' command without actually\
\n        copying any files.  This mode sets the verbose options.\
\n\
\n    -d [boa]mm/dd/yy - Date\
\n        Copy files based on the date that they were last changed.\
\n        This flag takes one argument starting with the letters 'b',\
\n        'o', or 'a', followed by the date in the form, mm/dd/yy.  The\
\n        prefix 'b' stands for 'before' but not including the specified\
\n        date.  The prefix 'o' stands for 'on' the specified date, and\
\n        'a' stands for 'after' the specified date.  The date ranges\
\n        specified using the 'a' and 'b' prefixes are 'and-ed'\
\n        together.  The 'o' dates are then 'or-ed' with the result.\
\n        For example to specify all files last-changed during March,\
\n        you could type:\
\n            docp -vd ao3/1/91 -d b4/1/91 . a:"

#define FULL_DOC2 "\
\n\
\n    -f file_name - File\
\n       Get the file list from the file which is specified as an\
\n       argument following the '-f' flag.  If the file_name is \"-\" then\
\n       the file list will come from standard input.\
\n\
\n    -g - Gather\
\n        Gather the files from the source directory and all its\
\n        subdirectories into the one target directory.\
\n\
\n    -h - Hidden\
\n        Copy hidden files as well as non-hidden files.  Applies to\
\n        '-z - zap target' option below.\
\n\
\n    -i - Interactive\
\n        Interactively ask the user if he wishes to copy each file,\
\n        before the copy occurs.  Also applies to '-z - zap target'\
\n        option below.\
\n\
\n    -j - Join files\
\n        This is the companion of the '-l' option (see below).  If a\
\n        file with the same name as the source file exists in the\
\n        target directory, append the source file to the target file.\
\n\
\n    -l - Larger than target\
\n        Split up files that are larger than target.  See the 'Disk\
\n        Overflow' section below for further explanation.\
\n\
\n    -m - Move\
\n        Removes all copied files from the source directory.\
\n\
\n    -n - Newer\
\n        Copy only newer files.  If the source file already has a copy\
\n        in the target directory, then the copy or move only occurs if\
\n        the source file has a later date/time stamp then the target\
\n        copy.  If a source file does not already exist in the target\
\n        directory, then the source file is copied. This option can be\
\n        handy for doing fast backups.\
\n\
\n    -o - Older\
\n        Copy only older files.  If the source file already has a copy\
\n        in the target directory, then the copy or move only occurs if\
\n        the source file has an earlier date/time stamp then the target\
\n        copy.  If a source file does not already exist in the target\
\n        directory, then the source file is copied. This option can be\
\n        handy for quickly restoring backups.\
\n\
\n    -no - Not On target\
\n        Copy only if the source file does not exist in the target\
\n        directory.  This is a trick that uses the '-n' and '-o'\
\n        options.\
\n\
\n    -r - Recursive\
\n        Recursively copy all of the subdirectories of the source\
\n        directory.  Subdirectories that don't already exist under the\
\n        target directory are created.  Also, if the '-z - zap target'\
\n        option is specified, recursively deletes target subdirectories.\
\n\
\n    -s - Source\
\n        Apply the file list to the source directory. This is the\
\n        default.  The alternative is '-t'.\
\n\
\n    -t - Target\
\n        Apply the file list to the target directory. For example,\
\n        typing 'docp -t . a:', would copy only those files in the\
\n        current directory which were already on the 'A' drive.  This\
\n        is handy for doing backups."

#define FULL_DOC3 "\
\n\
\n    -v - Verbose\
\n        Report all files that are copied or moved.\
\n\
\n    -vv - Very Verbose\
\n        Report all files that are copied or not copied.\
\n\
\n    -w [ba]hh:mm[pa] - When\
\n        Copy files based on the time that they were last changed.\
\n        This flag takes one argument starting with the letters 'b', or\
\n        'a', followed by the time in the form, hh:mm[ap].  The prefix\
\n        'b' stands for 'before' but not including the specified time.\
\n        and the prefix 'a' stands for 'after' the specified date.  The\
\n        time ranges specified using the 'a' and 'b' prefixes are\
\n        'and-ed' together.  For example to specify all files\
\n        last-changed after 10:00pm but before 11:00pm you could type:\
\n            docp -vt a10:00p -t b11:00p . a:\
\n        If this option is used without the date option, then the\
\n        current system date is assumed.\
\n\
\n    -z - Zap\
\n        Zap (i.e. clear all files) in the target directory\
\n        (or directories) before copying.\
\n\
\n    -?\
\n        Print full documentation and exit.  You are here!\
\n\
\nDisk Overflow:\
\n\
\n    If the destination drive is full during a copy, then 'docp' will\
\n    pause and allow the user to change diskettes.  If the user\
\n    specified '-o', '-n', or '-t' then she will not be able to change\
\n    floppies.  This is because the original floppy was used to\
\n    determine which files to copy.  The '-l' option is useful here,\
\n    since the file that caused the target to be full will remain on\
\n    the current target and will continue to be copied on the new\
\n    target as a split file.  Without '-l', this file will be erased on\
\n    the current target and the copy will be retried on the new target.\
\n\
\nFile List:\
\n\
\n    If not specified, the default file list is '*.*'.  Any files\
\n    prefixed with '-' will be excluded from the file list.  For\
\n    example, to copy all files in a directory except a file called\
\n    'junk' or those with a '.obj' suffix, you could type:\
\n        docp -v . a: *.* -junk -*.obj\
\n    or\
\n        docp -v . a: -junk -*.obj\
\n\
\n    To copy a file starting with '-', use a prefix of '\\'.  For\
\n    example, to copy a file named '-copy.me', you could type:\
\n        docp -v . a: \\-copy.me\
\n\
\n    On a recursive copy, the file list is applied recursively to the\
\n    source or target (with '-t' option) directory and all\
\n    subdirectories.\
\n\
\nNonexistent Target Directory:\
\n\
\n    If the target directory does not exist, either the user will be\
\n    asked if she wishes to create it or, if the '-b' option is\
\n    specified, it will be created automatically."

#define FULL_DOC4 "\
\n\
\nRead-only Target File:\
\n\
\n    By default, the user will be asked 'do you wish to delete the\
\n    target and re-try the copy (Y/N/Q) ? '.  If '-b' is specified, a\
\n    'yes' answer to this question will be assumed.\
\n\
\nLicense:\
\n\
\n    This program is free software; you can redistribute it and/or modify\
\n    it under the terms of the GNU General Public License as published by\
\n    the Free Software Foundation; either version 1, or (at your option)\
\n    any later version.\
\n\
\n    This program is distributed in the hope that it will be useful,\
\n    but WITHOUT ANY WARRANTY; without even the implied warranty of\
\n    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\
\n    GNU General Public License for more details.\
\n\
\n    You should have received a copy of the GNU General Public License\
\n    along with this program; if not, write to the Free Software\
\n    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\
\n\
\n    Please send bug reports and/or suggestions to:\
\n        Roy Bixler\
\n        420 S. 13th\
\n        San Jose, CA 95112\
\n    Include the name of the program, version and operating system.\
\n\
\n    Bug reports and other comments can also be sent by e-mail on the\
\n        Internet to : rcb@netcom.com\
\n        UUCP: uunet!netcom.com!rcb\n"
