/************************************************************************
* "Epsilon", "EEL" and "Lugaru" are trademarks of Lugaru Software, Ltd. *
*									*
*  Copyright (C) 1985, 1990 Lugaru Software Ltd.  All rights reserved.	*
*									*
* Limited permission is hereby granted to reproduce and modify this	*
* copyrighted material provided that the resulting code is used only in	*
* conjunction with Lugaru products and that this notice is retained in	*
* any such reproduction or modification.				*
************************************************************************/

/*
* The modifications marked KSH below allow the following forms to be 
* placed in files suitable for M-x load-file.  Enjoy, Shane Hartman.
* 
* (set-variable "beep-duration" 19)
* (load-bytes "shane")
*
*/

#include "eel.h"

jmp_buf jbuf;

do_load_file(fname)	/* load command file */
char *fname;
{
int err;
char *old = bufname, *temp_load;

temp_load = temp_buf();
bufname = temp_load;
filename = fname;
if (err = do_file_read(fname, strip_returns.default)) {
	file_error(err, fname, "read error");
	maybe_ding(bell_on_read_error);
} else if (parse_cmds()) {
	bufname = old;
	to_buffer(temp_load);		/* show bad commands in window */
	quick_abort();
}
bufname = old;
delete_buffer(temp_load);
}

load_buffer_command()
{
char bname[80], *old = bufname;
int err;

get_buf(bname, "Load definitions from buffer", bufname);
if (exist(bname))
	bufname = bname;
else
	error("No such buffer");
err = parse_cmds();
bufname = old;
if (err) to_buffer(bname);		/* show offending command */
}

parse_cmds()	/* load cmds in current buf, return 1 if error occured */
{
int c;
char funcname[80];

point = 0;
if (setjmp(&jbuf))			/* errors come here */
	return 1;
for (;;) {
	re_search(1, "[ \n\t]*");		/* skip whitespace */
	if (point == size())
		return 0;
	if (curchar() == ';') {			/* found comment */
		nl_forward();
		continue;
	}
	must_char('(');
	re_search(1, "[ \t\n]*");
	parse_string(1, "[^ \t\n]*", funcname);
	if (!strcmp(funcname,"define-macro"))
		cf_macro();
	else if (!strcmp(funcname, "bind-to-key"))
		cf_bind();
	else if (!strcmp(funcname, "create-prefix-command"))
		cf_prefix();
	else if (!(strcmp(funcname, "load-bytes")))	/* KSH */
		cf_load();				/* KSH */
	else if (!(strcmp(funcname, "set-variable")))	/* KSH */
		cf_set();				/* KSH */
	else
		init_error("bad function");
	re_search(1, "[ \t\n]*");
	must_char(')');
}
}

short *keyseq;		/* sequence of key codes, in format used by macros */

cf_macro()		/* handle define-macro */
{
char name[80];

get_str(name);
get_keyseq();
name_macro(name, keyseq);
}

cf_bind()		/* handle bind-to-key */
{
int index;
char name[80];

get_str(name);
index = find_index(name);
if (index)
	put_on_key(index);
else
	init_error("no such command");
}

cf_prefix()		/* handle create-prefix-command */
{
	put_on_key(make_anon_keytable());
}

put_on_key(index)		/* parse key seq and bind it to index */
{
short *curtab;
int c, i = 1;

get_keyseq();
curtab = root_keys;
for (;;) {
	c = keyseq[i];
	if (++i >= keyseq[0]) break;
	if (name_type(curtab[c]) != NT_TABLE)
		init_error("expected \"");
	curtab = index_table(curtab[c]);
}
curtab[c] = index;
}

get_keyseq()			/* parse key names, put keys in keyseq */
{
re_search(1, "[ \t\n]*");
keyseq = get_keycode();
if (!keyseq)
	init_error("bad character");
}

/* KSH */
get_int(into)
char *into;
{
	re_search(1, "[ \t\n]*");
	if (!isdigit (character (point)))
		error ("Not a number");
	parse_string(1, "[012345679]*", into);
	re_search(1, "[ \t\n]*");
}

get_str(s)		/* get a quoted string, and put it in s */
char *s;
{
re_search(1, "[ \t\n]*");
must_char('"');
parse_string(1, "[^\"]*", s);
must_char('"');
}

must_char(c)	/* move past current character, making sure that it's c */
{
char msg[80];

if (curchar() != c) {
	sprintf(msg, "expected %c", c);
	init_error(msg);
} else
	point++;
}

have_char(c)	/* if this character is c, move past and return 1, else 0 */
{
int res = (curchar() == c);

if (res) point++;
return res;
}

init_error(s)		/* display error and abort loading */
char *s;
{
say("%s", s);
longjmp(&jbuf, 1);
}

insert_macro_command()		/* insert command-file definition of macro */
{
	char name[80];
	int i;

	get_macname(name, "Insert macro", "last-kbd-macro");
	i = find_index(name);
	if (i && name_type(i) == NT_MACRO) {
		bprintf("(define-macro \"%s\" ", name);
		stuff_macro(get_macro(i));
		stuff(")\n");
	} else
		error("Not a macro");
}

stuff_macro(m)		/* insert cmd-file format macro text in buffer */
short *m;
{
	char tmp[20];
	int i;

	stuff("\"");
	for (i = 1; i < m[0]; i++)
		switch (m[i]) {
			case '\n':	insert('\n'); break;
			case 'A':	/* "F-1" in text */
			case 'C':	/* resembles special key */
			case 'S':
			case 'F':
			case 'N':	if (i + 1 < m[0] && m[i + 1] == '-') {
						insert('\\');	/* quote it */
						insert(m[i]);
						break;
					}		/* fall through */
			default:	tmp[0] = 0;
					show_char(tmp, m[i]);
					stuff(tmp);
					break;
			case ALT('<'):
			case ALT('"'):
			case ALT('\\'):	stuff("A-");	/* fall through */
			case '<':		/* quote these */
			case '"':
			case '\\':	insert('\\');
					insert(m[i] & 0x7f);
					break;
		}
	stuff("\"");
}

/* KSH */
cf_set()    /* handle set-variable */
{
	int index;
	int type;
	char name[80];
	char arg[256];

	get_str(name);
	re_search(1, "[ \n\t]*");               /* skip whitespace */
	if (character(point) == '"')
		get_str(arg);
	else
		get_int(arg);
	index = find_index(name);
	type = name_type(index);
	if (type != NT_VAR && type != NT_BUFVAR && type != NT_WINVAR)
		error("%s: not a variable", name);
	set_var_val(index, arg, 1);
	set_var_val(index, arg, 0);  
}

/* KSH */
cf_load()   /* handle load-bytes */
{
	char fname[80];

	get_str(fname);
	strcpy(get_extension(fname), byte_extension);
	say("Loading %s", fname);
	load_commands(fname);
}
