/************************************************************************
* "Epsilon", "EEL" and "Lugaru" are trademarks of Lugaru Software, Ltd. *
*									*
*  Copyright (C) 1985, 1990 Lugaru Software Ltd.  All rights reserved.	*
*									*
* Limited permission is hereby granted to reproduce and modify this	*
* copyrighted material provided that the resulting code is used only in	*
* conjunction with Lugaru products and that this notice is retained in	*
* any such reproduction or modification.				*
*************************************************************************
*  The previous copyright and trademark notice applies to some of the	*
*  code herein. All other changes, enhancements and extension routines	*
*									*
*  Copyright (C) 1989, 1990 by Jonas H. Hedberg. All rights reserved.   *
*									*
*  These changes may be redistributed free allowed for any purpose	*
*  providing both the Lugaru and my copyrights remain intact.		*
*  I assume no liability for the use or inability to use		*
*  this software. Neither do I take responsibility for any damage	*
*  cased by this software extension.					*
*  This extension may NOT be redistributed for profit.			*
*************************************************************************
* File.......: PRINTER.E                                                *
* Ver........: 1.06                                                     *
* Date.......: 1990-10-17                                               *
* psilon ver: 5.0                                                      *
* By.........: Jonas Hedberg                                            *
*     Title..: Software Engineer                                        *
*     Company: TEAMSTER AB                                              *
*     Address: P.O. Box 8321                                            *
*              S-402 79  GTEBORG                                       *
*     Country: SWEDEN                                                   *
*     Tel....: Int +46-31-22 22 65  (GMT + 1h)                          *
*     Fax....: Int +46-31-22 75 46                                      *
* Description: Prints the current buffer to a KYOCERA, HP LaserJet II   *
*              or an IBM Graphic Printer. To two previous printres      *
*              sends a initial string to the printer before printing    *
*              and after. The IBM doesn't send any strings exept the    *
*              current buffer. Printing in portrait or landskap is      *
*              possible and to change the printer destnation.           *
* Description:                                                          *
* Algorithm..:                                                          *
* Comments...:                                                          *
* Change log                                                            *
* Date      | Ver   | Change                                            *
* ----------+-------+-------------------------------------------------- *
* 18-Oct-90 | 1.01  | Added IBMGRPH.                                    *
* 18-Oct-90 | 1.02  | Added FormFeed to KYOCERA.                        *
* 22-Oct-90 | 1.03  | Fixed that PRINT do the change_modified.          *
* 19-Nov-90 | 1.04  | Added FormFeed after printout to all printertypes.*
* 21-Nov-90 | 1.05  | Added the check before printing.                  *
*  7-Dec-90 | 1.06  | Fix the 1st row bug.                              *
************************************************************************/

#include "eel.h"
#include "lowlevel.h"

when_loading()
{
	sayput("PRINTER-module  Ver 1.06  (C) 1990 by Jonas Hedberg. Loading...");
 	delay(300, COND_KEY);
}

char printer_device[12] = "LPT1";
char printer_model[10] = "IBMGRPH";
char printer_orientation[1] = "P";

command set_printer_device()
{
	char prompt[80];

	sprintf(prompt, "Current printer device is %s. New (LPT1,LPT2,LPT3,COM1,COM2)",printer_device);
	get_strdef(printer_device, prompt, printer_device);
}

command set_printer_model()
{
	char prompt[80];

	sprintf(prompt, "Current printer model is %s. New (HPLJ2,IBMGRPH,KYOCERA)",printer_model);
	get_strdef(printer_model, prompt, printer_model);
}

command set_printer_orientation()
{
	char prompt[80];

	sprintf(prompt, "Current printer orientation is %s. New (P,L)",printer_orientation);
	get_strdef(printer_orientation, prompt, printer_orientation);
}

command print()
{
	int handle, error, count, old_modified, old_point;
	char *_printer_init_1[255];
	char *_printer_init_2[255];
	char *_printer_exit_1[255];
	char *_printer_exit_2[255];

	if ((strfcmp(printer_model, "HPLJ2") != 0) &&
	   (strfcmp(printer_model, "IBMGRPH") != 0) &&
	   (strfcmp(printer_model, "KYOCERA") != 0)) {
		say("No printer model was defined.");
		maybe_ding(bell_on_write_error);
		return;
	}

	if (((strfcmp(printer_model, "HPLJ2") == 0) ||
	   (strfcmp(printer_model, "KYOCERA") == 0)) &&
	   ((strfcmp(printer_orientation, "P") != 0) &&
	   (strfcmp(printer_orientation, "L") != 0))) {
		say("No printer orientation was defined.");
		maybe_ding(bell_on_write_error);
		return;
	}

	if ((strfcmp(printer_device, "LPT1") != 0) &&
	   (strfcmp(printer_device, "LPT2") != 0) &&
	   (strfcmp(printer_device, "LPT3") != 0) &&
	   (strfcmp(printer_device, "COM1") != 0) &&
	   (strfcmp(printer_device, "COM2") != 0) &&
	   (strfcmp(printer_device, "COM3") != 0) &&
	   (strfcmp(printer_device, "COM4") != 0)) {
		say("No printer device was defined.");
		maybe_ding(bell_on_write_error);
		return;
	}


	
	if (strfcmp(printer_model, "HPLJ2") == 0) {
		if (strfcmp(printer_orientation, "P") == 0) {
			*_printer_init_1 = "E&l0O&k10H&l2e72F&a6l85\r";
			*_printer_init_2 = "";
			*_printer_exit_1 = "E";
			*_printer_exit_2 = "";
		}
		if (strfcmp(printer_orientation, "L") == 0) {
			*_printer_init_1 = "E&l1O&k10H&l6e48F&a0l134M\r";
			*_printer_init_2 = "";
			*_printer_exit_1 = "E";
			*_printer_exit_2 = "";
		}
	}

	if (strfcmp(printer_model, "IBMGRPH") == 0) {
		*_printer_init_1 = "";
		*_printer_init_2 = "";
		*_printer_exit_1 = "";
		*_printer_exit_2 = "\f";
	}

	if (strfcmp(printer_model, "KYOCERA") == 0) {
		if (strfcmp(printer_orientation, "P") == 0) {
                        *_printer_init_1 = "!R!FRPO A1, 0;FRPO A2, 0;FRPO A3, 0;FRPO A4, 60;FRPO A5, 10;FRPO A6, 50;FRPO A7, 7;FRPO A8, 87;FRPO C0, 0;FRPO C1, 0;FRPO C2, 0;FRPO C3, 1;FRPO C4, 0;FRPO C5, 0;FRPO H0, 0;FRPO H1, 96;FRPO H2, 8;FRPO H3, 2;FRPO H4, 0;FRPO H5, 1;FRPO H6, 95;";
			*_printer_init_2 = "FRPO H7, 70;FRPO H8, 6;FRPO H9, 1;FRPO P1, 1;FRPO P2, 2;FRPO P3, 0;FRPO P9, 82;FRPO U0, 6;FRPO U1, 81;FRPO U2, 12;FRPO U3, 0;FRPO U5, 0;FRPO U6, 5;FRPO L1,00;FRPO L2,50;FRPO L3,00;FRPO L4,25;FRPO L5,10;FRPO L6,61;FRPO L7,08;FRPO L8,11;EXIT;\f";
			*_printer_exit_1 = "";
			*_printer_exit_2 = "\f";
		}
		if (strfcmp(printer_orientation, "L") == 0) {
			*_printer_init_1 = "!R!FRPO C0, 0;FRPO C1, 1;FRPO C2, 0;FRPO C3, 17;FRPO C4, 0;FRPO C5, 0;FRPO A1, 1;FRPO A2, 0;FRPO A3, 0;FRPO A4, 50;FRPO A5, 7;FRPO A6, 87;FRPO A7, 10;FRPO A8, 50;FRPO H0, 0;FRPO H1, 96;FRPO H2, 8;FRPO H3, 2;FRPO H4, 0;FRPO H5, 1;FRPO H6, 95;";
			*_printer_init_2 = "FRPO H7, 70;FRPO H8, 6;FRPO H9, 1;FRPO P1, 1;FRPO P2, 1;FRPO P3, 1;FRPO P9, 82;FRPO U0, 6;FRPO U1, 81;FRPO U2, 12;FRPO U3, 0;FRPO U5, 0;FRPO U6, 5;FRPO L1,00;FRPO L2,50;FRPO L3,00;FRPO L4,25;FRPO L5,10;FRPO L6,61;FRPO L7,08;FRPO L8,11;EXIT;\f";
			*_printer_exit_1 = "";
			*_printer_exit_2 = "\f";
		}
	}
	/* Remember if buffer is modified */
	old_modified = modified;
	old_point = point;
	
	/* Write inital strings to printer device */
	handle = lowopen(printer_device, 3);
	count = strlen(*_printer_init_1);
	lowwrite(handle, *_printer_init_1, count);
	count = strlen(*_printer_init_2);
	lowwrite(handle, *_printer_init_2, count);
	lowclose(handle);
	
	/* Write buffer to printer */
	point = 0;
	if (error = file_write(printer_device, strip_returns)) {
		file_error(error, printer_device, "print error");
		maybe_ding(bell_on_write_error);
	} else {
		say("Buffer has been printed.");
	}

	/* Write exit strings to printer */
	handle = lowopen(printer_device, 3);
	count = strlen(*_printer_exit_1);
	lowwrite(handle, *_printer_exit_1, count);
	count = strlen(*_printer_exit_2);
	lowwrite(handle, *_printer_exit_2, count);
	lowclose(handle);

	/* Change modified to the original */
	modified = old_modified;
	point = old_point;
}
