/* Fill prefix commands for Epsilon.

   (c) Copyright 1990 Carl W. Hoffman.  All rights reserved.

   This file may be freely copied, distributed, or modified for non-commercial
   use provided that this copyright notice is not removed.  For further
   information about other Common Lisp and Scheme utilities, contact the
   following address:

   Carl W. Hoffman, 363 Marlborough Street, Boston, MA 02115, U.S.A.
   Internet: CWH@AI.MIT.EDU    CompuServe: 76416,3365    Fax: 617-262-4284

   This code has been tested with Epsilon version 5.0.
   
   08/07/91 K. Shane Hartman (shane@ai.mit.edu) Replace Lugaru's 
            forward-paragraph, backward-paragraph and break-line-here commands
            in this file so that filling comments works.  Removed some junk I 
            don't use (bat-mode, asp-mode, ansi-c-mode).  Set ansi c shit in 
            c-mode hook. */

#include <eel.h>

#ifdef SPR

#include "vardefs.h"

#else

buffer char fill_prefix[32];

#endif

#undef void
#define void int

#undef NULL
#define NULL ((char *) 0)

buffer char fill_prefix[32];

/*
 * You should change (or create) c-mode-hook such that these variables
 * are set as follows:
 *
 * fill_prefix = " * "
 * margin_right = 74
 * fill_mode = 0
 * auto_fill_indents = 0
 * 
 * or whatever values you prefer.  Now you can set auto fill mode while
 * typing comments and let it do the filling.  Old comments can be filled
 * ALT-Q.
 */

when_loading()
{
  strcpy(fill_prefix, "");
  strcpy(fill_prefix.default, "");
}

/* To be compatible with standard implementations of fill prefix, only when
the fill prefix is empty should forward_paragraph and backward_paragraph be
used to determine the paragraph to be filled.  If a fill prefix is defined,
the paragraph is defined to be a contiguous group of lines having the same
fill prefix.  The forward_paragraph and backward_paragraph commands should
observe this convention, also. */

#define at_beginning_of_line(pos) \
  (((pos) == 0) || (character((pos)-1) == '\n'))

void re_enquote (targ, source)
char *targ;
char *source;
{
  char ch;
  while (ch = *source++)
  {
    if (index ("^*%()\\[]|", ch)) *targ++ = '%';
    *targ++ = ch;
  }
  *targ++ = '\0';
}

/*
 * Replace the following 3 Lugaru commands so that filling works for comments.
 * They are from format.e
 */

command forward_paragraph() on reg_tab[ALT(']')], reg_tab[NUMALT(KEYDOWN)]
{
  if (fill_prefix[0])
  {
    char pat[sizeof (fill_prefix) * 2 + 1];

    re_enquote (pat, fill_prefix);
    nl_forward ();
    while (parse_string (1, pat, NULL))
      nl_forward ();
    nl_reverse ();
  }
  else
  {
    to_begin_line();
    re_search(1, "([@.\\].*\n)*");
    re_search(1, "[^ \t\n@.\\]");
    if (re_search(1, "\n[ \t\n]|\f")) {
      point--;
      if (curchar() != '\f')
        re_search(-1, "^([@.\\].*\n)*");
    } else
      point = size();
  }
}

command backward_paragraph() on reg_tab[ALT('[')], reg_tab[NUMALT(KEYUP)]
{
  if (fill_prefix[0])
  {
    char pat[sizeof (fill_prefix) * 2 + 1];

    re_enquote (pat, fill_prefix);
    nl_reverse();
    to_begin_line();
    while (parse_string (1, pat, NULL))
    {
      nl_reverse ();
      to_begin_line();
    }
    nl_forward ();
  }
  else
  {
    if (character(point - 1) == '\n')
      re_search(-1, "^([@.\\].*\n)*");
    re_search(-1, "[^ \t\n]");
    if (re_search(-1, "\n[ \t\n]|\f"))
      re_search(1, "\n*");
    if (curchar() != '\f')
      re_search(1, "^([@.\\\f].*\n)*");
  }
}

break_line_here()	/* replace whitespace with \n and indent */
{
	delete_horizontal_space();
	insert('\n');
  stuff(fill_prefix);
  build_first = 1;
  display_column = 0;
	if (auto_fill_indents && indenter)
		(*indenter)();
}

/*
 * New commands.
 */

command fill_paragraph() on reg_tab[ALT('q')]
{
  int end, start=point;
  int prefix_length = strlen(fill_prefix);
  
  iter = 0;
  forward_paragraph();
  end = point - 1;
  backward_paragraph(); 
  if (!prefix_length) {
    /* Leave leading whitespace intact */
    re_search(1, "[ \t\n]*");
    region_fill(point, end);
  }
  else {
    
    int prefix_seen = 0;
    int fill_start = point;
    int *fill_end = alloc_spot();
    *fill_end = end;
    
    /* Remove existing fill prefixes, if any exist. */
    
    while (search(1, fill_prefix)) {
      if (!(point < *fill_end))
        break;
      if (at_beginning_of_line(matchstart)) {
        if (point < start)
          start -= prefix_length;
        else if (matchstart < start)
          start = matchstart;
        delete(matchstart, point);
        prefix_seen = 1;
      }
    }
    
    /* Fill the region.  Even though fill_end is a spot,
     it is left at the beginning of the last line of the
     filled region.  Therefore, move it to the end of the
     line before putting the fill prefixes back. */
    
    if (prefix_seen)
      margin_right -= prefix_length;
    region_fill(fill_start, *fill_end);
    point = *fill_end;
    to_end_line();
    *fill_end = point;
    
    /* If at least one fill prefix was removed from the region,
     then put them back on every line in the region. */
    
    if (prefix_seen) {
      margin_right += prefix_length;
      point = fill_start;
      while (point < *fill_end) {
        if (point < start)
          start += prefix_length;
        stuff(fill_prefix);
        nl_forward();
      }
    }
    free_spot(fill_end);
  }
  
  if (start > size()) start = size();
  point = start;
}
  
command set_fill_prefix() on cx_tab['.']
{
  int start = point;

  to_begin_line();
  grab(point, start, fill_prefix);
  say("Fill prefix set to %s", fill_prefix);
  point = start;
}
