/*
 * Copyright header commands for Epsilon 5.0
 *
 * Copyright (C) 1991, K. Shane Hartman
 *
 * This file is free software; you can redistribute it and/or modify
 * it so long as this notice is preserved and no fee is charged (other than 
 * reasonable media fees) for distribution.  You are forbidden to deny these
 * rights to any other user of Epsilon.  Lugaru Software Ltd. may incorporate 
 * any and all of this code into Epsilon and have all rights to
 * the code, since it is only useful for Epsilon.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * Revision History:
 * Send comments, bug fixes, suggestions to shane@ai.mit.edu
 *
 * Version 1.0: 08/02/91 shane@ai.mit.edu 
 * Version 1.1: 08/02/91 shane@ai.mit.edu Fix prompting for user.
 *
 * This program provides the command M-x new file.  It inserts a header at
 * the top of a new file that contains a copyright message (such as my 
 * company requires).
 *
 * The header looks like this (for example)
 *
 * copyrite.e
 *
 * Created by Shane, 08/02/91 01:23
 * 
 * Copyright (C) 1991, Software Productivity Research, Inc.
 * All rights reserved.
 *
 * The command knows how to comment things by use of the variables 
 * comment_start and comment_end, although it will work for C without
 * these variables since I hardwired it.  Other modes require you to
 * set these variables.  The filename (copyrite.e) part is taken from
 * the variable filename if that exists, else bufname if that exists,
 * else "Unknown".  The user_name part (Shane) is taken from the 
 * variable user_name if that is set, else the environment variable 
 * USER, else it prompts.  The holder of the copyright is taken from
 * the variable copyright_holder.
 */

#include "eel.h"

#ifdef SPR

#include "vardefs.h"

#else

buffer char *comment_start;             /* Set this on a per mode basis */
buffer char *comment_end;

/*
 * Set this to the owner of the copyright (your company).
 */
char copyright_holder[48] = "";

/*
 * Set this to your user name (or set the environment variable USER).  If
 * neither is set, the command will prompt.
 */
char user_name[16] = "";

#endif /* SPR */

/*
 * With argument, prompts for user name and holder, else takes from 
 * defaults as discussed above.
 */
command new_file ()
{
  int *where = alloc_spot ();
  struct time_info tinfo;
  char copyright[80];
  char *user = has_arg ? NULL : (*user_name ? user_name : NULL);
  char *fname = filename;

  time_and_day (&tinfo);
  if (!user)
  {
    if (!has_arg) 
      user = getenv ("USER");
    if ((!user || !*user) && !*user_name)
    {
      get_string (user_name, "Who are you: ");
      if (!*user_name)
        quick_abort ();
      else
        user = user_name;
    }
  }
  if (has_arg || !*copyright_holder)
    get_string (copyright_holder, "Copyright holder: ");
  if (!*copyright_holder)
    quick_abort ();
  if (fname)
  {
    struct file_info info;
    
    if (check_file (fname, &info))
    {
      tinfo.year = info.year;
      tinfo.month = info.month;
      tinfo.day = info.day;
      tinfo.hour = info.hour;
      tinfo.minute = info.minute;
      tinfo.second = info.second;
      fname = get_tail (fname, 0);
    }
    else
    {
      fname = bufname;
      if (!fname)
        fname = "unknown";
    }
  }
  point = 0;
  sprintf (copyright, "Copyright (C) %d, %s", tinfo.year, copyright_holder);
  if (!strfcmp (mode, "C") || !strfcmp (mode, "GnuC"))
  {
    bprintf ("/*\n * %s\n *\n * Created by %s, %02d/%02d/%02d %02d:%02d\n * \n * %s\n * All rights reserved.\n */\n",
             fname, user,
             tinfo.month, tinfo.day, tinfo.year - 1900, tinfo.hour, tinfo.minute,
             copyright);
  }
  else
  {
    bprintf ("%s\n%s %s\n%s\n%s Created by %s, %02d/%02d/%02d %02d:%02d\n%s\n%s %s\n%s All rights reserved.\n%s\n",
             comment_start, comment_start, fname, 
             comment_start, comment_start, user,
             tinfo.month, tinfo.day, tinfo.year - 1900, tinfo.hour, tinfo.minute,
             comment_start, comment_start, copyright, comment_start, comment_start);
  }
  point = *where;
  free_spot (where);
}

  