/* Make the process window more of a nice shell window. */
/* 90/07/07:  Updated for Epsilon 5.0. */

#include "include\eel.h"

/* From super.e: */
int supercede_routine ();


/* Aliases:  Although this could be turned into a general abbrev. facility,
   its current goal is to substitute for the ANARKEY alias facility since
   ANARKEY is not functional in the process buffer. */

/* I wish I knew a better way to find ANARKEY.AKA. */

char ced_file[20] = "C:\\ANARKEY.AKA";
char aliases[10] = "-aliases";

/* Read the alias file and turn it into something easily searched. */
command	establish_aliases()
{
    int i;
    char *oldbuf = bufname;
    char *ced_filef;
    int cf;
    
    if (!exist(aliases)) {
	zap(aliases);
	bufname = aliases;
	ced_filef = lookpath (ced_file);
	if (ced_filef == 0) {
	    say ("Can't find alias file %s", ced_file);
	    return;
	}
	i = file_read(ced_filef, 1 /* strip ^M */);
	bufname = oldbuf;
	if (i && i == 2) {
	    delete_buffer(aliases);
	    say ("Aliases (%s) not found.", ced_filef);
	    return;
	}
	if (i && i != 2) {
	    delete_buffer(aliases);
	    say ("Error %d reading aliases (%s)", i, ced_filef);
	    return;
	}
	bufname = aliases;
	if (character(size()-1) != '\n') {
	    point = size();
	    enter_key();
	}
	point = 0;
	cf = case_fold;
	case_fold = 1; /* ignore case in match */
	/* Strip out REM lines */
	point = 0;
	while (re_search(1,"^REM")) {
	    nl_forward();
	    delete(matchstart,point);
	}
	case_fold = cf;
	/* Strip leading colon */
	point = 0;
	while (re_search(1,"^:")) {
	    delete(matchstart,point);
	}
	point = 0;
	modified = 0;
	bufname = oldbuf;
    }
}

/* Replace the alias at point (if any), return true if there was an alias. */
subst_alias()
{
    int eow, bow, boa;
    char alias[42];
    char *oldbuf = bufname;
    int cf;
	
    /* Make sure the aliases are defined. */
    if (!exist(aliases))
	establish_aliases();
    
    /* Delimit the current word */
    re_search(1,word_pattern);
    eow = point;
    re_search(-1,word_pattern);
    bow = point;
    
    /* If the word is short enough, search for its alias */
    if (eow - bow < 40) {
	alias[0] = '^';
	grab(bow, eow, &alias[1]);
	strcat (alias, "[ \t]+");
	bufname = aliases;
	point = 0;
	cf = case_fold;
	case_fold = 1;
	if (!re_search (1, alias)) {
	    /* Not found */
	    bufname = oldbuf;
	    case_fold = cf;
	    return 0;
	}
	case_fold = cf;
	/* Go back and delete the alias name */
	bufname = oldbuf;
	delete(bow, eow);
	/* Insert the alias substitution */
	bufname = aliases;
	boa = point;
	to_end_line();
	xfer(oldbuf, boa, point);
	bufname = oldbuf;
	/* OK */
	return 1;
    }
    /* No substitution attempted */
    return 0;
}

command substitute_alias()
{
    int i = subst_alias();
    if (!i) say ("Alias not found.");
}


/* Inserts an enter keystroke in the process buffer, which causes Epsilon
   to send the line to DOS.  But if hit anywhere except the last character
   of the last line, copies the line it is on to the end of the buffer.
   Good for repeating commands! */

/* Actually, user should fix the prompt pattern to be something particular
   to his own system. */

/* If the last line doesn't contain only a prompt, should do what?  Perhaps
   erase it before copying the new line down? */

#ifdef OS2
char prompt_pattern[12]="^%[.*%]";
#endif

#ifdef MSDOS
char prompt_pattern[12]="^.*>";
#endif

buffer int do_aliasing = 0; /* Should only be 1 in the process buffer */

/* From (proc.e), modified to turn on aliasing in the process buffer */
char process_mode_name[] = "Process";
command dsb_process_mode()
{
    org_process_mode();
    do_aliasing = 1;
}


/* Handle the enter key in the process buffer.  Special processing enables
   you to go back to a previous command line, edit it (or not), hit enter
   there, and have the command copied to the end of the process buffer and
   executed.  (Or you can simply edit the current command line and hit
   enter with point anywhere on the line and it will be executed.) */

command dsb_process_enter()
{
    int eol, start, szline;
    
    char captured_line[81];
    char *pcaptured_line;
    
    if (point < size()) {
	/* First see if we're on the last line. */
	start = point;
	point = size();
	to_begin_line();
	if (point <= start)
	    /* On last line, just move to end. */
	    point = size();
	else {
	    /* Not on last line, move the line (after the prompt)
		to the end of the buffer. */
	    point = start;
	    to_end_line();
	    eol = point;
	    to_begin_line();
	    re_search (1 /*forward*/, prompt_pattern);
	    szline = eol - point;
	    if (szline <= 80) {
		grab(point, eol, captured_line);
		point = size();
		stuff(captured_line);
	    } else {
		pcaptured_line = malloc(szline+1);
		grab(point, eol, pcaptured_line);
		point = size();
		stuff(pcaptured_line);
		free(pcaptured_line);
	    }
	}
    }
    if (do_aliasing) {
	to_begin_line();
	re_search (1, prompt_pattern);
	subst_alias();
	point = size();
    }
    
    org_process_enter();
}


/* Executed automatically by Epsilon when this file is loaded. */
when_loading ()
{
    load_commands ("super");

    supercede_routine ("process_mode",
		       "org_process_mode",
		       "dsb_process_mode");
    supercede_routine ("process_enter",
		       "org_process_enter",
		       "dsb_process_enter");
}
