/* FASTTYPE file words.c
 *
 * This file contains the word read-in and initialization functions
 */

/* WORDS
 * The default list of words to type.
 * Must terminate with a "\0".
 * There's also an opportunity to include your own favorite words in
 * WORDLIST.H; if you have one, then #define WORDLIST.
 */

char *words[]={
#ifdef WORDLIST
#   include "WORDLIST.H"
#else
	"now","how","are","there","sew","tough",
	"and", "and", "and", "all", "are",
	"the", "the", "the", "we","us", "will", "did",
	"why", "when", "thus", "hard", "easy", "small",
	"move", "say", "tell", "try", "keep", "do",
	"concrete","abstract","real","ideal",
	"accept","reject", "grow","new","renew","fresh",
	"rapid","change","careful","broad",
	"massive","huge", "doubt","dubious","certain",
	"past","present","future", "obvious","consider","finish","complete",
	"actual","add","adequate","afford",
	"worse","bad","basic","fun","brief",
	"uniform", "vital","viable", "worth", "clear","lucid","simple",
	"stud","fox","quick","brown","dog","lazy","lament",
	"command","entire","earth","purple","his","coward",
	"wonder","where","why","and","blue","book","letter",
	"girl","boy","stood","read","ponder","summary","escape",
	"terminal","game","type","show","status","state","line",
	"print","bell","lock","keyboard","shift","reset","normal",
	"video","reverse","follow","number","speaker","always",
	"able","ability", "about", "above", "absolute",
	"abstract", "accept", "accomplish", "accord","as",
	"accurate", "across", "active", "at", "activity",
	"actual", "adapt", "add", "adequate", "adjust",
	"advent", "affirm", "afford", "after", "agenda",
	"aggregate", "agree", "allocate", "alternate", "although",
	"ambiguous", "amount", "amply", "analogous", "analysis",
	"anomaly", "apparent", "appear", "apply", "approval",
	"approximate", "arbitrary", "argument", "as", "assign",
	"associate", "assume", "at", "attach", "attend",
	"attendant", "attitude", "attractive", "authorize", "automatic",
	"awfully", "bad", "badly", "barely", "bare",
	"basis", "because", "beginning", "behind", "below",
	"beneficial", "benefit", "better", "blatant", "brief",
	"broad", "broadly", "by", "candidate", "less",
	"capable", "careful", "carefully", "care", "casual",
	"category", "central", "certain", "certainly", "change",
	"chart", "charter", "cleanly", "clear", "close",
	"coarse", "collateral", "collect", "command", "commence",
	"commit", "comparably", "competent", "complaint", "complete",
	"complicate", "comprehend", "concern", "concise", "conclusion",
	"confess", "confide", "consider", "constant", "constraint",
	"construct", "contact", "contrary", "convenient", "correct",
	"criteria", "crude", "curious", "current", "date",
	"deadline", "debate", "decide", "decision", "deeply",
	"deficient", "defined", "delivery", "demand", "depend",
	"development", "differ", "direct", "disposal", "diverse",
	"doubt", "doubtful", "dubious", "durable", "dynamic",
	"early", "effect", "effective", "efficient", "elegant",
	"employ", "enclosed", "encourage", "endeavor", "end",
	"enhance", "entertain", "entire", "entirely", "environment",
	"epistomological", "equally", "equipment", "equitable", "erroneous",
	"essence", "essential", "eternal", "evaluate", "evenly",
	"event", "evidence", "evident", "evidently", "exact",
	"exactly", "excellent", "excess", "existence", "experience",
	"experiment", "explicit", "expression", "extreme", "failure",
	"fair", "faith", "fault", "fear", "field", "full",
	"file", "final", "finance", "finish", "finite",
	"firmly", "follow", "for", "force", "forecast",
	"foresee", "formal", "frank", "free", "fresh",
	"from", "full", "fully", "fundamental", "further",
	"future", "general", "global", "goal", "good",
	"gradual", "great", "ground", "grow", "guidance",
	"guide", "harm", "help", "hierarchy", "high",
	"hopeful", "huge", "idea", "ideal", "ideally",
	"identical", "idly", "if", "imaginable", "immediate",
	"immensely", "impact", "impediment", "important", "in",
	"incomplete", "increment", "independent", "infallibly", "inform",
	"initial", "input", "instant", "insurance", "intelligent",
	"interest", "interface", "intuitive", "inverse", "issuance",
	"issue", "judgment", "just", "large", "lastly",
	"likely", "literal", "local", "loosely", "lucid",
	"major", "manage", "mark", "massive", "material",
	"material", "matter", "meaningful", "measurable", "measurement",
	"men", "method", "mildly", "mile", "mind",
	"minimal", "minor", "model", "moderate", "module",
	"moment", "move", "natural", "nature", "near",
	"necessary", "necessity", "need", "new", "next",
	"normal", "note", "objective", "obvious", "occasion",
	"of", "official", "only", "opinion", "opportunity",
	"opposite", "ordinary", "organize", "outcome", "output",
	"over", "owner", "partial", "past", "perceive",
	"permission", "person", "personal", "plain", "plan",
	"please", "policy", "political", "ponder", "portal",
	"power", "practice", "prefer", "premise", "present",
	"primary", "principal", "priority", "probably", "procedure",
	"process", "progress", "project", "prolong", "promptly",
	"proposal", "protocol", "purchase", "pure", "purpose",
	"quality", "quantity", "quickly", "quite", "quota",
	"radical", "random", "rapid", "rather", "real",
	"reality", "reason", "recent", "recruit", "redundant",
	"reference", "refine", "register", "regret", "reject",
	"relative", "reliably", "renew", "repair", "report",
	"request", "resource", "result", "robust", "routine",
	"schedule", "separate", "service", "short", "sweet", "simple",
	"since", "size", "sponsor", "standard", "statement",
	"steady", "strike", "strong", "success", "suggest",
	"super", "system", "task", "team", "temporal",
	"time", "to", "too", "two", "topical", "total", "trade",
	"travel", "tremendous", "trivial", "true", "truth",
	"typical", "ultimate", "under", "unfortunate", "unify",
	"unique", "useful", "usual", "vague", "valuable",
	"very", "viable", "view", "vital", "weak",
	"well", "with", "work", "worse", "worth",
#endif
	"\0"};	/* leave this here */

/* INITWORDS
 *
 * This routine gets the word list and sets the maximum
 * word number in its return value
 */
int
initwords()
{
register int maxwd;
	maxwd = 0;
	while (*words[maxwd] != '\0') {
		maxwd++;
		if (maxwd > 10000)	/* safety check */
			error("Could not find word list end");
	}
	return(maxwd);
}
