/****************************************************************************
 *
 *	Program Name : COMPARE.C
 *
 *	This program checks the correctness of the solution array by
 * 	converting the input array and output array to minterms, sorting
 *	them (ascending order) and check to see if they are equal.
 *
 *	Note : This program is usable ONLY for ON-array only data input.
 *
 * --------------------------------------------------------------------------
 *	Copyright (c) 1992. All Rights Reserved. Nanyang Technological
 *	University.
 *
 *	You are free to use, copy and distribute this software and its
 *	documentation providing that:
 *
 *		NO FEE IS CHARGED FOR USE, COPYING OR DISTRIBUTION.
 *
 *		IT IS NOT MODIFIED IN ANY WAY.
 *
 *		THE COPYRIGHT NOTICE APPEAR IN ALL COPIES.
 *
 *	This program is provided "AS IS" without any warranty, expressed or
 *	implied, including but not limited to fitness for any particular
 *	purpose.
 *
 *	If you find NTUMIN fast, easy, and useful, a note or comment would be
 *	appreciated. Please send to:
 *
 *		Boon-Tiong Tan or Othman Bin Ahmad
 *		School of EEE
 *		Nanyang Technological University
 *		Nanyang Avenue
 *		Singapore 2263
 *		Republic of Singapore
 *
 ****************************************************************************
 *
 *	ma, mb	== no. of minterms in ON arrays, a & b
 *	nb, nb	== no. of variables of ON arrays, a & b
 *	nspm	== no. of storage/minterm (bytes/minterm)
 *      m3	== total no. of bytes in array a or b
 *	test	== hold status of memory comparison
 *
 ***************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define mask8 255


main()

{
   unsigned short    m1, m2, ma, mb;
   unsigned char     *infile, *outfile, *readf(), *sorting();
   unsigned char     *a, *b, nspm, na, nb, c;
	     int     test;
   unsigned long     m3;
   FILE              *in, *out;            /*  file pointers */

   printf("This program is for checking the output generated by the minimization \n");
   printf("program to verify that it is correct.\n\n");
   printf("Before that, the output file must be converted to one similar to the\n");
   printf("input file. (Not usable for inputs with DC array)\n\n");
   printf("Press any key to Continue or <ESC> to QUIT\n\n");
   c = getch();
   if (c==27)
      exit(0);

   infile = (unsigned char *)malloc (21);       /* space for 1st filename */
   if (infile==0)
      {
	 printf("Out of memory -- COMPARE, *infile\n");
	 printf("Program Terminated - 1\n");
	 exit(0);
      }

   outfile = (unsigned char *)malloc (21);      /* space for 2nd filename */
   if (outfile==0)
      {
	 printf("Out of memory -- COMPARE, *outfile\n");
	 printf("Program Terminated - 2\n");
	 exit(0);
      }

   printf("Enter input filename -> ");
   gets(infile);                                 /* read 1st filename */

   printf("Enter output filename -> ");
   gets(outfile);                                /* read 2nd filename */

   if ((in = fopen(infile, "r+")) == NULL)           /* open 1st file */
      {
	 printf("Error opening file, %s\n", infile);
	 printf("Program terminated.\n ") ;
	 exit(0);
      }

   if ((out = fopen(outfile, "r+")) == NULL)         /* open 2nd file */
      {
	 printf("Error opening file, %s\n", outfile);
	 printf("Program terminated.\n ") ;
	 exit(0);
      }

   /***
    ***  READING FROM FILES AND CONVERTING TO MINTERMS
    ***/

   printf("\nPlease Hang On, Reading From Files & Converting To Minterms ... \n\n");

   a = readf(in, a, 0);                /* read ON array, 1st file */
   a = sorting(a);                     /* sort in ascending order */
   fclose(in);                         /* close 1st file */

   na = *a;                            /* no. of variables */
   m1 = *(a+1);
   m2 = *(a+2);
   ma = (m2&mask8)<<8 | m1;            /* no. of minterms */

   b = readf(out, b, 0);               /* read ON array, 2nd file */
   b = sorting(b);                     /* sort in ascending order */
   fclose(out);                        /* close 2nd file */

   nb = *b;                            /* no. of variables */
   m1 = *(b+1);
   m2 = *(b+2);
   nspm = *(b+3);                      /* no. of byte/minterm */
   mb = (m2&mask8)<<8 | m1;            /* no. of minterms */
   m3 = mb*nspm+4;                     /* total no. of bytes */

   /***
    ***  COMPARING MINTERMS
    ***/

   printf("\nPlease Hang On, Comparing Minterms ... \n\n");

   if (na !=  nb)                      /* unequal no. of variables */
      {
	 printf("Different number of variables in the 2 files. \n");
	 printf("Program Terminated - 3 \n");
	 exit(0);
      }

   if (ma != mb)                      /* unequal no. of minterms */
      {
	 printf("Different number of minterms produced from the 2 files.\n");
	 printf("Program Terminated - 4 \n");
	 exit(0);
      }

   printf("Please Hang On, Doing comparison ... \n\n");

   test = memcmp(a, b, m3);           /* compare all minterms and header */

   if (test != 0)                     /* not exactly the same */
      {
	 printf("Minterms produced from the 2 files are different .\n");
	 printf("Solution array obtained is incorrect. \n");
	 printf("Program Terminated - 5 \n");
	 exit(0);
      }

   printf("Minterms produced from the files, %s and %s are equal.\n", infile, outfile);

   free(a);                          /* free pointers */
   free(b);
   free(infile);
   free(outfile);
}
