/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#ifdef __MSDOS__
/*#define MEMTRACK*/
#include <memtrack.h>
#include <memory.h>
#include <string.h>
#include <process.h>
#include <direct.h>
#include <errno.h>
#include <io.h>
#include <ctype.h>
#include <sys\types.h>
#include <sys\stat.h>
#define         W_OK          02
#define         F_OK          00
#define         R_OK          04
/*#define touchline(WIN,START,NUM)       touchwin(WIN)*/
#define PROTO
#define SLASH '\\'
#define STR_SLASH "\\"
#define CURRENT_DIR "."
#define FMODE (0)
/*#define FMODE (S_IREAD | S_IWRITE)*/
#endif

#ifdef __OS2__
/*#define MEMTRACK*/
#include <memtrack.h>
#include <memory.h>
#include <string.h>
#include <process.h>
#include <errno.h>
#include <ctype.h>
#include <sys\types.h>
#include <sys\stat.h>
#define         W_OK          02
#define         F_OK          00
#define         R_OK          04
/*#define touchline(WIN,START,NUM)       touchwin(WIN)*/
#define PROTO
#define SLASH '\\'
#define STR_SLASH "\\"
#define CURRENT_DIR "."
#define FMODE (0)
/*#define FMODE (S_IREAD | S_IWRITE)*/
#endif

#ifdef M_XENIX
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "mem.h"
#include <memory.h>
#include <string.h>
#include <sys/file.h>
#define         F_OK          00
#define         W_OK          02
#define         R_OK          04
#define SLASH '/'
#define STR_SLASH "/"
#define CURRENT_DIR "."
#define touchline(WIN,START,NUM)       touchwin(WIN)
#define UNIX 1
#endif

#ifdef SYSV386
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "memtrack.h"
#include <memory.h>
#include <string.h>
#include <sys/file.h>
#include <unistd.h>
#define SLASH '/'
#define STR_SLASH "/"
#define CURRENT_DIR "."
#define FMODE (0)
#define UNIX 1
#endif

#ifdef SUN
#include "memtrack.h"
#include <memory.h>
#include <string.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#define SLASH '/'
#define STR_SLASH "/"
#define CURRENT_DIR "."
/*#define FMODE (S_IRWXU | S_IRGRP | S_IROTH)*/
#define FMODE (0)
#ifdef BSD
#define chtype short
#endif
#define UNIX 1
#endif

#ifdef MINIX
#include <string.h>
#define short int
#define CURRENT_DIR "."
#define UNIX 1
#endif

#ifdef VMS
#include "memtrack.h"
#include <string.h>
#include <file.h>
#include <types.h>
#include <stat.h>
#include <ctype.h>
#define         W_OK          02
#define         F_OK          00
#define         R_OK          04
#define SLASH ']'
#define STR_SLASH "]"
#define CURRENT_DIR "[]"
/*#define FMODE (S_IRWXU | S_IRGRP | S_IROTH)*/
#define FMODE (0)
#ifdef BSD
#define chtype short
#endif
#define touchline(WIN,START,NUM)       touchwin(WIN)
/* #define isdigit(c)   (_ctype[(c) + 1] & 2)
#define islower(c)   (_ctype[(c) + 1] & 8)
#define isupper(c)   (_ctype[(c) + 1] & 4)*/
#endif

#include <curses.h>

#ifndef A_NORMAL
/* Various video attributes */
#ifdef BSD
#define A_STANDOUT      _STANDOUT    /* for compatability with old curses */
#else
#define A_STANDOUT      000000200000L
#endif
#define A_UNDERLINE     000000400000L
#define A_REVERSE       000001000000L
#define A_BLINK         000002000000L
#define A_DIM           000004000000L
#define A_BOLD          000010000000L
#define A_ALTCHARSET    000100000000L

/* The next two are subject to change so don't depend on them */
#define A_INVIS         000020000000L
#define A_PROTECT       000040000000L

#define A_NORMAL        000000000000L
#define A_ATTRIBUTES    037777600000L   /* 0xFFFF0000 */
#define A_CHARTEXT      000000177777L   /* 0x0000FFFF */
#endif

#ifndef max
#define max(a,b)        (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)        (((a) < (b)) ? (a) : (b))
#endif

#ifndef getmaxy
#ifdef VMS
#define getmaxy(win)    ((win)->_max_y)
#else
#define getmaxy(win)    ((win)->_maxy)
#endif
#endif

#ifndef getmaxx
#ifdef VMS
#define getmaxx(win)    ((win)->_max_x)
#else
#define getmaxx(win)    ((win)->_maxx)
#endif
#endif

#define MAX_FILE_NAME 255

#define OFF             0
#define ON              1
#define NO              0
#define YES             1
#define NA              2

#ifndef OK
#define OK              1
#endif

#define ERROR         (-1)
#define QUIT          (-2)
#define SKIP          (-3)
#define QUITOK        (-4)
#define RAW_KEY       (128)

#define MAX_SCREENS         2             /* maximum number of screens*/
#define VIEW_WINDOWS        5             /* number of windows per view */
#define MAX_FILES           5             /* maximum number of open files */
#define MAX_VIEWS           2             /* number of views per file */
#define MAX_INT             65535         /* maximum size for integer */
#define MAX_LONG            2147483001    /* maximum size for long */
#define TARGET_ERROR        -2147483000   /* number returned as target error */
#define TARGET_NOT_FOUND    -2147483001   /* number returned not found target */
#define TOP_OF_FILE         "*** Top of File ***"
#define BOTTOM_OF_FILE      "*** Bottom of File ***"
#define DIRECTION_FORWARD   1
#define DIRECTION_BACKWARD  (-1)

#define UNDEFINED_OPERAND (-1)

#define WINDOW_MAIN     0
#define WINDOW_PREFIX   1
#define WINDOW_COMMAND  2
#define WINDOW_ARROW    3
#define WINDOW_IDLINE   4
#define WINDOW_FOOTING  5
#define WINDOW_ERROR    6
#define WINDOW_DIVIDER  7

#define PREFIX_WIDTH    6

#define CURRENT_VIEW              (vd_current)
#define PREVIOUS_VIEW             (vd_current->prev)
#define NEXT_VIEW                 (vd_current->next)

#define CURRENT_FILE              (vd_current->file_for_view)
#define CURRENT_WINDOW            (vd_current->win[vd_current->current_window])
#define CURRENT_WINDOW_MAIN       (vd_current->win[WINDOW_MAIN])
#define CURRENT_WINDOW_PREFIX     (vd_current->win[WINDOW_PREFIX])
#define CURRENT_WINDOW_COMMAND    (vd_current->win[WINDOW_COMMAND])
#define CURRENT_WINDOW_ARROW      (vd_current->win[WINDOW_ARROW])
#define CURRENT_WINDOW_IDLINE     (vd_current->win[WINDOW_IDLINE])

#define MARK_VIEW (vd_mark)
#define MARK_FILE (vd_mark->file_for_view)

#define CURRENT_SCREEN (screen[current_screen])
#define OTHER_SCREEN (screen[(current_screen == 0) ? 1 : 0])

struct line
 {
  unsigned short length;              /* number of characters in line */
  unsigned char *line;                /* pointer to contents of line */
  unsigned char display;              /* display level for each line */
  struct line *prev;                  /* pointer to previous line */
  struct line *next;                  /* pointer to next line */
 };
typedef struct line LINE;

struct targets
 {
  unsigned char *prefix;              /* pointer to target prefix */
  short length;                       /* length of prefix */
  unsigned char delim;                /* target delimiter */
  char direction;                     /* search direction for target */
 };
typedef struct targets SEARCH_TARGET;

typedef struct
 {
  unsigned char autosave;             /* number of alterations before autosaving */
  unsigned char eolout;               /* indicates how lines are terminated on output */
  unsigned char status_row;           /* row on which status line is displayed */
  unsigned char tabsout_on;           /* indicates if tabs to replace spaces on file */
  unsigned char tabsout_num;          /* length of tab stops on file */
  unsigned short autosave_alt;        /* number of alterations since last autosave */
  unsigned short save_alt;            /* number of alterations since last save */
  FILE *fp;                           /* file handle for this file */
  unsigned char *fname;               /* file name */
  unsigned char *fpath;               /* file path */
  unsigned short fmode;               /* file mode of file */
  LINE *first_line;                   /* pointer to first line */
  LINE *curr_line;                    /* pointer to current line */
  LINE *last_line;                    /* pointer to last line */
  unsigned long  number_lines;        /* number of actual lines in file */
  unsigned char file_views;           /* number of views of current file */
 } FILE_DETAILS;

struct view_details
 {
  unsigned char cmd_line;             /* line where command line is displayed */
  unsigned char command_row;          /* row on which command line is displayed */
  unsigned char error_row;            /* row on which errors are to be displayed */
  unsigned char tab_row;              /* row on which tab line is displayed */
  unsigned char tab_on;               /* indicates if tab line is to be displayed */
  unsigned char scale_row;            /* row on which scale row is displayed */
  unsigned char scale_on;             /* indicates if scale is displayed */
  unsigned char current_row;          /* row which is current row */
  unsigned char prefix_on;            /* indicates if prefix is displayed */
  unsigned char prefix_left;          /* indicates if prefix is displayed on left */
  unsigned char case_enter;           /* indicates case of data entered */
  unsigned char case_locate;          /* indicates case of data located */
  unsigned char case_change;          /* indicates case of data changed */
  unsigned char stay;                 /* indicates status of STAY */
  unsigned char tabs;                 /* tab stop increments */
  unsigned short verify_col;          /* left col for current verify */
  unsigned short verify_start;        /* col of start of verify */
  unsigned short verify_end;          /* col of end of verify */
  unsigned short zone_start;          /* col of start of zone */
  unsigned short zone_end;            /* col of end of zone */
  long  current_line;                 /* line in file displayed on current row */
  long  focus_line;                   /* line in file where cursor is */
  long  mark_start_line;              /* first line to be marked */
  long  mark_end_line;                /* last line to be marked */
  WINDOW *win[VIEW_WINDOWS];          /* curses windows for the file contents */
  unsigned char current_window;       /* current window for current file */
  unsigned char previous_window;      /* previous window for current file */
  FILE_DETAILS *file_for_view;        /* pointer to file structure */
  struct view_details *prev;          /* pointer to previous view */
  struct view_details *next;          /* pointer to next view */
 };
typedef struct view_details VIEW_DETAILS;

typedef struct
 {
  unsigned char origin_x;             /* top left corner of physical screen */
  unsigned char origin_y;
  unsigned char screen_rows;          /* physical rows */
  unsigned char screen_cols;          /* physical cols */
  unsigned char rows;                 /* rows in data window */
  unsigned char cols;                 /* cols in data window */
  unsigned char top_row;              /* start row of data window */
  unsigned char top_col;              /* start col of data window */
  VIEW_DETAILS *screen_view;          /* view being displayed in this screen */
 } SCREEN_DETAILS;

#define STATUS_ROW         (screen_rows-1)
#define COMMAND_ROW        (screen_rows-2)
#define ERROR_ROW          1
#define TAB_ROW            6
#define TAB_ON             NO
#define SCALE_ROW          6
#define SCALE_ON           NO
#define PREFIX_ON          YES
#define CURSOR_ROW         COMMAND_ROW
#define CURSOR_COL         5
#define CURRENT_ROW_POS    0
#define CURRENT_ROW        0
#define ZONE_START         1
#define ZONE_END           MAX_INT

#define CASE_MIXED         'M'
#define CASE_UPPER         'U'
#define CASE_LOWER         'L'
#define CASE_IGNORE        'I'
#define CASE_RESPECT       'R'

#ifndef FILE_NORMAL
#define FILE_NORMAL        0
#endif

#ifndef FILE_READONLY
#define FILE_READONLY      1
#endif

#ifndef FILE_NEW
#define FILE_NEW          99
#endif

#define ADDCHAR            0
#define INSCHAR            1

#ifndef getbegyx
#define getbegyx(win,y,x)       (y = (win)->_begy, x = (win)->_begx)
#endif

/*---------------------- function definitions -------------------------*/
#ifdef PROTO
void set_defaults(void);
short defaults_for_first_file(void);
short get_profile(unsigned char *);
short get_file(unsigned char *);
LINE *read_file(FILE *,LINE *,unsigned char *);
void exit_clean(short);
void display_error(unsigned short,unsigned char *);
LINE *ll_add(LINE *,LINE *,unsigned short);
LINE *ll_del(LINE *,LINE *,char);
LINE *ll_find(LINE *,unsigned long);
void ll_free(LINE *);
LINE *add_line(LINE *,LINE *,unsigned char *,unsigned short);
VIEW_DETAILS *vll_add(VIEW_DETAILS *,VIEW_DETAILS *,unsigned short);
VIEW_DETAILS *vll_del(VIEW_DETAILS *,VIEW_DETAILS *,char);
void show_page(void);
void show_one_row(unsigned char *,unsigned short,unsigned short,LINE *);
char *meminschr(char *,unsigned char,short,short,short);
char *meminsmem(char *,char *,short,short,short,short);
char *memdelchr(char *,short,short,short);
short mempos(unsigned char *,short,unsigned char *,short);
short memposi(unsigned char *,short,unsigned char *,short);
short memcmpi(unsigned char *,unsigned char *,short);
short memne(unsigned char *,unsigned char,short);
long find_string(long,short *,char *,short,char,char,char);
void increment_alt(void);
unsigned char *new_filename(unsigned char *,unsigned char *,
                            unsigned char *,unsigned char *);
short splitpath(unsigned char *);
void put_char(WINDOW *,chtype,char);
void adjust_marked_block(char,long,long);
void add_to_recovery_list(char *,int);
int insert_new_line(unsigned char *,int,long,bool);
void get_from_recovery_list(int);
int parse_colours(char *,chtype *,chtype *,chtype *);
void set_colour(int,chtype,chtype,chtype);
#else
void set_defaults();
short defaults_for_first_file();
short get_profile();
short get_file();
LINE *read_file();
void exit_clean();
void display_error();
LINE *ll_add();
LINE *ll_del();
LINE *ll_find();
void ll_free();
LINE *add_line();
VIEW_DETAILS *vll_add();
VIEW_DETAILS *vll_del();
void show_page();
void show_one_row();
char *meminschr();
char *meminsmem();
char *memdelchr();
short mempos();
short memposi();
short memcmpi();
short memne();
long find_string();
void increment_alt();
unsigned char *new_filename();
short splitpath();
void put_char();
void adjust_marked_block();
void add_to_recovery_list();
int insert_new_line();
void get_from_recovery_list();
int parse_colours();
void set_colour();
#endif
/*---------------------- system specific redefines --------------------*/
#ifdef VAX
#define     wattrset     wsetattr
#define     A_REVERSE    _REVERSE
#define     A_BOLD       _BOLD
#endif
/*---------------------- global parameters ----------------------------*/
#define EOLOUT_LF                0
#define EOLOUT_CRLF              1
/*---------------------- attribute defines ----------------------------*/
#define ATTR_FILEAREA   0
#define ATTR_CURLINE    1
#define ATTR_BLOCK      2
#define ATTR_CBLOCK     3
#define ATTR_CMDLINE    4
#define ATTR_IDLINE     5
#define ATTR_MSGLINE    6
#define ATTR_ARROW      7
#define ATTR_PREFIX     8
#define ATTR_PENDING    9
#define ATTR_SCALE     10
#define ATTR_TOFEOF    11
#define ATTR_CTOFEOF   12
#define ATTR_TABLINE   13
#define ATTR_SHADOW    14
#define ATTR_STATAREA  15
#define ATTR_DIVIDER   16
#define ATTR_MAX       17

#ifdef MAIN
/*---------------------------------------------------------------------*/
/* Following is  for colour support.                                   */
/*---------------------------------------------------------------------*/

chtype colour[ATTR_MAX];
chtype save_fg[ATTR_MAX];
chtype save_bg[ATTR_MAX];
chtype save_mod[ATTR_MAX];

char tabkey_insert='C';
char tabkey_overwrite='T';
unsigned short mark_start_col=0;
unsigned short mark_end_col;
short max_line_length=2048;

#else

extern chtype colour[ATTR_MAX];
extern chtype save_fg[ATTR_MAX];
extern chtype save_bg[ATTR_MAX];
extern chtype save_mod[ATTR_MAX];

extern char tabkey_insert;
extern char tabkey_overwrite;
extern unsigned short mark_start_col;
extern unsigned short mark_end_col;
extern short max_line_length;
#endif
#define MAX_LINE_LENGTH     max_line_length /* maximum size for a line */

