/***********************************************************************/
/* COMM2.C - Commands F-J                                              */
/* This file contains all commands that can be assigned to function    */
/* keys or typed on the command line.                                  */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#include <stdio.h>
#include <stdlib.h>

#include "the.h"

/*#define DEBUG 1*/

/*-------------------------- external data ----------------------------*/
extern LINE *next_line,*curr_line;
extern VIEW_DETAILS *vd_current,*vd_first;
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern char current_file;         /* pointer to current file */
extern WINDOW *foot,*error_window;
extern char error_on_screen;
extern unsigned char *rec;
extern unsigned short rec_len;
extern unsigned char mode_insert;        /* defines insert mode toggle */
extern unsigned char in_profile;    /* indicates if processing profile */
extern unsigned char *tempfilename;
extern unsigned short file_start;
/*---------------------- function definitions -------------------------*/
#ifdef PROTO
void split_command(unsigned char *,unsigned char *,unsigned char *);
int param_split(unsigned char *,unsigned char *[],int );
long valid_target(unsigned char *);
int get_row_for_focus_line(int,long,long);
#else
void split_command();
int param_split();
long valid_target();
int get_row_for_focus_line();
#endif
#ifdef DOS
char get_mode(void);
#endif
/*man-start*********************************************************************
COMMAND
     ffile - force file the current file to disk

SYNTAX
     FFile  [filename]

DESCRIPTION
     The FFILE command writes the current file to disk to the current
     file name or to the supplied filename.
     Unlike the FILE command, if the optional filename exists, this
     command will overwrite the file.

COMPATIBILITY
     Compatible.

DEFAULT
     With no parameters, the current file is written.

SEE ALSO
     file,save,ssave

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Ffile(unsigned char *params)
#else
int Ffile(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm2.c:   Ffile");
#endif
 post_process_line(CURRENT_VIEW->focus_line);
 if (save_file(params,YES,0L,NO) == ERROR)
   {
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 free_view_memory();
#ifdef TRACE
 trace_return();
#endif
 return(QUIT);
}
/*man-start*********************************************************************
COMMAND
     file - file the current file to disk

SYNTAX
     FILE  [filename]

DESCRIPTION
     The FILE command writes the current file to disk to the current
     file name or to the supplied filename.
     Unlike the FFILE command, if the optional filename exists, this
     command will not overwrite the file.

COMPATIBILITY
     Compatible.

DEFAULT
     With no parameters, the current file is written.

SEE ALSO
     ffile,save,ssave

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int File(unsigned char *params)
#else
int File(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm2.c:   File");
#endif
 post_process_line(CURRENT_VIEW->focus_line);
/*---------------------------------------------------------------------*/
/* If we are filing the current file with the same name AND the number */
/* of alterations is zero, then quit the file.                         */
/*---------------------------------------------------------------------*/
 if (CURRENT_FILE->save_alt == 0 && strcmp(params,"") == 0)
    Quit("");
 else
   {
    if (save_file(params,NO,0L,NO) == ERROR)
      {
#ifdef TRACE
       trace_return();
#endif
       return(OK);
      }
    free_view_memory();
   }
#ifdef TRACE
 trace_return();
#endif
 return(QUIT);
}
/*man-start*********************************************************************
COMMAND
     forward - scroll forwards a number of screens

SYNTAX
     FORward [n]

DESCRIPTION
     The FORWARD command scrolls the file contents forwards the number
     of screens specified.

COMPATIBILITY
     Compatible.

DEFAULT
     With no parameters, 1 screen is scrolled.

SEE ALSO
     backward,top

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Forward(unsigned char *params)
#else
int Forward(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
#define FOR_PARAMS  1
 unsigned char *word[FOR_PARAMS+1];
 char parm[FOR_PARAMS];
 register int i;
 unsigned short num_params;
 long num_pages;
 unsigned short x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm2.c:   Forward");
#endif
 num_params = param_split(params,word,FOR_PARAMS);
 if (num_params == 0)
   {
    num_params = 1;
    word[0] = (unsigned char *)"1";
   }
 if (num_params != 1)
   {
    display_error(1,word[1]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if (strcmp(word[0],"*") == 0)
   {
    CURRENT_VIEW->current_line = CURRENT_FILE->number_lines+1;
    post_process_line(CURRENT_VIEW->focus_line);
    CURRENT_VIEW->focus_line = CURRENT_FILE->number_lines+1;
    pre_process_line(CURRENT_VIEW->focus_line);
    if (!in_profile)
      {
       getyx(CURRENT_WINDOW,y,x);
       wmove(CURRENT_WINDOW,CURRENT_VIEW->current_row,x);
       show_page();
      }
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if ((num_pages = atol(word[0])) == 0L)
   {
    display_error(4,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }

 CURRENT_VIEW->current_line =
    min(CURRENT_VIEW->current_line + (CURRENT_SCREEN.rows-1)*num_pages,
        CURRENT_FILE->number_lines+1);

 post_process_line(CURRENT_VIEW->focus_line);
 CURRENT_VIEW->focus_line = calculate_focus_line(CURRENT_VIEW->current_row,
                                                CURRENT_VIEW->focus_line,
                                                CURRENT_VIEW->current_line);
/* CURRENT_VIEW->focus_line =*/
/*    min(CURRENT_VIEW->focus_line + (CURRENT_SCREEN.rows-1)*num_pages,*/
/*        CURRENT_FILE->number_lines+1);*/
 pre_process_line(CURRENT_VIEW->focus_line);
 if (in_profile)
   {
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 getyx(CURRENT_WINDOW_MAIN,y,x);
 show_page();
 if (CURRENT_VIEW->current_window != WINDOW_COMMAND)
   {
    y = get_row_for_focus_line(CURRENT_VIEW->current_row,
                               CURRENT_VIEW->focus_line,
                               CURRENT_VIEW->current_line);
    wmove(CURRENT_WINDOW,y,x);
   }

#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     get - read another file into current file

SYNTAX
     GET [fileid]

DESCRIPTION
     The GET command reads a file into the current file, inserting
     lines after the current line.
     When no fileid is supplied the temporary file is used.

COMPATIBILITY
     Does not support optional fromlines - forlines.

SEE ALSO
     put,putd

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Get(unsigned char *params)
#else
int Get(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned char *filename;
 FILE *fp;
 LINE *curr;
 long old_number_lines;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm2.c:   Get");
#endif
 if (strcmp(params,"") == 0)   /* no fileid supplied */
    filename = tempfilename;
 else
    filename = params;

 post_process_line(CURRENT_VIEW->focus_line);

 if ((fp = fopen(filename,"r")) == NULL)
   {
    display_error(9,params);
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
 curr = ll_find(CURRENT_FILE->first_line,CURRENT_VIEW->current_line);
 if (curr->next == NULL)   /* on bottom of file */
    curr = curr->prev;
 old_number_lines = CURRENT_FILE->number_lines;
 if ((curr = read_file(fp,curr,filename)) == NULL)
   {
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }

 fclose(fp);
 pre_process_line(CURRENT_VIEW->focus_line);
/*---------------------------------------------------------------------*/
/* Fix the positioning of the marked block (if there is one and it is  */
/* in the current view).                                               */
/*---------------------------------------------------------------------*/
 adjust_marked_block(YES,CURRENT_VIEW->current_line,
                     CURRENT_FILE->number_lines - old_number_lines);
/*---------------------------------------------------------------------*/
/* Increment the number of lines counter for the current file and the  */
/* number of alterations.                                              */
/*---------------------------------------------------------------------*/
 increment_alt();
 show_page();
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     help - display help for the editor

SYNTAX
     HELP

DESCRIPTION
     The HELP command displays help for the editor.
     Uses THE_HELP environment variable to point to the help file.

COMPATIBILITY
     Should be similar.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Help(unsigned char *params)
#else
int Help(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
extern unsigned char help_pathname[80];
/*--------------------------- local data ------------------------------*/
 unsigned char *help_var;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm2.c:   Help");
#endif
 if ((help_var = (unsigned char *)getenv("THE_HELP")) == NULL)
   {
    if (file_exists(help_pathname))
       help_var = help_pathname;
    else
      {
       display_error(23,(unsigned char *)"");
#ifdef TRACE
       trace_return();
#endif
       return(OK);
      }
   }
 Edit(help_var);
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     input - insert the command line contents into the file

SYNTAX
     Input contents

DESCRIPTION
     The INPUT command inserts the remainder of the command line into the
     file aafter the current line.

COMPATIBILITY
     Should be similar.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Input(unsigned char *params)
#else
int Input(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 LINE *curr;
 unsigned long li;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm2.c:   Input");
#endif
 insert_new_line(params,strlen(params),1L,TRUE);
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     insertmode - put editor into insert mode

SYNTAX
     INSERTMode

DESCRIPTION
     The insertmode command toggles the insert mode within THE.

COMPATIBILITY
     Compatible.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Insertmode(unsigned char *params)
#else
int Insertmode(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm2.c:   Insertmode");
#endif
 mode_insert = (mode_insert) ? NO : YES;
#if defined(DOS) || defined(OS2)
 draw_cursor();
#endif
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
