#include "pt.h"
#include "time.h"

/* remember the menu number of the topline menu */
int toplineMenu = 0;

/* to support automatic saving */
time_t timeOfLastSave;

/* alternate open file table so we can open more than 20 files */
unsigned char far * fileHandleTable;

/* for finding TAGS */
unsigned char tagPattern[64];
unsigned char tagMarker[32];
unsigned char lastTag[STRINGSIZE];
unsigned char tagDTA[64];
long tagLastCp = -1;
int tagLastLine;

/* for finding keywords */
unsigned char lastKeyword[STRINGSIZE];
unsigned char keywordDTA[64];
long keywordLastCp = -1;
int keywordLastLine;

/* So that multiple ones will reduce to one message (used in pt.c) */
int supressFileMsgs = 0;

#ifdef OVERLAYS
/* names of the overlays */
unsigned char primaryOverlay[70];
unsigned char secondaryOverlay[70];
unsigned char overlayString[128];
unsigned char *overlayArguments;
int overlayState;
int quitExecuted = 0;
/* 0 ==> no overlay is active */
/* 1 ==> primary overlay only is loaded */
/* 2 ==> secondary overlay only is loaded */
/* 3 ==> primary and secondary overlays are both loaded */
/* 4 ==> unloading secondary overlay */

/* files to reopen after the overlay returns */
int filesToOpen = 0;
int primaryFilesToOpen = 0;
struct openFile *ffsToOpen[20];

/* overlay command pointers */
unsigned char *overlayMap[56];

#endif

/* to allow programming of the mouse sensitive window parts */
unsigned char windowPoints[10] = {28, 88, 28, 88, 28, 88, 28, 88, 66, 27};
/* windowPoints[0] => top left corner, left button */
/* windowPoints[1] => top left corner, middle button */
/* windowPoints[2] => top right corner, left button */
/* windowPoints[3] => top right corner, middle button */
/* windowPoints[4] => bottom left corner, left button */
/* windowPoints[5] => bottom left corner, middle button */
/* windowPoints[6] => bottom right corner, left button */
/* windowPoints[7] => bottom right corner, middle button */
/* windowPoints[8] => right border, left button */
/* windowPoints[9] => right border, right button */

/* character table for fillLine (in windtext.c) */
unsigned char charTable[256];

/* stack location */
unsigned char *stktop;

/* scratch file name */
unsigned char scratchFileName[FILENAMESIZE];

/* remember directories during getFileName */
unsigned char startDirectory[FILENAMESIZE];
unsigned char startDrive;
unsigned char currentDirectory[FILENAMESIZE];
unsigned char currentDrive;

/* keep records so we can move cursor consistently in vertical direction */
int lastColumn = -1;
int lastFn = 0;

/* mouse speed parameter */
int mouseSpeed = 4;

/* mouse motion parameters */
int quad22 = 25;
int quad45 = 45;
int quad67 = 175;

/* mouse motion commands */
int mouseVec1[9] = {
FCOPY, FBACKSEARCH, FDELETE, FMOVETO, FINSKEY,
FREPSEARCH, FREDO, FCOPYTO, FUNDO,
};

int mouseVec2[9] = {
FEXTEND, FGOBACKTO, FDELNOSCRAP, FEXCHSCRAP, FCANCEL,
FCONTEXTMENU, FBOTTOM, FCOPYSCRAP, FCLOSEWINDOW,
};

/* keyboard macro */
unsigned char macroText[102];
int macroIndex = 0;
int macroSize = 0;
int macroState = 0;

/* longjmp here in case of crtl-break */
jmp_buf breakEnv;

/* remember is there is a message showing on the bottom line */
int isMessage = 0;

/* file id for the "pt.msg" command descriptions file */
int descrFileId = -1;

/* remember whether to erase the description message */
int lastOnTopline = 0;

/* remember the last command the user selected (for help) */
int lastCommand = FHELP;

/* remember the top line menu that is currently showing */
int menuShowing = 0;	/* default to no menu */

/* for mouse button events */
int evhead, evtail;
struct event *evaddr;
struct event events[NEVENTS];

int passEvhead;
long passCp;

/* variable to remember the last character we ignored */
unsigned char lastIgnored;

/* current screen size */
int scrRows = 25;
int scrCols = 80;

/* piece table */
struct piece *freePList;
unsigned int bytesLeft;
unsigned int piecesLeft;

/* save the old video mode */
unsigned char saveVideoMode;

/* the globals additions file */
unsigned char addFile[65];
int addHandle;
long addPosition;

/* colors for window things -- global versions */
unsigned char textColor	= 0x07;	/* normal text */
unsigned char selColor	= 0x70;	/* selection */
unsigned char bannerColor= 0x70;	/* top line banner */
unsigned char borderColor= 0x07;	/* borders (other than the top) */
unsigned char elevColor	= 0x0F;	/* left border elevator */

struct colorCycle colorCycles[NCOLORCYCLES];
unsigned char maxTextCycles = 0;
unsigned char maxBorderCycles = 0;

/* global message colors */
unsigned char errorColor = 0xF0;	/* error messages */
unsigned char promptColor= 0x0F;	/* prompt messages */
unsigned char msgColor 	 = 0x07;	/* informational messages */
unsigned char topColor   = 0x07;	/* top menu line */

/* mouse menus */

/* space for menu items read from pt.ini (allocated in far * space) */
unsigned char far *menuSpace;
int nextSpace = 0;

struct menuBlock far *menus[NMENUS];
/* menu 0 is for dynamic menus (TOPLIST and help) */
/* menus 1 to NMENUS-1 are for users */

/* what to do with button presses inside or outside a window */
unsigned char buttonVector[64];

/* what to do with button presses on the top line */
unsigned char toplineVector[64];

/* debugging flag */
int debug = 0;

/* some option flags */
int autoSaveInterval = 0;
int autoScrollRate = 2;
int autoIndent = 1;
int nBuffers = 50;
int centerMenus = 0;
int cursorMouse = 0;
int doubleClickDelay = 50;
int fileSort = 2;
int findWholeWords = 0;
unsigned char fsDirs[200];
unsigned char fsPatterns[128];
unsigned char filePattern[64];
int fsMenu = 1;
int pathNames = 1;
int helpMode = 2;
int ignoreCase = 1;
int initialWindows = 0;
#ifdef OVERLAYS
int overlayVector = 0x61;
#endif
int maxFiles = 20;
int menuLine = 0;
int i43lines = 0;
int overType = 0;
int readOnly = 0;
int reSearch = 0;
int rightMargin = 999;
int scrollDelay = 75;
int scrollRate = 0;
int searchMode = 0;
	/* not an option, used to make backwards search circular */
	int realSearchMode = -1;
int smoothScroll = 1;
int tabWidth = 8;
int topOnFind = 0;
int linesOverFind = 4;
int undoSize = NHISTORY;
int unixMode = 0;
int videoMode = 0;

struct optionItem options[] = {
{"43lines",        O43LINES, &i43lines,    OBOOLEAN, FI43LINES},
{"findWholeWords", 0,     &findWholeWords, OBOOLEAN, FFINDWHOLEWORDS},
{"ignoreCase",     0,     &ignoreCase,     OBOOLEAN, FIGNORECASE},
{"searchMode",     0,     &searchMode,     OINTEGER, FSEARCHMODE},
{"topOnFind",      0,     &topOnFind,      OBOOLEAN, FTOPONFIND},
{"linesOverFind",  0,     &linesOverFind,  OINTEGER, FLINESOVERFIND},
{"filePattern",  0,(int *)&filePattern[0], OSTRING,  FFILEPATTERN},
{"autoSaveInterval",0,    &autoSaveInterval,OINTEGER,FAUTOSAVEINTERVAL},
{"autoScrollRate", 0,     &autoScrollRate, OINTEGER, FAUTOSCROLLRATE},
{"tabWidth",       0,     &tabWidth,       OINTEGER, FTABWIDTH},
{"autoIndent",     0,     &autoIndent,     OBOOLEAN, FAUTOINDENT},
{"rightMargin",    0,     &rightMargin,    OINTEGER, FRIGHTMARGIN},
{"overType",       0,     &overType,       OBOOLEAN, FOVERTYPE},
{"pathNames",      0,     &pathNames,      OBOOLEAN, FPATHNAMES},
{"doubleClickDelay",0,    &doubleClickDelay,OINTEGER,FDOUBLECLICKDELAY},
{"smoothScroll",   0,     &smoothScroll,   OBOOLEAN, FSMOOTHSCROLL},
{"centerMenus",    0,     &centerMenus,    OBOOLEAN, FCENTERMENUS},
{"helpMode",       0,     &helpMode,       OINTEGER, FHELPMODE},
{"textColors",     OTEXTCOLORS, &debug,    OOTHERS,  FTEXTCOLORS},
{"readOnly",       0,     &readOnly,       OBOOLEAN, FOREADONLY},
{"reSearch",       0,     &reSearch,       OBOOLEAN, FRESEARCH},
{"Redefine ...",   OREDEFINE, &debug,      OOTHERS,  FREDEFINE},
{"scrollRate",     0,     &scrollRate,     OINTEGER, FSCROLLRATE},
{"scrollDelay",    0,     &scrollDelay,    OINTEGER, FSCROLLDELAY},
{"borderColors",   OBORDERCOLORS, &debug,  OOTHERS,  FBORDERCOLORS},
{"msgColors",      OMSGCOLORS, &debug,     OOTHERS,  FMSGCOLORS},
{"tagPattern",     0,(int *)&tagPattern[0],OSTRING,  FTAGPATTERN},
{"fsPatterns",     OFSPATTERNS,&debug,     OOTHERS,  FFSPATTERNS},
{"buffers",        ONBUFFERS, &nBuffers,   OOTHERS,  -1},
{"fileSort",       0,     &fileSort,       OINTEGER, FFILESORT},
{"fsMenu",         0,     &fsMenu,         OINTEGER, FFSMENU},
{"fsDirs",         OFSDIRS,&debug,         OOTHERS,  FFSDIRS},
{"initialWindows", 0,     &initialWindows, OINTEGER, -1},
#ifdef OVERLAYS
{"overlayVector",  0,     &overlayVector,  OINTEGER, FOVERLAYVECTOR},
#endif
{"maxFiles",       0,     &maxFiles,       OINTEGER, -1},
{"tagMarker",      0,(int *)&tagMarker[0], OSTRING,  FTAGMARKER},
{"undoSize",       0,     &undoSize,       OINTEGER, -1},
{"unixMode",       0,     &unixMode,       OINTEGER, FUNIXMODE},
{"videoMode",      0,     &videoMode,      OINTEGER, FVIDEOMODE},
{"workDrive",      0,  (int *)&addFile[0], OSTRING,  -1},
{"",               OLASTITEM, &debug,      OINTEGER, FLASTOPTION}
};

/* location of the screen bit map */
unsigned int dispMemory;

/* save spaces */
int menuRow, menuCol;

/* some status (or mode) flags and move/copy pending data */
int mousePresent;
int mouseHorizontal, mouseVertical;
int movePending = 0;
int copyPending = 0;
struct window *pendWindow;
long pendPosition;

/* border types */
unsigned char border1[] = {222, 219, 221, 179, 179, 192, 196, 217};
unsigned char border2[] = {201, 205, 187, 186, 186, 200, 205, 188};
unsigned char border3[] = {178, 178, 178, 178, 178, 178, 178, 178};

/* screen masking buffer */
unsigned char sscreenMap[MAXROWS*MAXCOLS];
unsigned char *screenMap = sscreenMap;

/* value to reset screenMap to when a char is written */
unsigned char scrMapReset = 0;

/* screen buffer */
unsigned char sscreenChars[MAXROWS*(MAXCOLS<<1)];
unsigned char *screenChars = sscreenChars;

/* screen line buffer */
unsigned char screenLine[MAXCOLS<<1];

/* text line buffer */
unsigned char textBuffer[MSGBUFFERSIZE];

/* message buffer */
unsigned char msgBuffer[MSGBUFFERSIZE];

/* areas for bios calls */
union REGS rin, rout;

/* segment registers */
struct SREGS segRegs;

/* the list of active windows, top to bottom */
struct window *windowList = NULL;

/* the list of hidden windows, top to bottom */
struct window *hiddenList;

/* the active window */
struct window *activeWindow;

/* the window structures */
struct window *windows;

/* the open files */
struct openFile *files;

struct changeItem schange[NHISTORY];
struct changeItem *change = schange;
int nextChange = 0;
int tailChange = 0;

/* the scrap buffer */
struct changeItem scrapBuffer;
int scrapMode = SELCHAR;

/* the globals selection */
struct window *selWindow = NULL;
long selBegin, selEnd;
int selMode;

/* the file block buffers */
struct diskBuffer sBuffers[NBUFFERS];
struct diskBuffer *buffers = sBuffers;
unsigned char *bufferSpace;
int nextBuffer;		/* the next buffer to reuse */

/* buffer hash tables */
struct diskBuffer *bufHash[NBUFHASH];

int keyMap[133] = {
0,0,0,0/*nul*/,0,
0,0,0,0,0,
0,0,0,0,0,
/* alt letters 16-50 */
0/*s-TAB*/,FQUITASK/*a-Q*/,FWRITEFILE/*a-W*/,FEXCHSCRAP/*a-E*/,FREPLACE/*a-R*/,
FI43LINES/*a-T*/,FDEBUG/*a-Y*/,FUNDO/*a-U*/,FINFORM/*a-I*/,FOVERTYPE/*a-O*/,
FPLAYMACRO/*a-P*/,0,0,0,0,
FASCII/*a-A*/,FSAVEFILE/*a-S*/,FEXECSHELL/*a-D*/,0/*a-F*/,FGOTO/*a-G*/,
FHELP/*a-H*/,0/*a-J*/,0/*a-K*/,FLOADFILE/*a-L*/,0,
0,0,0,0,FZOOM/*a-Z*/,
FHIDE/*a-X*/,FCLOSEWINDOW/*a-C*/,0/*a-V*/,FBOTTOM/*a-B*/,FNEWWINDOW/*a-N*/,
FRECORDMACRO/*a-M*/,0,0,0,0,
0,0,0,0,FDELETE/*F1*/,
FINSKEY/*F2*/,FQUITSAVE/*F3*/,FCOPY/*F4*/,FKEYWORDSEL/*F5*/,FREPSEARCH/*F6*/,
FGOBACKTO/*F7*/,FREDO/*F8*/,FUNDO/*F9*/,FREDRAW/*F10*/,0,
0,FBEGINLINE/*Home*/,FCURUP/*up*/,FPGUP/*PgUp*/,0,
FCURLEFT/*left*/,0,FCURRIGHT/*right*/,0,FENDLINE/*End*/,
FCURDOWN/*down*/,FPGDN/*PgDn*/,FINSKEY/*Ins*/,FDELETE/*Del*/,
FDELNOSCRAP/*s-F1*/,
0/*s-F2*/,FQUITNOSAVE/*s-F3*/,FCOPYSCRAP/*s-F4*/,FKEYWORD/*s-F5*/,
							FSEARCH/*s-F6*/,
FGOTOSELECTION/*s-F7*/,FMATCHCHAR/*s-F8*/,FUNDOBACK/*s-F9*/,FLOADSEL/*s-F0*/,
0/*c-F1*/,0/*c-F2*/,FQUITASK/*c-F3*/,FMOVE/*c-F4*/,FTAGSEL/*c-F5*/,
							FBACKSEARCH/*c-F6*/,	
FGOTO/*c-F7*/,FTAG/*c-F8*/,FSELGOTO/*c-F9*/,FNEWSEL/*c-F0*/,0/*a-F1*/,
0/*a-F2*/,FQUITASK/*a-F3*/,FMOVE/*a-F4*/,FTAGSEL/*a-F5*/,FBACKSEARCH/*a-F6*/,
FGOTO/*a-F7*/,FTAG/*a-F8*/,FSELGOTO/*a-F9*/,FNEWSEL/*a-F0*/,0/*c-PrtSc*/,
FWORDLEFT/*c-left*/,FWORDRIGHT/*c-right*/,
0/*c-End*/,FBOTFILE/*c-PgDn*/,0/*c-Home*/,
0/*a-1*/,0/*a-2*/,0/*a-3*/,0/*a-4*/,0/*a-5*/,
0/*a-6*/,0/*a-7*/,0/*a-8*/,0/*a-9*/,0/*a-0*/,
0/*a--*/,0/*a-=*/,FTOPFILE/*c-PgUp*/
};

int asciiMap[132];
