#include "pt.h"
#include "malloc.h"
#include "string.h"
#include "stdlib.h"
#include "conio.h"
#include "io.h"

static unsigned char *buffer, *fileBuffer;
static int bufLeft = 0, bufferSize;
static int lineNumber;

void pascal
setGWBuffer( allocate )
	int allocate;
{
	if( allocate ) {
		bufferSize = 4096;
		while( 1 ) {
			fileBuffer = malloc(bufferSize);
			if( fileBuffer != NULL )
				break;
			bufferSize /= 2;
		}
	} else
		free(fileBuffer);
}

int pascal
/* XTAG:setup */
setup()
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern struct optionItem options[];
	extern int debug;
	extern union REGS rin, rout;
	extern unsigned char textColor, selColor;
	extern unsigned char bannerColor, borderColor, elevColor;
	extern unsigned char topColor;
	extern unsigned char windowPoints[];
	extern struct colorCycle colorCycles[];
	extern unsigned char maxTextCycles;
	extern unsigned char maxBorderCycles;

	int i, j, fid;
	register unsigned char *p;
	register unsigned char *item;
	int triedLocalIni;

	setGWBuffer(1);		/* allocate buffer space */

	triedLocalIni = 0;
	p = findFile("pt.ini");
	if( p == NULL )
		return 1;
	fid = openls(p, 0);

processLocalIni:
	lineNumber = 1;
	bufLeft = 0;
	buffer = fileBuffer;

	while( 1 ) {
		item = getWord(fid);
		if( item == NULL )
			break;
		if( *item == '\0' )
			continue;
		p = strchr(item, '=');
		if( p == NULL ) {
			if( *item != '[' ) {
				cprintf(
			"Missing '=' in pt%s.ini (line %d) item: \"%s\"\r\n",
					(triedLocalIni ? "local" : ""),
					lineNumber,
					item);
				goto contError;
			}
		} else
			*p++ = '\0';
		if( *item == '[' ) {
			setMenu(item,  fid);
			continue;
		}
		for(i = 0; options[i].index != OLASTITEM; i++) {
			for(j = 0; options[i].name[j] != '\0'; j++) {
				if( tolower(options[i].name[j])
				    != tolower(item[j]) )
					goto iContinue;
			}
/*************unixMode kludge -- temporary ***************/
if( strncmp(item, "unix", 4) == 0 )  options[i].type = OINTEGER;
			goto foundIt;
		iContinue:
			;
		}

		/* compute some things to check for invalid fields */
		j = isdigit(*(item+1));	/* second char is a digit */
		i = *(item+3) == '\0';	/* length is three */

		/* key definition? */
		if( tolower(*item) == 'k' && j ) {
			setKey(item, p);
			continue;
		}

		/* button definition? */
		if( tolower(*item) == 'b' && i ) {
			setButton(item, p);
			continue;
		}

#ifdef OVERLAYS
		/* overlay command definition? */
		if( tolower(*item) == 'c' && j ) {
			setOverlay(item, p);
			continue;
		}
#endif

		/* mouse motion 1 definition? */
		if( tolower(*item) == 'm' && j ) {
			setMMotion(1, item, p);
			continue;
		}

		/* mouse motion 2 definition? */
		if( tolower(*item) == 'n' && j ) {
			setMMotion(2, item, p);
			continue;
		}

		/* mouse motion quadrant definition? */
		if( tolower(*item) == 'q' && j ) {
			setMQuadrant(item, p);
			continue;
		}

		/* top line menu definition? */
		if( tolower(*item) == 't' && i ) {
			setTopline(item, p, 0);
			continue;
		}

		/* bottom line menu definition? */
		if( tolower(*item) == 'l' && i ) {
			setTopline(item, p, 1);
			continue;
		}

		/* window mouse point definition? */
		if( tolower(*item) == 'w' && (*(item+4)=='\0') ) {
			setWindowPoint(item, p);
			continue;
		}

		/* else we don't know what it is */
		cprintf("Unknown option name [%s] in pt%s.ini (line %d)\r\n",
			item, (triedLocalIni ? "local" : ""), lineNumber);
	contError:
		cprintf("Press any key to continue\r\n");
		incon();
		continue;
	foundIt:
		setOption(i, p, NULL);
	}
	closels(fid);
	
	/* see if there is a ptlocal.ini */
	if( !triedLocalIni ) {
		triedLocalIni = 1;
		fid = openls("ptlocal.ini", 0);
		if( fid >= 0 )
			goto processLocalIni;
	}
	
	/* set the first color cycle to the default colors */
	colorCycles[0].textColor = textColor;
	colorCycles[0].selColor = selColor;
	colorCycles[0].bannerColor = bannerColor;
	colorCycles[0].borderColor = borderColor;
	colorCycles[0].elevColor = elevColor;
	
	/* set the default color modes */
	if( maxTextCycles == 0 ) {
		maxTextCycles = 1;
		colorCycles[1].textColor = textColor;
		colorCycles[1].selColor = selColor;
	}
	if( maxBorderCycles == 0 ) {
		maxBorderCycles = 1;
		colorCycles[1].bannerColor = bannerColor;
		colorCycles[1].borderColor = borderColor;
		colorCycles[1].elevColor = elevColor;
	}

	setGWBuffer(0);		/* free buffer space */
	bufLeft = 0;
	return 0;
}

void pascal
/* XTAG:setTopline */
setTopline(s, value, onBottom)
	unsigned char *s, *value;
	int onBottom;
{
	extern unsigned char toplineVector[];
	extern int menuLine;
	extern int firstTopMenu;
	
	int shifts, buttons, commandNumber, i;

	if( (onBottom && menuLine > 0)
	 || (!onBottom && menuLine < 0) ) {
		cprintf("Mixing top and bottom menus in pt.ini\r\n");
		cprintf("Press any key to continue\r\n");
		incon();
		onBottom = !onBottom;
	}
	commandNumber = atoi(value);
	if( commandNumber == -1 )
		commandNumber = FDONOTHING;
	sscanf(&s[1], "%1x", &shifts);
	sscanf(&s[2], "%1x", &buttons);
	/* fix shifts so that either shift keys implies shift */
	/* shift over bit1 and OR bit0 with it */
	shifts = (shifts>>1) | (shifts&0x1);
	i = ((shifts&0x7)<<3) + (buttons&0x7);
	toplineVector[i] = (unsigned char)commandNumber;
	if( onBottom )
		--menuLine;
	else
		++menuLine;
}

void pascal
/* XTAG:setButton */
setButton(s, value)
	unsigned char *s, *value;
{
	extern unsigned char buttonVector[];
	
	int shifts, buttons, commandNumber, i;
	
	commandNumber = atoi(value);
	if( commandNumber == -1 )
		commandNumber = FDONOTHING;
	sscanf(&s[1], "%1x", &shifts);
	sscanf(&s[2], "%1x", &buttons);
	i = ((shifts&0x7)<<3) + (buttons&0x7);
	buttonVector[i] = (unsigned char)commandNumber;
}

void pascal
/* XTAG:setMMotion */
setMMotion(which, s, value)
	int which;
	unsigned char *s, *value;
{
	extern int mouseVec1[];
	extern int mouseVec2[];
	
	int commandNumber, i;
	
	commandNumber = atoi(value);
	if( commandNumber == -1 )
		commandNumber = FDONOTHING;
	i = *++s - '0';
	if( i < 0 || i > 8 )
		return;
	if( which == 1 )
		mouseVec1[i] = commandNumber;
	else
		mouseVec2[i] = commandNumber;
}

void pascal
/* XTAG:setWindowPoint */
setWindowPoint(s, value)
	register unsigned char *s;
	unsigned char  *value;
{
	extern unsigned char msgBuffer[];
	extern unsigned char windowPoints[];
	
	int commandNumber, n;
	
	commandNumber = atoi(value);
	if( commandNumber == -1 )
		commandNumber = FDONOTHING;
	/* look at the second character of the string */
	switch( *++s ) {
		case 't': n = 0; break;	/* top left or right corner */
		case 'b': n = 4; break;	/* bottom left or right corner */
		default: n = 8; break;	/* right border */
	}
	++s;	/* move to the third character in the string */
	if( n == 8 ) {	/* right border */
		/* skip the third character */
		if( *++s == 'r' )	/* right button */
			n = 9;
	} else {	/* all 4 corners */
		if( *s == 'r' )	/* top or bottom right corner */
			n += 2;
		if( *++s == 'm' )	/* middle button */
			++n;
	}
	windowPoints[n] = (unsigned char)commandNumber;
}
 
void pascal
/* XTAG:setMQuadrant */
setMQuadrant(s, value)
	unsigned char *s, *value;
{
	extern int quad22, quad45, quad67;
	
	int degrees;
	
	degrees = atoi(value);
	if( s[1] == '1' )
		quad67 = degrees;
	else if( s[1] == '2' )
		quad45 = degrees;
	else
		quad22 = degrees;
}

void pascal
/* XTAG:copyStringToMenuSpace */
copyStringToMenuSpace(value)
	unsigned char *value;
{
	extern unsigned char far *menuSpace;
	extern unsigned char *userMessages[];
	extern int nextSpace;
	
	while( 1 ) {
		/* skip the initial " with the preincrement ++ */
		menuSpace[nextSpace++] = *++value;
		if( nextSpace >= MENUSPACE ) {
			cprintf(userMessages[MENUSPMSG]);
			break;
		}
		if( *value == '\0' ) {
			--nextSpace;
			/* eliminate the  final " (if there is one) */
			if( menuSpace[nextSpace-1] == '"' )
				menuSpace[nextSpace-1] = '\0';
			else
				++nextSpace;
			break;
		}
	}
}

#ifdef OVERLAYS
void pascal
/* XTAG:setOverlay */
setOverlay(s, value)
	unsigned char *s, *value;
{
	extern unsigned char *overlayMap[];
	extern unsigned char far *menuSpace;
	extern unsigned char *userMessages[];
	extern int nextSpace;
	
	int commandNumber;
	
	commandNumber = atoi(&s[1]) - 200;
	if( commandNumber < 0 || commandNumber > 55 ) {
		cprintf("command %d redefinition is out of range.\r\n",
			commandNumber+200);
		incon();
		return;
	}

IF WE EVER PUT BACK IN OVERLAYS, FIX THIS UP SINCE IT WILL NOT WORK
NOW THAT WE HAVE MOVE THE menuSpace AREA OUT OF THE DATA SEGMENT
	overlayMap[commandNumber] = &menuSpace[nextSpace];
	copyStringToMenuSpace(value);
}
#endif

void pascal
/* XTAG:setKey */
setKey(s, value)
	unsigned char *s, *value;
{
	extern int keyMap[];
	extern int asciiMap[];
	
	int key, commandNumber;
	
	commandNumber = atoi(value);
	if( commandNumber == -1 )
		commandNumber = FDONOTHING;
	key = atoi(&s[1]);
	if( s[1] == '0' )
		keyMap[key] = commandNumber;
	else
		asciiMap[key] = commandNumber;
}

void pascal
/* XTAG:setMenu */
setMenu(s, fid)
	unsigned char *s;
	int fid;
{
	extern unsigned char msgBuffer[];
	extern unsigned char far *menuSpace;
	extern unsigned char *userMessages[];
	extern struct menuBlock far *menus[];
	extern int nextSpace;

	int n, menuNumber, itemNumber;
	register unsigned char *item;
	register unsigned char *p;

	menuNumber = atoi(&s[1]);

	/* see if the menu number is in the correct range */
	if( menuNumber < 1 || menuNumber >= NMENUS ) {
		cprintf("Menu number %d is out of range\r\n", menuNumber);
	menuError:
		cprintf("Press any key to continue\r\n");
		incon();
		return;
	}

	/* Now allocate the space for the menu block */
	if( menus[menuNumber] != (struct menuBlock far *)NULL ) {
		/* FREE THE STRINGS IN THE MENUBLOCK ???????? */
	} else {
		menus[menuNumber] = (struct menuBlock far *)
					_fmalloc(sizeof(struct menuBlock));
	}

	itemNumber = 0;
	while( 1 ) {
		item = getWord(fid);
		if( item == NULL || *item == ']' )
			break;
		p = strchr(item, '=');
		if( p == NULL ) {
			cprintf("Missing '=' in pt.ini item: \"%s\"\r\n",
				item);
			goto menuError;
		}
		*p++ = '\0';
		menus[menuNumber]->cmdName[itemNumber] =
							&menuSpace[nextSpace];
		copyStringToMenuSpace(item);
		while( 1 ) {
			/* skip the initial " with the preincrement ++ */
			menuSpace[nextSpace++] = *++item;
			if( nextSpace >= MENUSPACE ) {
				cprintf(userMessages[MENUSPMSG]);
				goto menuError;
			}
			if( *item == '\0' ) {
				--nextSpace;
				/* eliminate the  final " (if there is one) */
				if( menuSpace[nextSpace-1] == '"' )
					menuSpace[nextSpace-1] = '\0';
				else
					++nextSpace;
				break;
			}
		}
		menuSpace[nextSpace++] = '\0';
		n = atoi(p);
		if( n == -1 )
			n = FDONOTHING;
		menus[menuNumber]->cmdNumber[itemNumber] = n;
		if( ++itemNumber >= MAXMENUITEMS ) {
			cprintf("More than %d items in menu %d.  "
				"Extra items ignored.\r\n",
				MAXMENUITEMS, menuNumber);
			/* skip to the end of this menu */
			while( 1 ) {
				item = getWord(fid);
				if( item == NULL || *item == ']' )
					break;
			}
			menus[menuNumber]->nItems = itemNumber - 1;
			cprintf("More than %d items on menu %d. "
				"Reduce menu size to %d or fewer",
				MAXMENUITEMS, menuNumber, MAXMENUITEMS);
			goto menuError;
		}
	}
	menus[menuNumber]->nItems = itemNumber;
}

#ifdef OPTIONMENU
void pascal
/* XTAG:doOptions */
doOptions(w)
	struct window *w;
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern struct optionItem options[];
	extern int menuRow, menuCol;
	extern unsigned char far *menuSpace;
	extern struct menuBlock far *menus[];
	extern int nextSpace;
	extern unsigned char msgColor, promptColor, errorColor, topColor;
	extern int scrRows, scrCols;
	
	unsigned char *s, buffer[64];
	int n, iMenu, iOption, option;

	menus[0]->cmdName[0] = (unsigned char far *)"OPTIONS";
	menus[0]->cmdNumber[0] = 99;
	iMenu = nextSpace;
	iOption = 1;
	for(n = 0; options[n].index != OLASTITEM; n++ ) {
		switch( options[n].type ) {
		case OBOOLEAN:
THIS WILL NOT WORK SINCE WE MOVED menuSpace OUT OF THE DATA SEGMENT
			sprintf(&menuSpace[iMenu], "%s is %s",
				options[n].name,
				(*(options[n].variable) ? "On" : "Off") );
			break;
		case OINTEGER:
THIS WILL NOT WORK SINCE WE MOVED menuSpace OUT OF THE DATA SEGMENT
			sprintf(&menuSpace[iMenu], "%s = %d",
				options[n].name, *(options[n].variable));
			break;
		case OSTRING:
THIS WILL NOT WORK SINCE WE MOVED menuSpace OUT OF THE DATA SEGMENT
			sprintf(&menuSpace[iMenu], "%s = %s",
				options[n].name, options[n].variable);
			break;
		case OOTHERS:
			switch(options[n].index) {
			case OTEXTCOLORS:
				if( w == NULL )
					/* do not show this option */
					continue;
				else
THIS WILL NOT WORK SINCE WE MOVED menuSpace OUT OF THE DATA SEGMENT
					sprintf(&menuSpace[iMenu],
					  "%s = %02X%02X", options[n].name,
					  w->textColor, w->selColor);
				break;
			case OBORDERCOLORS:
				if( w == NULL )
					/* do not show this option */
					continue;
				else
THIS WILL NOT WORK SINCE WE MOVED menuSpace OUT OF THE DATA SEGMENT
					sprintf(&menuSpace[iMenu],
					  "%s = %02X%02X%02X",
					  options[n].name, w->bannerColor,
					  w->borderColor, w->elevColor);
				break;
			case OMSGCOLORS:
				if( w == NULL )
					/* do not show this option */
					continue;
				else
THIS WILL NOT WORK SINCE WE MOVED menuSpace OUT OF THE DATA SEGMENT
					sprintf(&menuSpace[iMenu],
					  "%s = %02X%02X%02X%02X",
					  options[n].name, msgColor,
					  promptColor, errorColor, topColor);
				break;
			case OREDEFINE:
THIS WILL NOT WORK SINCE WE MOVED menuSpace OUT OF THE DATA SEGMENT
				sprintf(&menuSpace[iMenu], "%s",
					options[n].name);
			}
			break;
		default:
			continue;
		}
		menus[0]->cmdName[iOption] =
				(unsigned char far *)&(menuSpace[iMenu]);
		iMenu += strlen(&(menuSpace[iMenu])) + 1;
		if( iMenu >= MENUSPACE ) {
			msg("setup: Menu Overflow!!!", 3);
			break;
		}
		menus[0]->cmdNumber[iOption] = n;
		++iOption;
	}
	menus[0]->nItems = iOption;
	option = menu(menus[0], menuRow, menuCol);
	if( option == 99 )
		return;
	n = options[option].type;
	if( n == OINTEGER || n == OSTRING ) {
		if( n == OINTEGER )
			sprintf(buffer, "%d", *(options[option].variable));
		else
			strcpy(buffer,
				(unsigned char *)options[option].variable);
		sprintf(textBuffer, "New value for option `%s': ",
			options[option].name );
		s = getInput(textBuffer, buffer, 0);
		if( s == NULL ) {
			msg("Option value not changed", 1);
			return;
		}
	} else
		s = NULL;
	setOption(option, s, w);
	redrawBox(0, 0, scrRows-1, scrCols-1);
	updateScreen(0, scrRows-1);
}
#endif

void pascal
/* XTAG:setOption */
setOption(option, s, w)
	int option;
	unsigned char *s;
	struct window *w;
{
	extern struct optionItem options[];
	extern unsigned int dispMemory;
	extern int cornerCols, cornerRows;
	extern int nBuffers;
	extern unsigned char msgColor, promptColor, errorColor;
	extern unsigned char topColor;
	extern unsigned char addFile[];
	extern int undoSize;
	extern int undoSize;
	extern union REGS rin, rout;
	extern int scrRows;
	extern int debug;
	extern int fileSort;
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern unsigned char fsDirs[];
	extern unsigned char fsPatterns[];
	
	int n;
	
	switch( options[option].type ) {

	case OBOOLEAN:
		if( w != NULL || s == NULL )
			*(options[option].variable) =
						!*(options[option].variable);
		else {
			if( isdigit(*s) )
				n = *s - '0';
			else if( tolower(*s) == 'y' )
				n = 1;
			else
				n = 0;
			*(options[option].variable) = n;
		}
		if( options[option].index == O43LINES )
			set43lines();
		break;

	case OINTEGER:
		*(options[option].variable) = atoi(s);
		break;

	case OSTRING:
		strcpy((unsigned char *)(options[option].variable), s);
		break;

	case OOTHERS:
	default:
		switch( options[option].index ) {
		case OFSDIRS:
			strncpy(&fsDirs[0], s, 200);
			break;
		case OFSPATTERNS:
			strncpy(&fsPatterns[0], s, 128);
			break;
		case OFILESORT:
			switch( tolower(*s) ) {
				case 'u': fileSort = 0; break;
				case 'n': fileSort = 1; break;
				case 'e':
				default:  fileSort = 2; break;
			}
			break;
		case OUNDOSIZE:
			n = atoi(s);
			if( n < 4 )
				undoSize = 4;
			else if( n > 100 )
				undoSize = 100;
			else
				undoSize = n;
			break;
		case ONBUFFERS:
			nBuffers = atoi(s);
			if( nBuffers < 5 )
				nBuffers = 5;
			else if( nBuffers > NBUFFERS )
				nBuffers = NBUFFERS;
			break;
		case OTEXTCOLORS:
			if( w != NULL )
				setColor(w);
			else
				doTextColors(s);
			break;
		case OBORDERCOLORS:
			if( w != NULL )
				setColor(w);
			else
				doBorderColors(s);
			break;
		case OMSGCOLORS:
			if( w != NULL )
				setColor(w);
			else {
				msgColor = convert(&s[0]);
				promptColor = convert(&s[2]);
				errorColor = convert(&s[4]);
				topColor = convert(&s[6]);
			}
			break;
		case OREDEFINE:
			redefine();
		}
		break;
	}
}

void pascal
/* XTAG:doTextColors */
doTextColors(s)
	unsigned char *s;
{
	extern struct colorCycle colorCycles[];
	extern unsigned char textColor, selColor;
	extern unsigned char maxTextCycles;

	register int i, cycle;

	textColor = convert(&s[0]);
	selColor = convert(&s[2]);
	if( s[4] == ';' )
		i = 5;
	else
		i = 0;
	cycle = 1;
	while( cycle < NCOLORCYCLES ) {
		colorCycles[cycle].textColor = convert(&s[i]);
		colorCycles[cycle].selColor = convert(&s[i+2]);
		if( s[i+4] != ',' )
			break;
		i += 5;
		++cycle;
	}
	maxTextCycles = (unsigned char)(cycle + 1);
}

void pascal
/* XTAG:doBorderColors */
doBorderColors(s)
	unsigned char *s;
{
	extern struct colorCycle colorCycles[];
	extern unsigned char bannerColor, borderColor, elevColor;
	extern unsigned char maxBorderCycles;

	register int cycle, i;

	bannerColor = convert(&s[0]);
	borderColor = convert(&s[2]);
	elevColor = convert(&s[4]);

	if( s[6] == ';' )
		i = 7;
	else
		i = 0;
	cycle = 1;
	while( cycle < NCOLORCYCLES ) {
		colorCycles[cycle].bannerColor = convert(&s[i]);
		colorCycles[cycle].borderColor = convert(&s[i+2]);
		colorCycles[cycle].elevColor = convert(&s[i+4]);
		if( s[i+6] != ',' )
			break;
		i += 7;
		++cycle;
	}
	maxBorderCycles = (unsigned char)(cycle + 1);
}

void pascal
/* XTAG:set43lines */
set43lines()
{
	extern unsigned int dispMemory;
	extern struct window *windowList;
	extern int menuLine;
	extern int i43lines;
	extern int debug;
	extern int scrRows;
	extern unsigned char msgBuffer[];
	extern union REGS rin, rout;

	int row, col;
	register struct window *w1;

	/* find out where the mouse is now so we can put it back */
	/* there after the video reset in initMouse */
	rin.x.ax = 3;
	int86(51, &rin, &rout);
	row = rout.x.dx>>3;
	col = rout.x.cx>>3;
	if( row > 24 )
		row = 12 * row / 21;
	initMouse(row, col, 1);

	row = (menuLine < 0 ? (scrRows-1) : 0);
	updateScreen(row, row);

	if( i43lines ) {
		/* resize all the windows */
		w1 = windowList;
		while( w1 != NULL ) {
			w1->row1 = (21*w1->row1)/12;
			w1->row2 = (21*w1->row2)/12;
			w1 = w1->nextWindow;
		}
	} else {
		/* resize all the windows */
		w1 = windowList;
		while( w1 != NULL ) {
			w1->row1 = (12*w1->row1)/21;
			if( menuLine > 0 && w1->row1 == 0 )
				w1->row1 = 1;
			if( menuLine < 0 && w1->row2 == (scrRows-1) )
				--(w1->row2);
			w1->row2 = (12*w1->row2)/21;
			w1 = w1->nextWindow;
		}
	}
}

unsigned char * pascal
/* XTAG:findFile */
findFile(name)
	unsigned char *name;
{
	extern unsigned char textBuffer[];
	
	unsigned char *env;
	int i;

	/* first look in the current directory */
	if( access(name, 0) == 0 )
		return name;
	/* now look in the PATH directories */
	env = getenv("PATH");
	if( env == NULL )
		return NULL;
	while( *env != '\0' ) {
		/* find the next directory name */
		i = 0;
		while( *env != ';' && *env != '\0' )
			textBuffer[i++] = *env++;
		if( textBuffer[i-1] != '\\' )
			textBuffer[i++] = '\\';
		textBuffer[i] = '\0';
		strcat(textBuffer, name);
		if( access(textBuffer, 0) == 0 )
			return &textBuffer[0];
		if( *env != '\0' )
			++env;
	}
	return NULL;
}

unsigned char pascal
/* XTAG:convert */
convert(s)
	unsigned char *s;
{
	register unsigned char n;
	unsigned char ch;
	
	ch = *s++;
	if( isdigit(ch) )
		n = ch - '0';
	else
		n = tolower(ch) - 'a' + 10;
	n *= 16;
	ch = *s;
	if( isdigit(ch) )
		n += ch - '0';
	else
		n += tolower(ch) - 'a' + 10;
	return n;
}

/* getWord reads in the next word from the stram fid */
/* It keeps initial white space. */
/* It skips the rest of the line after a comment "-" symbol. */
/* It gets all characters (including enbedded blanks) in */
/*  double quotes as a single word. */
unsigned char * pascal
/* XTAG:getWord */
getWord(fid)
	int fid;
{
	extern int debug;

	static unsigned char word[256];
	int i, n, inQuotes;
	unsigned char ch, lastCh;

	/* first skip white space */
startOver:
	while( 1 ) {
		if( bufLeft <= 0 ) {
			buffer = fileBuffer;
			n = readls(fid, buffer, MSGBUFFERSIZE);
			if( n <= 0 ) {
				return NULL;
			}
			bufLeft = n;
		}
		ch = *buffer++;
		--bufLeft;
		switch( ch ) {
		case '\n':
			++lineNumber;
		case ' ':
		case '\t':
		case '\r':
		case '\032':	/* control-Z */
			break;
		default:
			goto pastWhite;
		}
	}
pastWhite: 
	/* now skip comments */
	if( ch == '-' ) {
		/* skip to the end of the line */
		++lineNumber;
		while( 1 ) {
			if( bufLeft <= 0 ) {
				buffer = fileBuffer;
				n = readls(fid, buffer, MSGBUFFERSIZE);
				if( n <= 0 ) {
					return NULL;
				}
				bufLeft = n;
			}
			ch = *buffer++;
			--bufLeft;
			if( ch == '\n' )
				goto startOver;
		}
	}
	i = 0;
	inQuotes = 0;
	lastCh = 0;
	while( 1 ) {
		switch( ch ) {
		case '\n':
			++lineNumber;
		case ' ':
		case '\t':
		case '\r':
		case '\032':	/* control-Z */
			if( inQuotes )
				goto getChar;
			goto done;
		case '"':
			inQuotes = !inQuotes;
			/* two consecutive "s turns into one " */
			if( lastCh == '"' )
				--i;
		default:
		getChar:
			word[i++] = ch;
			break;
		}
		if( bufLeft <= 0 ) {
			buffer = fileBuffer;
			n = readls(fid, buffer, MSGBUFFERSIZE);
			if( n <= 0 ) {
				goto done;
			}
			bufLeft = n;
		}
		lastCh = ch;
		ch = *buffer++;
		--bufLeft;
	}
done:
	word[i] = '\0';
	return &word[0];
}
