#include "pt.h"

/* return 1 only if you see both buttons simultaneously down */
int pascal
/* XTAG:extend */
extend(w, cp,  anchorRow, anchorCol, evhead)
	register struct window *w;
	long cp;
	int anchorRow, anchorCol, evhead;
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern union REGS rin, rout;
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int selMode;
	extern unsigned char scrMapReset;
	extern struct window *pendWindow;
	extern int debug;

	int ret, n, row1, col1, col2, minRow, maxRow;
	long cp2, cp3, sb, limit;

	/* can only extend in the selection window */
	if( w != selWindow ) {
		return 0;
	}

	/* set the screen map for the visible parts of this window */
	setMap(w->row1, w->col1, w->row2, w->col2, 1, 0x07);
	maskTop(w);

	/* for now do not reset the screenMap when you write a char */
	/* this avoids constant recomputation of the screenMap */
	scrMapReset = 1;

	/* erase the selection if any part of it is in this window */
	if(  selBegin <= w->posBotline && selEnd >= w->posTopline ) {
		sb = selBegin;
		selBegin = selEnd + 1;
		row1 = w->row1 + 1;
		col1 = w->col1 + 1;
		col2 = w->col2 - 1;
		if( selEnd <= w->posBotline )
			limit = selEnd + 1;
		else
			limit = w->posBotline;
		cp2 = w->posTopline;
		minRow = maxRow = -1;
		while( cp2 < limit ) {
			n = 1;
			cp3 = nextLine(w->fileId, cp2, &n);
			if( sb <= cp3 ) {
				cp3 = fillLine(w, cp2, row1, col1, col2);
				if( minRow == -1 )
					minRow = row1;
				maxRow = row1;
			}
			cp2 = cp3;
			++row1;
			if( row1 >= w->row2 || cp3 == -1 )
				break;
		}
/*****
		if( maxRow != -1 )
			updateScreen(minRow, maxRow);
*****/
		selBegin = sb;
	}

	/* reset the selection for extension or contraction */
	/* reduce the selection to one selMode unit */
	/* only do it if we are not extending backwards */
	if( cp >= selBegin )
		modeExtend(w, selBegin, &cp2, &selEnd);

	/* as long as the button is down, follow the selection */
	if( evhead != -1 ) {	/* only "follow" for regular selections */
		ret = followSelection(w, anchorRow, anchorCol, evhead, 1);
	}

	/* selecting the end of line should include both CR and LF */
	if( readChar(w->fileId, selBegin) == '\n' ) {
		if( readChar(w->fileId, --selBegin) != '\r' )
			++selBegin;
	}

	/* restore the correct screen map reset value  */
	scrMapReset = 0;

	return ret;
}

void pascal
/* XTAG:modeExtend */
modeExtend(w, cp, begin, end)
	struct window *w;
	long cp, *begin, *end;
{
	extern int selMode;

	unsigned char ch;
	int n, fid;
	long cpLine, cpLow, cpHigh;

	/* find the beginning of the line */
	n = -1;
	cpLine = prevLine(w->fileId, cp, &n);
	
	fid = w->fileId;

	/* determine the initial selection */
	switch( selMode ) {

	case SELCHAR:
		*end = *begin = cp;
		ch = readChar(fid, cp);
		if( ch == '\r' ) {
			ch = readChar(fid, cp+1);
			if( ch == '\n' )
				++(*end);
		}
		break;

	case SELWORD:
		cpLow = cp;
		while( 1 ) {
			ch = readChar(fid, cpLow);
			if( cpLow <= cpLine || (!isalnum(ch) && ch != '_') )
				break;
			--cpLow;
		}
		if( !isalnum(ch) && ch != '_' && cpLow < cp )
			++cpLow;
		cpHigh = cp;
		while( 1 ) {
			ch = readChar(fid, cpHigh);
			if( !isalnum(ch) && ch != '_' )
				break;
			++cpHigh;
		}
		if( cpHigh > cp )
			--cpHigh;
		if( cpLow == cpHigh && readChar(fid, cpLow) == '\r'
					&& readChar(fid, cpLow+1) == '\n' )
		 	++cpHigh;
		*begin = cpLow;
		*end = cpHigh;
		break;

	case SELLINE:
		*begin = cpLine;
		n = 1;
		*end = nextLine(w->fileId, cpLine, &n) - 1;
		if( *end < *begin )
			*end = *begin;
		break;

	case SELALL:
		*begin = 0;
		*end = fileSize(w->fileId) - 1;
		break;
	}
}
