;; -*-mutt-*-
;; me2.h : ME2 Mutt constants 
;; C Durland	Public Domain

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;; Mutt Machine Variable Types ;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(const
  NUMBER	0x03
  BOOLEAN	0x05
  STRING	0x08
  LIST		0x09
  CHARACTER	0x0A
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;; Mark constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(const
  THE-DOT  0
  THE-MARK 1
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;; Buffer constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(const		;;; Buffer flags
	;; ME2 buffer flags
  BFModified	0x0001	;; 1 if the buffer has been modified since last save.
  BFNoCare	0x0002	;; Don't care about buffer contents.
  BFHidden	0x0004	;; Buffer is hidden from user.
  BFUndo	0x0008  ;; Undo bit.  Set => undo is on for buffer
  BFMode	0x0010	;; Tickle bit: force (modeline-hook) to be called
  BFImmortal	0x0020	;; Not a temporary buffer
  BFInteractive 0x0040	;; A buffer for humans

	;; Mutt extended buffer flags
  BFHidden2	0x0100  ;; Additional hidden flag for temp hiding

	;; Buffer flags I use a lot
  BFGone	0x0006	;; Hidden, no care and not modified
  BFHooHum	0x0026	;; Immortal, hidden, no care and not modified
  BFFoo		0x0022	;; Immortal, no care and not modified
)

(const		;;; Buffer names
  scratch-buffer "*Scratch*"
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;; Region constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(const
  DOT-ON-SAME-LINE-AS-MARK	1
  DOT-ABOVE-MARK		2
  MARK-ABOVE-DOT		3
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;; Bag constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(const
    ;; Bag types:
  BAG-IS-TEXT		0
  BAG-IS-RECTANGLE	1

    ;; Bags allocated by ME2:
  CUT-BUFFER		0

    ;; append-to-bag constants
  APPEND-TEXT		0
  APPEND-REGION		2
  APPEND-CHARACTERS	1
  APPEND-RECTANGLE	3
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;; Key codes ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(const
  Enter-key	0x014D
  Space-bar	0x0020
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;; Command completion constants ;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(const
  CC_SYS	0x01		;; system keywords
  CC_PGM	0x02		;; pgms
  CC_MUTT	0x04		;; Mutt keywords
  CC_BUF	0x08		;; buffer names
  CC_SYSVAR	0x10		;; sys vars
  CC_FNAME	0x20		;; file names
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;; Hook Constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	;; Constants used for register-hook (in hook.mut)
(const
   BUFFER-CREATED-HOOK	0
  IBUFFER-CREATED-HOOK	1	;; interactive (buffer-created-hook)
   READ-FILE-HOOK	2
  IREAD-FILE-HOOK	3	;; interactive (read-file-hook)
  ENTER-ME-HOOK		4
  LEAVE-ME-HOOK		5
  PROCESS-HOOK		6
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;; Process-hook Constants ;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(const
	;; event types
  PROCESS-DONE		0
  OUTPUT-STDOUT		1
  OUTPUT-STDERR		2
  PERROR		3
  CLIENT-MSG		5
)
