/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include <stdio.h>
#include <string.h>
#include "buffer.h"
#include "search.h"
int Case_Sensitive = 0;

#define upcase(ch) ((!Case_Sensitive && (ch <= 'z') && (ch >= 'a')) ? ch & 0xDF : ch)

/* This routine returns the 1 + position of first match of key in str.
   key is modified to match the case of str. */
/* We should try to optimize this routine */
/* searches from beg up to but not including end */
unsigned char *forw_search_region
    (unsigned char *beg,unsigned char *end, unsigned char *key, int key_len)
{
    char ch, ch2,char1;
    unsigned char *pos;
    int j, str_len;

    str_len = (int) (end - beg);
    if (str_len < key_len) return (NULL);
    str_len = str_len - key_len; /* effective length */
    end -= key_len;

    char1 = key[0];

    while(1)
      {
          while (ch = *beg, ch = upcase(ch), ch != char1)
            {
                if (beg >= end) return(NULL);
                beg++;
            }
          beg++;
          /* so we have a position of possible match */

          j = 1;
          pos = beg;  /* save this position so we start from here again */
          while(ch = *beg++, ch = upcase(ch),
   	        ch2 = key[j++], (ch == ch2) && (j <= key_len));

          if (j > key_len) return(pos - 1);
	  beg = pos;
      }
}

unsigned char *back_search_region(unsigned char *beg,unsigned char *end,
				  unsigned char *key, int key_len)
{
    char ch, ch2,char1;
    unsigned char *pos;
    int j, str_len;

    str_len = (int) (end - beg);
    if (str_len < key_len) return (NULL);
    str_len = str_len - key_len; /* effective length */
    beg += key_len;

    char1 = key[key_len - 1];

    while(1)
      {
          while (ch = *end, ch = upcase(ch), ch != char1)
            {
                if (beg > end) return(NULL);
                end--;
            }
          end--;
          /* so we have a position of possible match */

          j = key_len - 2;
          pos = end;  /* save this position so we start from here again */
          while(ch = *end--, ch = upcase(ch),
                ch2 = key[j], (ch == ch2) && (j >= 0)) j--;

          if (j < 0) return(end + 2);
          else end = pos;
      }
}

static int upcase_search_word(char *str, char *work)
{
   int len;

   if (Case_Sensitive)
     {
	strcpy((char *) work, (char *) str);
	len = strlen((char *) str);
     }
   else
     {
	len = 0;
	while (*str)
	  {
	     work[len++] = upcase(*str);
	     str++;
	  }
	work[len] = 0;
     }
   return(len);
}

int search(char *str, int dir, int n)
{
   unsigned char *beg, *end, *p, work[132];
   Line *line;
   int key_len;

   key_len = upcase_search_word(str, (char *) work);

   line = CLine;

   if (dir == 1)
     {
	beg = line->data + Point;
	end = line->data + line->len;
	do
	  {
	     if (NULL !=
		 (p = forw_search_region(beg, end, (unsigned char *) work,
					 key_len)))
	       {
		  CLine = line;
		  Point = (int) (p - line->data);
		  return(1);
	       }
	     line = line->next;
	     if (line == NULL) return(0);
	     beg = line->data;
	     end = line->data + line->len;
	  }
	while(--n);
     }
   else if (dir == -1)
     {
	beg = line->data - 1;
	if (Point) end = line->data + Point - 1; else end = beg;
	do
	  {
	     if (NULL !=
		 (p = back_search_region(beg, end, (unsigned char *) work,
					 key_len)))
	       {
		  CLine = line;
		  Point = (int) (p - line->data);
		  return(1);
	       }
	     line = line->prev;
	     if (line == NULL) return(0);
	     beg = line->data;
	     end = line->data + line->len;
	  }
	while (--n);
     }
   return(0);
}

int search_forward(char *s)
{
   return( search(s, 1, 0));
}
int search_backward(char *s)
{
   return( search(s, -1, 0));
}

int forward_search_line(char *s)
{
   return( search(s, 1, 1));
}

int backward_search_line(char *s)
{
   return( search(s, -1, 1));
}

