/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include <stdio.h>
#include <string.h>

#include "buffer.h"
#include "replace.h"
#include "search.h"
#include "screen.h"
#include "ins.h"

int replace_next(char *old, char *new)
{
    char *p;

    if (search(old, 1, 0) == 0) return(0);

    /* In the future, I will make this somewhat smart in the following way:
       If new = "Hello" and old = "heLLo" then replace it with "Hello".
       But if old is "World" and new is "hello", then replace it with "Hello".
       */

    while(1)
      {

	  if ((*old != 0) && (*new != 0))
	    {
	       p = (char *) (CLine->data + Point);
	       *p = *new;
	       Point++;
	    }

	  else if ((*old == 0) && (*new != 0)) ins((char) *new);
	  else if ((*old != 0) && (*new == 0)) del();
	  else if ((*old == 0) && (*new == 0))
	    {
		register_change(0);
		CBuf->flags |= BUFFER_TRASHED;
	    }

	  if ((*new == 0) && (*old == 0)) break;

	  if (*new != 0) new++;
	  if (*old != 0) old++;
      }
    return(1);
}

