/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include <stdio.h>
#include <string.h>
#include <setjmp.h>

#include "buffer.h"
#include "screen.h"
#include "window.h"
#include "display.h"
#include "sysdep.h"
#include "file.h"
#include "keymap.h"
#include "ledit.h"
#include "misc.h"
#include "ins.h"

char Error_Buffer[132];
char Message_Buffer[132];
volatile int KeyBoard_Quit;
int Exit_From_MiniBuffer;
extern jmp_buf Jump_Buffer;

char Macro_Buffer[255];
char *Macro_Buffer_Ptr;
char *Macro_Ptr_Max;
int Defining_Keyboard_Macro = 0;
int Executing_Keyboard_Macro = 0;

struct
{
   int def;
   int exe;
} Macro_State;

MiniInfo_Type Mini_Info;

void macro_store_key(char ch)
{
   /* I need to put something here to increase the size of the Macro_Buffer
      in case of overflow */

   *Macro_Buffer_Ptr++ = ch;
}

void restore_macro_state(void)
{
   Defining_Keyboard_Macro = Macro_State.def;
   Executing_Keyboard_Macro = Macro_State.exe;
}

void set_macro_state(void)
{
   Macro_State.def = Defining_Keyboard_Macro;
   Macro_State.exe = Executing_Keyboard_Macro;
}

/* if in the mini buffer and if during keyboard macro, allow user to enter
   different text each time macro is executed */

int macro_query()
{
   unsigned char *s;

   /* macro state is already set */
   Defining_Keyboard_Macro = 0;
   Executing_Keyboard_Macro = 0;

   if (!IS_MINIBUFFER)
     {
	s = (unsigned char *) mini_read("Enter String:", NULL);
	ins_chars(s, strlen((char *) s));
     }

   /* exit from mini restores the state */
   return(1);
}

int jed_getkey()
{
   int ch;

   if (!Executing_Keyboard_Macro)
     {
	ch = getkey();
	if (Defining_Keyboard_Macro) macro_store_key(ch);
     }
   else
     {
	ch = *Macro_Buffer_Ptr++;
     }
   return(ch);
}

void msg_error(char *msg)
{
    flush_input();
    Defining_Keyboard_Macro = Executing_Keyboard_Macro = 0;
    set_macro_state();

    if (!Lang_Error) Lang_Error = -1;
    if (Error_Buffer[0] != 0) return;
    strcpy(Error_Buffer, msg);
}

/* later I will do more with this-- for now, keep last one */
void message(char *msg)
{
   if (Error_Buffer[0] != 0) return;
   /* if (*Message_Buffer) do_dialog(Message_Buffer); */
   if (msg == NULL) *Message_Buffer = 0; else strcpy(Message_Buffer, msg);
   return;
}

/* read from minibuffer using prompt providing a default, and stuffing
   the minibuffer with init if necessary */
/* I should make recursive mini buffers */
int read_from_minibuffer(char *prompt, char *deflt, char *what)
{
   char buf[256];
   static Window_Type *current_window;
   /* may get changed if user leaves minibuffer and returns from other
      window which means that the new window becomes target of minibuffer action */
   Window_Type *w;
   int ret;

   if (!IS_MINIBUFFER) current_window = Window;
   if (select_minibuffer()) return(0);   /* we should be on a new line of mini buffer */

   if (prompt != NULL)
     {
	strcpy(Mini_Info.prompt, prompt); strcat(Mini_Info.prompt," ");
     }
   else *Mini_Info.prompt = 0;

   if ((deflt != NULL) && (*deflt != 0))
     {
	sprintf(buf,"(default: %s) ", deflt);
	strcat(Mini_Info.prompt, buf);
     }

   Mini_Info.prompt_len = strlen(Mini_Info.prompt);
   touch_window();
   ins_chars((unsigned char *) what, strlen(what));
   update((Line *) NULL);
   fflush(stdout);
   while(!Exit_From_MiniBuffer)
     {
	do_jed();
	/* if (setjmp(Jump_Buffer) != 0)
	  {
	     Exit_From_MiniBuffer = 1;
	  }  */

	if (KeyBoard_Quit && IS_MINIBUFFER) break;
	update((Line *) NULL);
     }
   if (Exit_From_MiniBuffer && !Executing_Keyboard_Macro 
       && (Repeat_Factor == NULL) && !Window->trashed && !input_pending(2,0))
     {
	goto_rc(Screen_Height, 1);
	fflush(stdout);
     }

   Exit_From_MiniBuffer = 0;
   restore_macro_state();
   *what = 0;
   ret = 1;
   if (KeyBoard_Quit) ret = 0;
   else if (CLine->len == 0)
     {
	if (deflt != NULL) strcpy(what, deflt);
     }
   /* problem if user manages to insert a neline in minibuffer */
   else
     {
	strncpy(what, (char *)CLine->data, CLine->len);
	what[CLine->len] = 0;
     }

   w = Window;
   while (w->next != Window) w = w->next;
   other_window();
   w->next = Window;
   /*  FREE(mini_w); do not free this, see The_MiniWindow */
   while(Window != current_window) other_window();
   Window->trashed = 1;

   /* delete_buffer(MiniBuffer); */
   MiniBuffer = NULL;
   return(ret);
}

void exit_error(char *str)
{
    fprintf(stderr,"\007\rFatal Error: %s\n", str);
    reset_display();
    reset_tty();
    if (CBuf != NULL) auto_save_all();
    exit(1);
}

int begin_keyboard_macro()
{
   Macro_Buffer_Ptr = Macro_Buffer;
   message("Defining Macro.");
   Defining_Keyboard_Macro = 1;
   set_macro_state();
   return(1);
}

int end_keyboard_macro()
{

    if (Defining_Keyboard_Macro) message("Macro Defined.");
    else
      {
	  if (!Executing_Keyboard_Macro) msg_error("Not defining Macro!");
	  Executing_Keyboard_Macro = 0;
	  return(1);
      }

   Macro_Ptr_Max = Macro_Buffer_Ptr;
   Defining_Keyboard_Macro = 0;
   set_macro_state();
   return(1);
}

int execute_keyboard_macro()
{
    int repeat = 0, *repeat_ptr;
    char ch;

    if (Defining_Keyboard_Macro)
      {
	  msg_error("Can't execute a macro while defining one.");
	  return(0);
      }

   Executing_Keyboard_Macro = 1;
   set_macro_state();
   Macro_Buffer_Ptr = Macro_Buffer;

   /* save the repeat context */
   repeat_ptr = Repeat_Factor;
   if (repeat_ptr != NULL) repeat = *repeat_ptr;

   Window->trashed = 1;
   while (Macro_Buffer_Ptr < Macro_Ptr_Max)
     {
	Repeat_Factor = NULL;
	ch = *Macro_Buffer_Ptr++;
	do_key(ch);
	if (KeyBoard_Quit || (*Error_Buffer)) break;
     }

   /* restore context */
   Repeat_Factor = repeat_ptr;
   if (repeat_ptr != NULL) *repeat_ptr = repeat;
   Executing_Keyboard_Macro = 0;
   set_macro_state();
   return(1);
}
