/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#ifndef __JED_BUFFER_H_  
#define  __JED_BUFFER_H_  
#include <stdlib.h>

#ifdef msdos
#include <alloc.h>
#define FREE(block)  farfree((void far *)(block))
#define MALLOC(x) farmalloc((unsigned long) (x))
#define REALLOC(b, n) farrealloc((void far *) (b), (unsigned long) (n))
#define CALLOC(n, m) farcalloc((unsigned long) (n), (unsigned long) (m))
extern int show_memory(void);
#else
#define FREE free
#define MALLOC malloc
#define REALLOC realloc
#define CALLOC calloc
#endif

#include "keymap.h"

typedef struct Line
  {
      struct Line *next;               /* pointer to next line */
      struct Line *prev;               /* pointer to prev line */
      unsigned char *data;             /* data for the line */
      int len;                         /* actual length of line */
      int space;                       /* space allocated for line */
  } Line;

/* This is the price we pay for a linked list approach.  With straight
   buffer gap, this would be an integer.  Sigh. */
typedef struct Mark
  {
      Line *line;                      /* line that marker points at */
      int point;                       /* offset from beginning */
      struct Mark *next;
  }
Mark;
      
typedef struct Buffer
  {
     Line *line;		       /* current line */
     Line *beg;			       /* Top line of buffer */
     Line *end;			       /* Bottom line */
     int point;			       /* current offset */
     char file[255];		       /* filename sans dir */
     char dir[255];		       /* directory of file */
     char name[50];		       /* name of this buffer */
     int flags;			       /* flags  (autosave, etc...) */
     Line *beg1;		       /* beg1, end1, beg2, end2 are used by the */
     Line *end1;		       /* narrow to region commands.  Thus the  */
     Line *beg2;		       /* buffer is represented as: */
     Line *end2;		       /* beg1/end1/beg/end/beg2/end2  */
     Mark *marks;
     Mark *spots;
     int modes;			       /* c-mode, wrap, etc... */
     Key_Type *keymap;		       /* keymap attached to this buffer */
     struct Buffer *next;	       /*  */
     struct Buffer *prev;
     char mode_str[13];
     unsigned int hits;			/* number of hits on buffer since 
                                           last autosave.  A hit is the number
					   of times the buffer was hit on at top level  */
     unsigned long m_time;	       /* time when buffer first modified */
     unsigned long c_time;	       /* time when buffer first created or  */
				       /* when file visited */
  } Buffer;

/* flags */
#define BUFFER_TRASHED 0x01
#define AUTO_SAVE_BUFFER 0x02
/* these two flags are to tell user that the buffer and the file on disk
   have been modified--- see update_marks and main editor loop */
#define FILE_MODIFIED 0x04
#define BUFFER_FILE_CONFLICT 0x08

#define NO_MODE 0x00
#define WRAP_MODE 0x01
#define TEXT_MODE 0x01
#define C_MODE 0x02
#define LANG_MODE 0x03		       /* to be a replacement for C_MODE */

extern Buffer *CBuf;
extern Line *CLine;


extern int bob(void);
extern int eob(void);                  /* point to end of buffer */
extern int bol(void);
extern int eol(void);

extern int bobp(void);
extern int eobp(void);
extern int eolp(void);
extern int bolp(void);

extern int prevline(int *);
extern int nextline(int *);

extern int forwchars(int *);
extern int backwchars(int *);
extern void goto_line(int *);

extern Line *make_line1(int);
extern unsigned char *make_line(int);
extern unsigned char *remake_line(int);

extern Buffer *make_buffer(void);
extern void uniquely_name_buffer(char *);
extern void buffer_filename(char *, char *);
extern Buffer *find_file_buffer(char *);
extern Buffer *find_buffer(char *);
extern int delete_line(void);
extern void delete_buffer(Buffer *);
extern int switch_to_buffer(Buffer *);
extern int get_percent(void);
extern int what_line(void);
extern int erase_buffer(void);
extern void mark_buffer_modified(int *);
extern Line *dup_line(Line *);
extern void free_line(Line *);
extern void check_buffers(void);
extern int Point;
extern int Number_Zero;
extern int Number_One;
extern int Number_Two;

/* some systems do not prototype these functions which cause warnings */

/*
extern int fclose(FILE *);
#ifndef VMS
extern FILE *fopen(char *, char *);
#endif
extern int fflush(FILE *);
extern int fprintf(FILE *, char *, ...);
extern int fwrite(char *, int, int,  FILE *);
extern int fread(char *, int, int,  FILE *);
extern int sscanf(char *, char *, ...);
extern int fputs(char *, FILE *);

*/


#endif
