/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include "sysdep.h"

#include <dos.h>
#include <bios.h>
#include <io.h>
#include <conio.h>

/* for stat */
#include <sys/stat.h>
#include <errno.h>

extern void init_video(void);
extern void reset_video(void);

void interrupt (*oldint9)();
char far *shift = (char far *) 0x417;
static volatile int ignore = 0;

void interrupt int9_handler(void)
{
   unsigned char scan = 34;   /* ^G */
   unsigned char s;

   if (*shift & 0x04)
     {
	if ((s = inp(0x60)) == scan)
	  {
	     Lang_Error = -1;
	     KeyBoard_Quit = 1;
	  }
	else if (s == 28) ignore = 1;   /* Control - enter, ignore it!! */
     }
   (*oldint9)();
}

void init_int9_handler(void)
  {
     oldint9 = getvect(9);
     setvect(9, int9_handler);
  }
void restore_int9_handler(void)
  {
     setvect(9, oldint9);
  }

void init_tty()
{

    init_int9_handler();
    init_video();
}

/* to avoid warning do fd-- */
void sys_flush(int fd)
{
    fd--;
}

void reset_tty()
{
   restore_int9_handler();
   reset_video();
}

unsigned char sys_getkey()
{
   unsigned char c;
   
   c = (unsigned char) getch();
   if ((c == 8) && ((bioskey(2) & 0x04) == 0)) c = 127;
   else if ((c == 32) && (bioskey(2) & 0x04)) 
     {
	c = 3;
	ungetkey((int *) &c);
	c = 0;
     }
   
   if (ignore)
     {
	c = (unsigned char) getch();
	ignore = 0;
     }

   return(c);
}

int input_pending(int dummy, int secs)
{
    extern int Video_Status_Port;
    int count = 60, mask;
   
   (void) dummy;
    if (Video_Status_Port == 0x3BA)
      {
	  mask = 1 << 7;
      }
    else mask = 1 << 3;

    if (secs)
      {
	  /* try to sleep for a second unless input is pending.  Here I am
	     following the vertical retrace of the graphics card.  On
	     Hercules, a count of 60 was too fast. */
	  while(count--)
	    {
		if (bioskey(1)) return(0);
		while(!(inp(Video_Status_Port) & mask));
		while(inp(Video_Status_Port) & mask);
	    }
	  return(0);
      }
    else if (INPUT_BUFFER_LEN) return(1); else return(bioskey(1));
}

/* returns 0 on failure, 1 on sucess */
int sys_delete_file(char *filename)
{
    return(1 + unlink(filename));
}

char *expand_filename(char *file)
{
   char *p, *p1, *mark, *last_mark, slash = '\\';
   static char work[255];

   strcpy(work, get_cwd()); strcat(work, file); file = work;

   p = file;
   while (*p++ != 0) if (*p == '/') *p = slash;
   p--;
   mark = p;			       /* mark points at null char */
   while(p != file) if (*p-- == ':')
     {
	/* if (p < file) break; */
	p1 = file;
	if (*(p + 2) != slash)  /* change c:file.dat to c:\file.dat */
	  {
	     while(*mark != ':')
	       {
		  *(mark + 1) = *mark;       /* copies null char as well */
		  mark--;
	       }
	     *(mark + 1) = slash;
	  }
	/* p points at drive, p1 = file so shift left */
	if (p != p1)
	  {
	     while(*p != 0) *p1++ = *p++;
	     *p1 = 0;
	  }
	break;
     }

    /* remove ../ and ./ stuff */

    p = p1 = last_mark = mark = file;

    while(*p != 0)
      {
	  if ((*p == '.') && (*(p + 1) == '.'))
	    {
		p += 2;
		if (*p == slash)
		  {
		      mark = p1 = last_mark;
		  }
		else
		  {
		      *p1++ = '.'; *p1++ = '.'; *p1++ = *p;
		  }

	    }
	  else if ((*p == '.') && (*(p + 1) == slash))  /* do nothing */
	    {
		p++;
	    }
	  else if ((*p == slash) && (*(p + 1) == slash))
	    {
		/* // is a signal that we go back to root */
		last_mark = p1 = file;
		*p1++ = slash;
		mark = p1;
		p++;
	    }
	  else if (*p == slash)
	    {
		last_mark = mark;
		*p1++ = slash;
		mark = p1;
	    }
	  else (*p1++ = *p);

	  if (*p != 0) p++;
      }
   *p1 = 0;
   /* if (mark - file < 0) msg_error("Negative value in expand_filename"); */
   return(file);
}

int sys_rename(char *from, char *to)
{
    return(rename(from,to));
}

/* I have heard that 4DOS uses environment variables for the Screen size. */

void get_term_dimensions(int *w, int *h)
{
   char *sw, *sh;

   if ((NULL != (sh = getenv("_ROWS")))
       && (1 == sscanf(sh, "%d", h)));
   else *h = 25;

   if ((NULL != (sw = getenv("_COLUMNS")))
       && (1 == sscanf(sw, "%d", w)));
   else *w = 80;
}

int sys_chmod(char *file, int what, int *mode)
{
   union REGS in, out;
   struct SREGS sr;
   char buf[80];

   in.h.ah = 0x43;
   in.h.al = what;
   in.x.cx = *mode;
   in.x.dx = FP_OFF(file);
   sr.ds = FP_SEG(file);
   int86x(0x21, &in, &out, &sr);
   if (out.x.cflag)
     {
	if (out.x.ax == 0x2) return(0);     /* file not found */
	if (out.x.ax == 0x3)
	  msg_error("Path does not exist.");
	else {
	   sprintf(buf, "chmod: Unknown Error. %d", out.x.ax);
	   msg_error(buf);
	}

	return(-1);
     }

   if (what == 0)
     {
	*mode = out.x.cx;
     }

   if (out.x.cx & 0x10)
     {
	msg_error("File is a directory.");
	return(-1);
     }

   return(1);
}

typedef struct Dos_DTA_Type
{
   unsigned char undoc[21];
   unsigned char attr;
   unsigned char time[2];
   unsigned char date[2];
   unsigned char low_size[2];
   unsigned char high_size[2];
   char name[13];
} Dos_DTA_Type;

static Dos_DTA_Type *Dos_DTA;

static Dos_DTA_Type *get_dta(void)
{
   union REGS in, out;
   struct SREGS sr;

   in.h.ah = 0x2F;
   int86x(0x21, &in, &out, &sr);
   return MK_FP(sr.es, out.x.bx);
}

static int File_Attr;

#define HIDDEN 0x2
#define SYSTEM 0x4
#define SUBDIR 0x10
#define READON 0x1

static char Dos_Dir[255];
#define lcase(x) if (((x) >= 'A') && ((x) <= 'Z')) (x) |= 0x20

void dta_fixup_name(char *file)
{
   int dir;
   char *p, name[13];

   strcpy(file, Dos_Dir);
   strcpy(name, Dos_DTA->name);
   if ((dir = (Dos_DTA->attr & SUBDIR)) == 0)
     {
	p = name;
	while (*p)
	  {
	     lcase(*p);
	     p++;
	  }
     }

   strcat(file, name);
   if (dir) strcat(file, "\\");
}

int sys_findfirst(char *thefile)
{
   union REGS in, out;
   struct SREGS sr;
   char *f, path[255], *file;

   Dos_DTA = get_dta();
   File_Attr = READON | SUBDIR;

   file = expand_filename(thefile);
   f = extract_file(file);
   strcpy (Dos_Dir, file);
   
   Dos_Dir[(int) (f - file)] = 0;

   strcpy(path, file);
   while (*f && (*f != '.')) f++;
   if (*f) strcat(path, "*"); else strcat(path, "*.*");

   in.h.ah = 0x4e;
   in.x.cx = File_Attr;
   in.x.dx = FP_OFF(path);
   sr.ds = FP_SEG(path);
   int86x(0x21, &in, &out, &sr);
   if (out.x.cflag) return(0);

   dta_fixup_name(file);
   strcpy(thefile, file);
   return(1);
}

int sys_findnext(char *file)
{
   union REGS in, out;
   struct SREGS sr;

   in.h.ah = 0x4F;
   int86x(0x21, &in, &out, &sr);

   if (out.x.cflag) return(0);
   dta_fixup_name(file);
   return(1);
}

void sys_suspend()
{
   if (-1 == spawnlp(P_WAIT, getenv("COMSPEC"), NULL, NULL))
     {
	switch(errno)
	  {
	     case ENOENT: msg_error("File not found."); break;
	     case ENOMEM: msg_error("Insufficient Memeory."); break;
	     default: msg_error("Unknown Error.");
	  }
     }
}

unsigned long sys_file_mod_time(char *file)
{
   struct stat buf;

   if (stat(file, &buf) < 0) return(0);
   return((unsigned long) buf.st_mtime);
}
