/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include <stdio.h>
#include <string.h>
#include "display.h"
#include "sysdep.h"

/* extern int fprintf(FILE *, char *, ...);
   extern int fputs(char *, FILE *); */

char *INS_MODE_STR = "\033[4h";   /* ins mode (im) */
char *EINS_MODE_STR = "\033[4l";  /* end ins mode (ei) */
char *SCROLL_R_STR = "\033[%d;%dr"; /* scroll region */
char *CLS_STR = "\033[2J\033[H";  /* cl termcap STR  for ansi terminals */
char *CLR_BOS_STR = "\033[1J";   /* erase to beg of screen */
char *REV_INDEX_STR = "\033M";     /* sr termcap string */
char *REV_VID_STR = "\033[7m";    /* mr,so termcap string */
char *BOLD_VID_STR = "\033[1m";    /**/
char *UNDL_VID_STR = "\033[4m";    /**/
char *NORM_VID_STR = "\033[m";   /* me,se termcap string */
char *DEL_BOL_STR = "\033[1K\r";  /* cb termcap entry */
char *DEL_EOL_STR = "\033[K";
char *HOME_CURS_STR = "\033[H";   /* ho termcap string */
char *DEL_LINE_STR = "\r\033[K";   /* dl termcap string except cursor at bol */
char *DEL_CHAR_STR = "\033[P";   /* dc */
char *DEL_N_LINES_STR = "\033[%dM";  /* DL */
char *ADD_N_LINES_STR = "\033[%dL";  /* AL */
char *CURS_F_STR = "\033[%dC";    /* RI termcap string */
char *CURS_B_STR = "\033[%dD";    /* RI termcap string */
char *CURS_U_STR = "\033[%dA";    /* RI termcap string */
char *CURS_D_STR = "\033[%dB";    /* RI termcap string */
/* cm string has %i%d since termcap numbers columns from 0 */
/* char *CURS_POS_STR = "\033[%d;%df";  ansi-- hor and vert pos */
char *CURS_POS_STR = "\033[%d;%dH";   /* cm termcap string */

void set_scroll_region(int r1, int r2)
{
    fprintf(stdout,SCROLL_R_STR,r1,r2);
}

void reset_scroll_region()
{
    set_scroll_region(1, Screen_Height);
}

void goto_rc(int r, int c)
{
    fprintf(stdout,CURS_POS_STR,r,c);
}
/* void curs_bol()
{
    fputc('\015',stdout);
}

void cursor_forward(int n)
{
    if (n) fprintf(stdout,CURS_F_STR,n);
}

void cursor_backward(int n)
{
    if (n) fprintf(stdout,CURS_B_STR,n);
}

void cursor_up(int n)
{
    fprintf(stdout,CURS_U_STR,n);
}

void cursor_down(int n)
{
    fprintf(stdout,CURS_D_STR,n);
}
*/
void begin_insert()
{
    fputs(INS_MODE_STR,stdout);
}

void end_insert()
{
    fputs(EINS_MODE_STR,stdout);
}

void tt_delete_char()
{
    fputs(DEL_CHAR_STR,stdout);
}

void tt_erase_line()
{
    fprintf(stdout,DEL_LINE_STR);
}

void tt_delete_nlines(int n)
{
    if (n) fprintf(stdout,DEL_N_LINES_STR,n);
}

void cls()
{
    fputs(CLS_STR,stdout);
}

void reverse_index(int n)
{
    while(n--)
      fputs(REV_INDEX_STR,stdout);
}

int beep()
{
    putc('\007', stdout);
    return(0);
}

void tt_del_eol()
{
    fputs(DEL_EOL_STR, stdout);
}
/*
void tt_open_line(int n)
{
    if (n) fprintf(stdout, ADD_N_LINES_STR, n);
} */

void tt_reverse_video()
{
    fputs(REV_VID_STR, stdout);
}

void tt_normal_video()
{
    fputs(NORM_VID_STR, stdout);
}

void narrow_width()
{
    fputs("\033[?3l",stdout);
}

void wide_width()
{
    fputs("\033[?3h",stdout);
}

void smart_puts(char *new,char *old, int row)
{
    char out[250], ch, ch1, curs[20];
    int ii,max_len,i,mark, curs_set = 0;

    i = 0;
    ii = 0;
    *curs = 0;

    /* while they match, go on */
    while(ch = *new++, ch1 = *old++, (ch == ch1) && (ch != '\0')) i++;

    if (ch == '\0')
    /* we are at the end of the new, so delete eond of old line */
      {
          if (ch1)
            {
                old--;
                while (ch1 = *old++, (ch1 == ' ') && (ch1 != 0));
            }

	  if (ch1 == 0) return;

          goto_rc(row, i + 1);
          tt_del_eol();
          return;
      }

    max_len = strlen(CURS_F_STR);

    if (i)
      {
	 sprintf(curs, CURS_POS_STR, row, i + 1);
	 curs_set = 1;
      }

    while(1)
      {
          i = 1; ii = 0;
          ch1 = 0;
          out[ii++] = ch;
          while (ch = *new++, ch1 = *old++, ch != ch1 && ch != '\0') out[ii++] = ch;
          mark = ii;
          out[ii++] = ch;
          if (ch != '\0') while (ch = *new++, ch1 = *old++, ch == ch1 && ch != '\0')
            {
                i++;
                out[ii++] = ch;
            }
          out[ii] = '\0';
          if (i > max_len)
            {
                out[mark] = '\0';
                if (*curs)
                  {
                      fputs(curs,stdout);
                      *curs = 0;
                  }
                if (!curs_set)
		  {
		     goto_rc(row, 1);
		     curs_set = 1;
		  }

                fputs(out,stdout);
                if (ch == '\0')
                  {
                      if (ch1)
                        {
                            old--;
			    while (ch1 = *old++, (ch1 == ' ') && (ch1 != 0));
                        }

		      if (ch1 == 0) return;
		      if (curs_set) sprintf(curs, CURS_F_STR, i);
		      else
			{
			   sprintf(curs, CURS_POS_STR, row, i + 1);
			   curs_set = 1;
			}

		      fputs(curs, stdout);
		      tt_del_eol();
                      return;
                  }

                if (i)
		  {
		     if (curs_set) sprintf(curs, CURS_F_STR, i);
		     else
		       {
			  sprintf(curs, CURS_POS_STR, row, i + 1);
			  curs_set = 1;
		       }
		  }
            }
          else
            {
                if (*curs)
                  {
                      fputs(curs,stdout);
                      *curs = 0;
                  }
                if (!curs_set)
		  {
		     goto_rc(row, 1);
		     curs_set = 1;
		  }
                fputs(out,stdout);
                if (ch == '\0')
                  {
                      if (ch1)
                        {
                            old--;
                            while (ch1 = *old++, (ch1 == ' '));
                        }

                      if (ch1 != '\0') tt_del_eol();
                      return;
                  }
            }
      }
}

#if 0

void smart_puts(char *new,char *old)
{
    char out[250], ch, ch1, curs[20];
    int ii,max_len,i,mark;

    i = 0;
    ii = 0;
    *curs = 0;

    /* while they match, go on */
    while(ch = *new++, ch1 = *old++, (ch == ch1) && (ch != '\0')) i++;

    if (ch == '\0')
    /* we are at the end of the new, so delete eond of old line */
      {
          if (ch1)
            {
                old--;
                while (ch1 = *old++, (ch1 == ' ') && (ch1 != 0));
            }

	  if (ch1 == 0) return;

          if (i && ch1)  fprintf(stdout, CURS_F_STR, i);
          tt_del_eol();
          return;
      }

    max_len = strlen(CURS_F_STR);
    if (i)
      {
          sprintf(curs, CURS_F_STR, i);
      }

    while(1)
      {
          i = 1; ii = 0;
          ch1 = 0;
          out[ii++] = ch;
          while (ch = *new++, ch1 = *old++, ch != ch1 && ch != '\0') out[ii++] = ch;
          mark = ii;
          out[ii++] = ch;
          if (ch != '\0') while (ch = *new++, ch1 = *old++, ch == ch1 && ch != '\0')
            {
                i++;
                out[ii++] = ch;
            }
          out[ii] = '\0';
          if (i > max_len)
            {
                out[mark] = '\0';
                if (*curs)
                  {
                      fputs(curs,stdout);
                      *curs = 0;
                  }

                fputs(out,stdout);
                if (ch == '\0')
                  {
                      if (ch1)
                        {
                            old--;
			    while (ch1 = *old++, (ch1 == ' ') && (ch1 != 0));
                        }

		      if (ch1 == 0) return;
		      sprintf(curs, CURS_F_STR, i);
		      fputs(curs, stdout);
		      tt_del_eol();
                      return;
                  }

                if (i) sprintf(curs, CURS_F_STR, i);
            }
          else
            {
                if (*curs)
                  {
                      fputs(curs,stdout);
                      *curs = 0;
                  }
                fputs(out,stdout);
                if (ch == '\0')
                  {
                      if (ch1)
                        {
                            old--;
                            while (ch1 = *old++, (ch1 == ' '));
                        }

                      if (ch1 != '\0') tt_del_eol();
                      return;
                  }
            }
      }
}

#endif

