;;   Buffer routines for Jed.  Functions included here are:
;;    
;;     list_buffers  : pop up a list of buffers
;;     save_buffers  : saves buffers that are associated with a file
;;                     with no user intervention
;;
;;
(
  [i tmp this name flags] "*BufferList*" =tmp
  whatbuf =this
  tmp pop2buf
  erase_buffer
  "DAM\tBuffer Name" insert 30 goto_column "Dir/File\n" insert
  buffer_list { =name
    name int 32 == {continue} if   ;; internal buffers begin with a space
    
    name setbuf getbuf_info =flags tmp setbuf
    bol
    4 =i
    { i }{ flags i & {"1"}{"0"} else insert i 2 / =i } while
    "\t" insert
    insert ;; buffer name
    30 goto_column
    eolp {eol " " insert} !if
    insert insert               ;; dir/file
    "\n"  insert
  } loop
  bob
  0 set_buffer_modified_flag
  this pop2buf
) list_buffers

;;
;;  save some buffers--- saves only modified buffers associated with
;;   files.  Does not ask user.
;;

(
   [file dir flags buf]
   
   buffer_list { =buf
      buf int 32 == {continue} if         ;; internal buffer
      buf int "*" int == {continue} if    ;; special buffer
      
      buf setbuf
      getbuf_info  =flags pop =dir =file
      
      file strlen {continue} !if          ;; no file assciated with it
      flags 1 & {
	dir file strcat write_buffer {"Error writing buffer" error} !if
      } if
   } loop   
) save_buffers
      
     
