/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include <stdio.h>
#ifdef msdos
#include <alloc.h>
#endif

#include "buffer.h"
#include "window.h"
#include "screen.h"
#include "misc.h"
#include "sysdep.h"

Window_Type *Window;

Window_Type *create_window(int top, int rows, int col, int width)
{
    Window_Type *w;

    if (NULL == (w = (Window_Type *) MALLOC(sizeof(Window_Type))))
      {
	  exit_error("create_window: malloc error.");
      }

    w->rows = rows;
    w->column = col;
    w->top = top;
    w->width = width;
    w->next = NULL;
    w->buffer = NULL;
    w->mark.line = NULL;
    w->mark.point = 0;
    w->mark.next = NULL;
    w->beg.line = NULL;
    w->beg.point = 0;
    w->beg.next = NULL;
    w->percent = 0;
    return(w);
}

void window_buffer(Buffer *b)
{
   if (Window == NULL)
     {
	Window = create_window(1, Screen_Height - 2, 1, Screen_Width);
	Window->next = Window;
     }

   touch_window();
   Window->mark.line = b->line;
   Window->mark.point = b->point;
   Window->beg.line = b->line;
   Window->beg.point = b->point;
   Window->buffer = b;
   Window->trashed = 1;
}

int other_window()
{
   switch_to_buffer(Window->buffer);
   /* CBuf->line = CLine;
   CBuf->point = Point; */
   Window->mark.point = Point;
   Window->mark.line = CLine;
   /* Window->buffer = CBuf; */

   Window = Window->next;
   Point = Window->mark.point;
   CLine = Window->mark.line;
   CBuf = Window->buffer;
   return(1);
}

int find_screen_line(void)
{
   int i;
   for (i = 0; i < Screen_Height - 2; i++)
     {
	if (Screen[i].line == CLine) return(i + 1);
     }
   return(0);
}


int split_window()
{
    int n, top, width, row;
    Window_Type *w, *new;

    if (Window->rows < 5)
      {
	  msg_error("Window too small.");
	  return(0);
      }

   switch_to_buffer(Window->buffer);
    n = Window->rows / 2;
    top = Window->top + n + 1;
    width = Window->width;
    n = Window->rows - n - 1;
    Window->rows = Window->rows / 2;

    Window->beg.line = find_top();
    w = Window->next;
    Window->next = new = create_window(top, n, Window->column, width);

   new->next = w;
   new->buffer = CBuf;
   new->mark.point = Point;
   new->mark.line = CLine;
       
    other_window();
    touch_window();
    Window->beg.line = find_top();
   /* Try to leave Point on same line of display if possible */
   if ((row = find_screen_line()) > 0)
     {
	w = Window;
	do 
	  {
	     if ((Window->buffer == CBuf) && (Window->top <= row) 
		 && (Window->top + Window->rows > row)) break;
	     other_window();
	  }
	while (w != Window);
     }
   
    return(1);
}

int one_window()
{
    Window_Type *w, *next, *mini;

    mini = NULL;
    if (Window->top == Screen_Height) return(0);  /* mini-buffer */
    w = Window->next;
    while(w != Window)
      {
	  next = w->next;
	  if (w->top != Screen_Height) FREE(w); else mini = w;
	  w = next;
      }
    if (mini == NULL) mini = Window;
    Window->next = mini;
    mini->next = Window;
    Window->top = 1;
    Window->rows = Screen_Height - 2;
    touch_window();
    return(1);
}

int enlarge_window()
{
   Window_Type *w, *w1;
   int min = 2;

   if (IS_MINIBUFFER) return(0);
   if (Window == Window->next) return(0);
   w = Window->next;
   while(w->rows <= min) w = w->next;
   if (w == Window) return(0);

   if (w->top < Window->top)
     {
	w->rows -= 1;
	Window->rows += 1;
	do
	  {
	     w = w->next;
	     w->top -= 1;
	  }
	while (w != Window);
     }
   else
     {
	Window->rows += 1;
	w1 = Window;
	while(w1 != w)
	  {
	     w1 = w1->next;
	     w1->top += 1;
	  }
	w->rows -= 1;
     }
   w = Window;
   do
     {
	touch_window();
	Window = Window->next;
     }
   while (w != Window);
   return(1);
}

void adjust_windows(int height)
{
   Window_Type *w = Window;
   int rows;

   do
     {
	if (w->rows + w->top + 1 == Screen_Height)
	  {
	     rows = height - 1 - w->top;
	     if (rows > 1)
	       {
		  w->rows = rows;
		  return;
	       }
	     while(Window->top != 1) other_window();
	     one_window();
	     Window->rows = height - 2;
	     return;
	  }
	w = w->next;
     }
   while (w != Window);
   /* not reached! */
}

void change_screen_size(int width, int height)
{
   Window_Type *w;

   if (Window == NULL) return;

   if (height != Screen_Height)
     {
	adjust_windows(height);
     }
   reset_display();
   Screen_Width = width;
   Screen_Height = height;
   init_display();
   w = Window;
   do
     {
	Window->width = width;

	/* touch_window(); */
	Window = Window->next;
     }
   while(w != Window);
   /* cls();
   update((Line*) NULL); */
   redraw();
   fflush(stdout);
}


Window_Type *buffer_visible(Buffer *b)
{
   Window_Type *w = Window;
   
   do 
     {
	if (w->buffer == b) return(w);
	w = w->next;
     }
   while (w != Window);
   return(NULL);
}

   
