;;
;;  utility functions which Must be available (e.g., autoload)
;;

;;
;; A function to contat a directory with a filename.  Basically checks
;;  for the final slash on the dir and adds on if necessary
;;   

(
   [dir file] =file =dir
   [n] dir strlen =n 
   [slash] "_IBMPC"  defined? {"\\"}{"/"} else =slash
   
   {"_VMS" defined? 0 ==}{n} andelse {
       dir n 1 substr slash strcmp {dir slash strcat =dir} if
   } if
   dir file strcat
) dircat


;; Since this version of JED uses Linked-List approach and does not
;; support regular expressions, it is hard to search for strings at the 
;; beginning or end of a line.  Here are some functions which do this:

(           ;; bol_fsearch  returns 0 if not found
  [s] =s    ;; sample usage:  push_spot "string" bol_fsearch
            ;;                {pop_spot} !if
  {1 down}
  { bol s looking_at {1 return} if }
  while
  0
) bol_fsearch


(  [str] =str
   
   {str bsearch}{bolp { 1 return } if } while
   0
) bol_bsearch


;;
;;  A routine that trims the buffer by:  removing excess whitespace at the
;;  end of lines and removing excess newlines
;;

(
  push_spot
  bob
  {1} {
	eol trim bol 
	eolp {
	  1 down pop
	  { {eol trim bol eolp } {eobp 0 ==} andelse } { del } while
	} if
	1 down {break} !if
      } while
  bob eol trim bol eolp {del} if
  pop_spot
) trim_buffer
      
(
   getbuf_info
   1 xor setbuf_info
) tog_bufmod
