/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#ifndef __DAVIS_SYSDEP_H__
#define __DAVIS_SYSDEP_H__

#include <stdio.h>
extern volatile int KeyBoard_Quit;
extern volatile int Lang_Error;

extern int INPUT_BUFFER_LEN;
extern unsigned char INPUT_BUFFER[255];

extern unsigned char (*sys_getkey_ptr)(void);
extern unsigned char sys_getkey(void);

extern void init_tty(void);
extern void reset_tty(void);
extern void sys_suspend(void);
extern int getkey(void);
extern int input_pending(int, int);
extern void flush_input(void);
extern void ungetkey(int *);
extern void sys_resume(void);
extern void get_term_dimensions(int *, int *);
extern int sys_delete_file(char *);
extern int sys_chmod(char *, int, int *);
extern unsigned long sys_file_mod_time(char *);

/* expand the file in a canonical way and return a pointer to a 
   static area which should be regarded volatile */
extern char *expand_filename(char *);

/* return pointer to place filname starts in path */
extern char *extract_file(char *);

extern int sys_findfirst(char *);
extern int sys_findnext(char *);

unsigned long sys_file_mod_time(char *file);
extern unsigned long  sys_time(void);
extern char *get_time(void);
extern int Screen_Height;
extern int Screen_Width;
extern int Meta_Char;




#ifdef msdos
#define SCREEN_HEIGHT 25
#else
#define SCREEN_HEIGHT 24
#endif

#endif /* __DAVIS_SYSDEP_H__ */
