/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include "window.h"

/* JED screen management routines */

/* Description: JED maintains a list of Lines which contain a pointer
   to the line in the buffer as well as a flag which describes the line
   as being changed, etc.. since the last update.

   The buffer is changed only through the insertion or deletion of a
   character.  This can have two effects:  1) It changes a single line leaving
   other lines on the display untouched, or 2) It deletes/adds a newline
   character which changes the current line and acuses the other lines to
   scroll.  Hence, the insert/delete routines will have to inform the display
   code of these changes.

   Finally there are situations when the buffer has not changed but the screen
   has.  This occurs when the cursor is in motion such as page up and down. For
   this situation, the screen routines will check to see if it can scroll one
   or two lines to bring the line back into view and if not it will scroll
   enough to recenter.

   Once the display code takes over it does the following:

   1)  Scrolls to try to bring the point into view.
   2)  Then it does a final touch up of the screen.

   Note that if one fails, we just simply redraw the window.  This is more
   efficient then looking at the lines and doing a true screen update like
   emacs does.  Hopefully this will not be a complete loss.  I suspect it
   will win most of the time.

*/

typedef struct Screen_Type
  {
      Line *line;               /* buffer line structure */
      int n;                    /* number of chars written last time */
      int flags;                /* line untouched, etc... */
      char *old, *new;
  }
Screen_Type;



extern Screen_Type Screen[80];
extern int Screen_Row;		       /* cursor row */
extern int Screen_Col;		       /* cursor col */
extern int Cursor_Motion;	       /* cursor movement only */
extern int Display_Eight_Bit;	       /* if non zero, pass to terminal as is */

extern int redraw(void);
extern void scroll_down(int, int, int);
extern int scroll_up(int, int, int);

extern void update(Line *);
extern int update_status_line(Window_Type *, int);
extern void init_display(void);
extern void point_cursor(void);
extern void point_column(int);
extern int calculate_column(void);

extern void register_change(int);
extern void touch_window(void);
extern void blank_line(int);
extern void reset_display(void);
extern int cursor_visible(void);
extern Line *find_top(void);
extern void do_dialog(char *);
extern int Goal_Column;

