#ifndef _JED_MISC_H_
#define _JED_MISC_H_
/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include "window.h"

extern void exit_error(char *);
extern void msg_error(char *);
extern void message(char *);
extern void exit_error(char *);
extern void read_string(char *, int *);
extern void do_error(void);
extern void clear_error(void);
extern int jed_getkey(void);

extern int begin_keyboard_macro(void);
extern int macro_query(void);
extern int end_keyboard_macro(void);
extern int execute_keyboard_macro(void);

extern int Defining_Keyboard_Macro;
extern int Executing_Keyboard_Macro;

extern char Error_Buffer[132];
extern char Message_Buffer[132];

/* information needed by minibuffer and display routines */
typedef struct MiniInfo_Type
  {
     Window_Type *action_window;   /* buffer for minibuffer action */
     char prompt[132];
     int prompt_len;
  }
MiniInfo_Type;

extern MiniInfo_Type Mini_Info;

extern volatile int KeyBoard_Quit;
extern int Exit_From_MiniBuffer;

extern int read_from_minibuffer(char *, char *, char *);
#define IS_MINIBUFFER (Window->top == Screen_Height)
#endif

