/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include <stdio.h>
#include <string.h>
#include <setjmp.h>
#ifdef msdos
#include <dir.h>
#endif

#include "file.h"
#include "buffer.h"
#include "display.h"
#include "sysdep.h"
#include "sig.h"
#include "misc.h"
#include "keymap.h"
#include "screen.h"
#include "ledit.h"
#include "slang.h"
#include "search.h"

extern jmp_buf Jump_Buffer;

char *get_cwd(void)
{
   static char cwd[255];

   if (*cwd ==  0)
     {
	getcwd(cwd, 254);
#ifndef VMS
	fixup_dir(cwd);
#endif
     }
   return(cwd);
}

void load_init_file(void)
{
   FILE *fp;
#ifdef unix
   char *file = ".jedrc";
#else
   char *file = "jed.rc";
#endif
   char initfile[255], *home;

   home = getenv("JED_HOME");
#ifndef VMS
   if ((home != NULL) || (NULL != (home = getenv("HOME"))))
     {
	strcpy(initfile, home);
	fixup_dir(initfile);
     }
   else initfile[0] = 0;
#else
   if (home == NULL) home = "SYS$LOGIN:";
   strcpy(initfile, home);
#endif

   strcat(initfile, file);
   if ((fp = fopen(initfile,"r")) == NULL) return;
   fclose(fp);
   load_file(initfile);
}

int main(int argc, char **argv)
{
   char *file, msgstr[80];
   int n, l;

   init_tty();
   init_display();

   /* incase something goes wrong before we even get started... */
   if (setjmp(Jump_Buffer) != 0)
     {
	/* hmm.... just exit I guess */
	exit_error("Fatal Error!");
     }

   if (NULL == (CBuf = make_buffer()))
     {
	exit_error("Allocation Failure.");
     }
   CLine = NULL;
   strcpy(CBuf->name, "*scratch*");
   *CBuf->file = 0;
   strcpy(CBuf->dir, get_cwd());

   /* This order here is crucial! */
   init_keymaps();
   init_minibuffer();

   set_file_modes();
   if (CLine == NULL) make_line(25);
   Point = 0;
   window_buffer(CBuf);

   cls();

   load_file("site.sl");

   /* load init file unless FIRST parameter "-n" then do not */
   if ((argc > 1) && (!strcmp(argv[1], "-n")))
     {
	argc--; argv++;
     }
   else load_init_file();

   while(--argc > 0)
     {
	argv++;
	if (!strcmp("-l", *argv))   /* load file */
	  {
	     argc--;
	     argv++;
	     if (!argc)
	       {
		  exit_error("Expecting load-file name.");
	       }
	     load_file(*argv);
	  }
	else if (!strcmp("-f", *argv))   /* do function */
	  {
	     argc--;
	     argv++;
	     if (!argc) msg_error("-f what??");
	     else interpret(*argv);
	     Lang_Error = 0;
	  }
	else if (!strcmp("-g", *argv))
	  {
	     argc--; argv++;
	     if (!argc  || (1 != sscanf(*argv, "%d", &l))) msg_error("-g ??");
	     else goto_line(&l);
	  }
	
	else if (!strcmp("-s", *argv))
	  {
	     argc--; argv++;
	     if (!argc) msg_error ("-s ??");
	     else search(*argv, 1, 0);
	  }
	
	else
	  {
	     file = *argv;
#ifdef msdos
	     while (*file++ != 0) if (*(file - 1) == '/') *(file - 1) = '\\';
	     file = *argv;
#endif
	     switch_to_buffer(make_buffer());
	     file = expand_filename(file);
	     buffer_filename(file, NULL);
	     n = read_file(file);
	     if (n != -1)
	       {
		  sprintf(msgstr,"%d lines read", n);
		  message(msgstr);
	       }
	     else message("New File.");
	     CLine = CBuf->beg;
	     if (CLine == NULL) make_line(25);
	     Point = 0;
	     set_file_modes();
	     window_buffer(CBuf);
	  }
     }

#ifndef VMS
#ifndef msdos
   init_signals();
#endif
#endif

   /* after we have possible loaded key definitions, we can fix up
      the minibuffer map. This way user definitions are used. */

   if (NULL == (Mini_Map = create_keymap("Mini_Map"))) exit_error("Fatal.");
   undefine_key("^M", Mini_Map);
   define_key1("^M", (VOID *) exit_minibuffer, F_INTRINSIC, Mini_Map);
   define_key1("^I", (VOID *) mini_complete, F_INTRINSIC, Mini_Map);
   define_key1(" ", (VOID *) mini_complete, F_INTRINSIC, Mini_Map);

   Window->trashed = 1;
   update((Line *) (NULL));

   /* edit_loop */
   jed();  /* never returns */
   return(0);  /* compiler does not know it though */
}
