;; EDT emulation for JED  -- Application Keypad.
;;
;;  To load this, put the line:  "edt.sl" evalfile
;;   in your jed.rc (.jedrc) file
;; 
;; Here the user gets to choose the action of the 'subs' key (Gold-enter)
;; By default, it behaves as EDT.  By putting the next line in JED.RC, this
;; key is bound to a more conventional query replace
;;"replace"	"^[OP^[OM"	setkey  ;; subs (query replace)
;;
;; In addition, if you want the ^H key to move to the beginning of line
;; then uncomment the next two lines.  
;;    "^H" unsetkey
;;    "bol"		"^H"		setkey  ;; beginning of line
;; By default, these are bound 
;; to help functions (man page, etc...).

;; conventional subs key definition:
"edt_subs"	"^[OP^[OM"	setkey  ;; subs (edt style)

;;  
;; Escape sequences for EDT keypad:
;;
;; FP1 = ^[OP       FP2 = ^[OQ      FP3 = ^[OR       PF4 = ^[OS
;;   7 = ^[Ow         8 = ^[Ox        9 = ^[Oy         - = ^[Om
;;   4 = ^[Ot         5 = ^[Ou        6 = ^[Ov         , = ^[Ol
;;   1 = ^[Oq         2 = ^[Or        3 = ^[Os         
;;            0 = ^[Op            . = ^[On         enter = ^[OM    

"Edt_Loaded" defined? 
{ [Edt_Loaded]
  [edt_pbuf] ;; a real buffer
  " <edt>" =edt_pbuf
  whatbuf edt_pbuf setbuf 
  sw2buf
} !if

;; unset some of default jed keys--- lose window capability on "^W" one
;; "^W" unsetkey
;; redraw "^W" setkey

;;"^K" unsetkey ;;-- unset this, we lose kill line in emacs.sl

;; Give user ability to exit via GOLD-Q, GOLD-E
"exit_jed" "^[OPQ" setkey
"exit_jed" "^[OPE" setkey
( exit_jed ) quit
( exit_jed ) exit

;;
;;  Gold-Gold to toggle keypad state
;;
[Edt_Keypad] 1 =Edt_Keypad
(
  Edt_Keypad {
    "Numeric." message 
    27 char ">" strcat tt_send
    0 =Edt_Keypad
  }{
    "Application." message 
    27 char "=" strcat tt_send
    1 =Edt_Keypad
  } else
) edt_togglekp  

"edt_togglekp"	"^[OP^[OP"	setkey  ;; Gold-Gold toggles keypad
"self_insert_cmd" "^I"		setkey  ;; tab inserts tab.
"edt_delbol"	"^U"		setkey  ;; delete to bol
"edt_help"	"^[OQ"		setkey  ;; help
"edt_findnxt"	"^[OR"		setkey  ;; findnxt
"edt_ldel"	"^[OS"		setkey  ;; del l
"edt_cdel"	"^[Ol"		setkey  ;; del c
"edt_wdel"	"^[Om"		setkey  ;; del w
"set_mark_cmd"	"^[On"		setkey  ;; select
"edt_line"	"^[Op"		setkey  ;; line
"edt_word"	"^[Oq"		setkey  ;; word
"edt_eol"	"^[Or"		setkey  ;; eol
"edt_char"	"^[Os"		setkey  ;; char
"edt_advance"	"^[Ot" 		setkey  ;; advance
"edt_backup"	"^[Ou" 		setkey  ;; backup
"edt_cut"	"^[Ov"	        setkey  ;; cut
"edt_page"	"^[Ow"		setkey  ;; page
"edt_sect"	"^[Ox"		setkey  ;; sect
"edt_append"	"^[Oy"		setkey  ;; append
"edt_find"	"^[OP^[OR" 	setkey  ;; find
"edt_uldel"	"^[OP^[OS"	setkey  ;; udel l
"edt_ucdel"	"^[OP^[Ol"	setkey  ;; udel c
"edt_uwdel"	"^[OP^[Om"	setkey  ;; udel w
"edt_reset"	"^[OP^[On"	setkey  ;; reset
"edt_oline"	"^[OP^[Op"	setkey  ;; open line
"edt_chgcase"	"^[OP^[Oq"	setkey  ;; chgcase
"edt_deleol"	"^[OP^[Or"	setkey  ;; deleol
;;
;;  There are two possible definitions for the specins key.  Let's choose
;;  the edt one though I prefer the other
;;
"edt_specins"   "^[OP^[Os"      setkey  ;; specins
;;;;"quoted_insert"	"^[OP^[Os"	setkey  ;; specins
"eob"		"^[OP^[Ot"	setkey  ;; bottom
"bob"		"^[OP^[Ou"	setkey  ;; top
"edt_paste"	"^[OP^[Ov"	setkey  ;; paste
"evaluate_cmd"	"^[OP^[Ow"	setkey  ;; cmd
"format_paragraph" "^[OP^[Ox"	setkey  ;; fill
"edt_replace"	"^[OP^[Oy"	setkey  ;; replace
"exit_mini"	"^[OM"		setkey  ;; enter
;;
;; the enter key requires some care--- it MUST be put in the minibuffer 
;;   keymap.  But this is not created until AFTER the init files are loaded
;;   so that it inherits user definitions.  The above line puts it in the 
;;   global map so that it behaves properly there.  The same applies to 
;;   the 'reset' command
;;
"Mini_Map" keymap_p  
   { "exit_mini" "^[OM" 	"Mini_Map" definekey  ;; enter
     "edt_reset" "^[OP^[On"	"Mini_Map" definekey  ;; reset
   } if
;;
;;  In EDT, a command may be repeated by GOLD number.  Lets have that too
;;
( [a b] =a =b a b ) exch
0 9 1 { string "^[OP" exch strcat "digit_arg" exch setkey } for

;; These are the keys on the vt220 keyboard
"edt_find"      	"^[[1~"		setkey  ;;differs from vt220.sl
"yank"			"^[[2~"		setkey
"kill_region"		"^[[3~"		setkey
"set_mark_cmd"		"^[[4~"		setkey
"pageup"		"^[[5~"		setkey
"pagedown"		"^[[6~"		setkey
"evaluate_cmd"		"^[[29~"	setkey
"edt_help"		"^[[28~"	setkey
;;
;;  Finally some definitions for scrolling the screen left/right
;;
"bob"           "^[OP^[[A"   setkey    ; gold ^
"eob"           "^[OP^[[B"   setkey    ; gold v
"scroll_left"   "^[OP^[[C"   setkey    ; gold ->
"scroll_right"  "^[OP^[[D"   setkey    ; gold <-



;; The major complication is the direction.  Here it is:
[edt_dir] 1 =edt_dir
( 1 =edt_dir "Advance." message) edt_advance
( -1 =edt_dir "Back." message) edt_backup 

;; other buffers:  not buffers but strings except the char buffer which is int
[edt_wbuf] "" =edt_wbuf
[edt_lbuf] "" =edt_lbuf
[edt_cbuf] 0 =edt_cbuf

;; character (un)deletion
( eobp { what_char =edt_cbuf del } !if ) edt_cdel
( edt_cbuf { edt_cbuf char insert 1 left pop } if ) edt_ucdel

;; the change to skip whitespace suggested by C. Page (cgp@leicester.ac.uk)
( edt_dir 1 == 
    {skip_word " \t" skip_chars}{bskip_word} else 
) edt_word

(
   eolp 
    { del "\n" =edt_wbuf }
    { 
      push_mark push_mark
      edt_word            ;; use whatever edt_word does as a region
      bufsubstr =edt_wbuf
      del_region
    }
   else
) edt_wdel

;; another one from Clive Page.
( "char code (decimal): " "27" read_mini eval char insert ) edt_specins

( push_spot edt_wbuf insert pop_spot) edt_uwdel


;; aparantly deleol also saves what it did in buffer...
( push_mark 
  push_mark
  eol   
  bufsubstr =edt_lbuf
  del_region
) edt_deleol

( push_mark 
  push_mark
  bol   
  bufsubstr =edt_lbuf
  del_region
) edt_delbol

;; the line
( 
  push_mark push_mark
  eol 
  bufsubstr eobp {"\n" strcat} !if =edt_lbuf
  1 right pop
  del_region
) edt_ldel

( push_spot edt_lbuf insert pop_spot ) edt_uldel


( edt_dir 1 ==  {"search_forward"}{"search_backward"} else call ) edt_find

( [r]
  LAST_SEARCH int 0 ==
    { "Find What?" error}
    { LAST_SEARCH
      edt_dir 1 == { 1 right =r fsearch }{ 0 =r bsearch } else
      { "Not Found." error 
        r left pop
      } !if
    } else
) edt_findnxt
    

( 16 edt_dir 1 == { down} { up } else pop bol ) edt_sect

( edt_dir 1 == 
   {eolp {1 down pop} if}
   { 1 up pop} 
   else eol
) edt_eol

( edt_dir 1 == 
   { 1 down pop}
   {bolp {1 up pop} if}
   else bol
) edt_line

( 1 edt_dir 1 == {right}{left} else pop ) edt_char
( "\n" insert 1 left pop ) edt_oline
( edt_advance "kbd_quit" call ) edt_reset
( 10 string 1 edt_dir {fsearch}{bsearch} else pop ) edt_page


;; edt cut
( 
  dupmark 
    {
       whatbuf 
       edt_pbuf setbuf
       erase_buffer
       setbuf
       edt_pbuf copy_region
       del_region
     } if
) edt_cut

( edt_pbuf insbuf ) edt_paste

( whatbuf
  edt_pbuf setbuf
  eob 
  setbuf 
  edt_pbuf copy_region
) edt_append

( del_region
  edt_paste ) edt_replace

;; a real edt_subs function
;; deletes search string, substitutes what is in the pastebuffer and finds
;; the next.
(
  LAST_SEARCH looking_at
    {
      LAST_SEARCH strlen {del} loop
      edt_paste
      edt_findnxt
    } {"Select range not active." error}
  else
) edt_subs

;; a help for the help key
(
  [n lib ch]
   "JED_LIBRARY" getenv =lib
   "_VMS" defined?            ;; on unix and MSDOS lib is a dir so determine
     { lib strlen =n          ;; if a final slash is needed
       lib n 1 substr int =ch
       { ch "\\" int == }{ ch "/" int == } orelse
       { lib "/" strcat =lib } !if
     } !if
     
   lib "edt.hlp" strcat find_file
     { onewindow "switch_to_buffer" call } 
     { "Help file not found." } 
   else
) edt_help

;; Chngcase
(
   [n]
   markp  
     { push_mark
       LAST_SEARCH strlen =n
       
       { n { LAST_SEARCH looking_at {n right}{0} else }{0} else }
       { 1 edt_dir 1 == { right } { left } else }
       orelse pop
     } !if
     "X" xform_reg
) edt_chgcase
;; is this a better defn of what edt_replace should be?

(
  [n] LAST_SEARCH strlen =n

   n LAST_SEARCH looking_at and {
     n {del} loop
   }{
     markp { "Select range not active." error} !if
     del_region
   } else

   edt_paste
) edt_replace
