program AE ;

{$M 16384, 90000, 220000}
{ memory requirements: stack size, min heap size, max heap size }

{$B-}  { short-circuit boolean evaluation }
{$I-}  { do not generate run-time errors for I/O operations }
{$S+}  { stack checking on }
{$V-}  { relaxed var string checking }

uses Crt,Dos,Printer,AE0,AE1,AE2,AE3,AE4 ;

const Version = '1.4' ;
      Date    = '21 Mar 1991' ;

{-----------------------------------------------------------------------------}
{                                                                             }
{ AE -- ANOTHER EDITOR                                                        }
{ WRITTEN IN TURBO PASCAL 5.5                                                 }
{                                                                             }
{-----------------------------------------------------------------------------}
{ KEY DEFINITIONS                                                             }
{                                                                             }
{           NORMAL                      SHIFT                                 }
{           --------------------------  ------------------------------        }
{ F1        HELP                        SETUP                                 }
{ F2        SAVE FILE                   WRITE TO FILE                         }
{ F3        LOAD FILE                   INSERT FILE                           }
{ F4        FIND                        FIND & REPLACE                        }
{ F5        PUT MARK                    ERASE MARK                            }
{ F6        CUT BLOCK TO PASTE BUFFER   DELETE BLOCK                          }
{ F7        COPY BLOCK TO PASTE BUFFER  COMPARE BLOCK TO PASTE BUFFER         }
{ F8        PASTE BLOCK                 PRINT BLOCK                           }
{ F9        NEXT WINDOW                 PREVIOUS WINDOW                       }
{ F10       DOS COMMAND                                                       }
{                                                                             }
{ alt 0-9   PLAY MACRO                                                        }
{     A     SWITCH TO WINDOW A                                                }
{     B                                                                       }
{     C     CENTER LINE                                                       }
{     D     DEFINE KEYBOARD MACRO                                             }
{     E     EJECT PRINTER PAGE                                                }
{     F     FORMAT PARAGRAPH                                                  }
{     G     GET SAVED POSITION                                                }
{     H                                                                       }
{     I     IBM CHARACTER SET (ASCII TABLE)                                   }
{     J     JUSTIFY LINE TO RIGHT                                             }
{     K                                                                       }
{     L     DELETE LINE                                                       }
{     M     MATCH BRACKETS                                                    }
{     N     NEW (CLEAR FILE BUFFER)                                           }
{     O                                                                       }
{     P     PRINT ENTIRE FILE BUFFER                                          }
{     R     REPEAT LAST FIND/REPLACE                                          }
{     S     SAVE POSITION                                                     }
{     T     TOGGLE CASE IN BLOCK                                              }
{     V                                                                       }
{     W     DELETE WORD FORWARD                                               }
{     X     EXIT PROGRAM                                                      }
{     Y                                                                       }
{     Z     DISPLAY VERSION NUMBER AND DATE                                   }
{                                                                             }
{ FIND/REPLACE OPTIONS: I = IGNORE CASE                                       }
{                       N = NO QUERY                                          }
{                       R = REVERSE SEARCH                                    }
{                                                                             }
{ SETUP : E = ENVIRONMENT                                                     }
{                K = KEYCLICK (ON/OFF)                                        }
{                B = BELL (ON/OFF)                                            }
{                W = WORD WRAP LENGTH (0 = OFF)                               }
{                T = TAB SPACING                                              }
{                A = AUTO-INDENT (ON/OFF)                                     }
{                I = INSERT/OVERWRITE                                         }
{         F = FILE                                                            }
{                E = SAVE FILES ON EXIT (ON/OFF)                              }
{                I = INTERVAL FOR AUTO-SAVE (0 = OFF)                         }
{                B = MAKE .BAK FILE (ON/OFF)                                  }
{         P = PRINTER                                                         }
{                P = PAGE LENGTH (0 = OFF)                                    }
{                L = LEFT MARGIN                                              }
{                T = TOP MARGIN                                               }
{                N = PRINT PAGE NUMBERS (ON/OFF)                              }
{         D = DISPLAY                                                         }
{                T = CHANGE CURSOR TYPE                                       }
{                C = CHANGE SCREEN COLORS                                     }
{                D = DISPLAY SPACES AS DOTS (ON/OFF)                          }
{         S = SAVE SETTINGS                                                   }
{                                                                             }
{-----------------------------------------------------------------------------}


{-----------------------------------------------------------------------------}
{ Initializes all necessary variables, and loads the file specified on the    }
{ command line into the first workspace.                                      }
{-----------------------------------------------------------------------------}

procedure Initialize ;

var Reg : registers ;
    Counter : word ;
    ConfigFile : file of ConfigBlock ;
    ConfigFilePath : PathStr ;
    AEDir : DirStr ;
    AEName : NameStr ;
    AEExt : ExtStr ;

begin
{ check the presence of a color video adapter }
Reg.AH := 15 ;
Intr ($10,Reg) ;
ColorCard := Reg.AL <> Mono ;
{ set start address of screen memory }
if ColorCard
   then DisplayPtr := Ptr($B800,0)
   else DisplayPtr := Ptr($B000,0);
{ store screen settings }
OrigCursorType := GetCursor ;
OrigTextAttr := TextAttr ;
{ try to find setup file }
ConfigFilePath := '' ;
if Exists(ConfigFileName)
   then ConfigFilePath := FExpand (ConfigFileName)
   else begin
        if Lo(DosVersion) >= 3
           then begin
                { look for setup file in directory where AE.EXE is }
                FSplit (ParamStr(0),AEDir,AEName,AEExt) ;
                if Exists (AEDir+ConfigFileName)
                   then ConfigFilePath := AEDir + ConfigFileName ;
                end
        end ;
if Length(ConfigFilePath) > 0
   then begin
        { load setup }
        Assign (ConfigFile,ConfigFilePath) ;
        Reset (ConfigFile) ;
        Read (ConfigFile,Config) ;
        Close (ConfigFile)
        end
   else begin
        { no setup file: use default }
        Config.Setup := DefaultSetup ;
        for Counter := 1 to NrOfMacros do
            Config.Macro.Length[Counter] := Inactive ;
        end ;
{ set screen colors and cursor }
if (not ColorCard) and (Config.Setup.ScreenColors > 2)
   then { on monochrome card only color settings 1 and 2 are valid }
        Config.Setup.ScreenColors := 1 ;
TextAttr := ScreenColorArray[Config.Setup.ScreenColors].NormAttr ;
ClrScr ;
OldCursorPosAttr := TextAttr ;
SetCursor (Config.Setup.Cursortype) ;
{ initialize paste buffer, macro stack and several global variables }
New (PasteBuffer) ;
PasteBuffersize := 0 ;
MacroStackpointer := Inactive ;
MacroDefining := Inactive ;
FindString := '' ;
ReplaceString := '' ;
SearchOptions := '' ;
SearchType := Find ;
{ clear keyboard buffer }
ClearKeyBuffer ;
{ initialize workspaces }
Counter := 1 ;
repeat
    New(Workspace[Counter].Buffer) ;
    ClearWorkspace (Counter) ;
    Inc(Counter) ;
until (Counter > MaxNrOfWorkspaces) or (MaxAvail < WsBufSize) ;
NrOfWorkspaces := Counter - 1 ;
CurrentWsnr := 1 ;
if Length(ParamStr(1)) = 0
   then Message ('Another Editor Version '+Version+'. Press F1 for help')
   else begin
        LoadfileName := FExpand(ParamStr(1)) ;
        if Wildcarded(Loadfilename)
           then begin
                LoadfileName := GetFileFromList(LoadfileName) ;
                if not EscPressed
                   then LoadFile (LoadfileName) ;
                end
           else LoadFile (LoadfileName) ;
        end ;
{$IFDEF DEVELOP }
MinMemAvail := MemAvail ;
{$ENDIF }
end ;

{-----------------------------------------------------------------------------}
{ Restores screen settings before exiting program.                            }
{-----------------------------------------------------------------------------}

procedure ShutOff ;

begin
SetCursor (OrigCursorType) ;
TextAttr := OrigTextAttr ;
ClrScr ;
end ;

{-----------------------------------------------------------------------------}
{ Executes the action corresponding to the key number given.                  }
{-----------------------------------------------------------------------------}

procedure ExecKey (var KeyNr:word) ;

var Counter              : word ;
    OldCurPos            : Position ;
    MacroNumber          : word ;
    NextPos              : Position ;
    BlockStart,BlockStop : word ;
    TabSteps             : word ;
    LineLength,NewSpaces : word ;

begin
with Workspace[CurrentWsnr] do
  begin
  case KeyNr of
    331 : { left }
          begin
          if (Buffer^[CurPos.Index-2] = CR) and (Buffer^[CurPos.Index-1] = LF)
             then SkipUp (CurPos,2)
             else SkipUp (CurPos,1) ;
          end ;
    333 : { right }
          begin
          if (Buffer^[CurPos.Index] = CR) and (Buffer^[CurPos.Index+1] = LF)
             then SkipDown (CurPos,2)
             else SkipDown (CurPos,1) ;
          end ;
    328 : { up }
          begin
          LineUp (CurPos) ;
          end ;
    336 : { down }
          begin
          LineDown (CurPos) ;
          end ;
    327 : { Home }
          begin
          Home (CurPos) ;
          end ;
    335 : { End }
          begin
          EndOfLine (CurPos) ;
          end ;
    329 : { PgUp }
          begin
          for Counter := 1 to (NrOfTextLines-1) do
              LineUp (CurPos) ;
          end ;
    337 : { PgDn }
          begin
          for Counter := 1 to (NrOfTextLines-1) do
              LineDown (CurPos) ;
          end ;
    388 : { ^PgUp }
          begin
          CurPos.Index := 1 ;
          CurPos.Linenr := 1 ;
          CurPos.Colnr := 1 ;
          end ;
    374 : { ^PgDn }
          begin
          for Counter := CurPos.Index to BufferSize do
              if Buffer^[Counter] = CR then Inc(CurPos.Linenr) ;
          CurPos.Index := BufferSize ;
          CalculateColnr (CurPos) ;
          end ;
    375 : { ^Home }
          begin
          while CurPos.Linenr > FirstVisiblePos.Linenr
                do LineUp (CurPos) ;
          Home (CurPos) ;
          end ;
    373 : { ^End }
          begin
          while (CurPos.Linenr < (FirstVisiblePos.Linenr+NrOfTextLines-1)) and
                (CurPos.Index < BufferSize)
                do LineDown (CurPos) ;
          Home (CurPos) ;
          end ;
    371 : { ^left }
          begin
          WordUp (CurPos) ;
          end ;
    372 : { ^right }
          begin
          WordDown (CurPos) ;
          end ;
    340 : { shift-F1 }
          begin
          AlterSetup ;
          end ;
    316 : { F2 }
          begin
          SaveFile (CurrentWsnr) ;
          end ;
    341 : { shift-F2 }
          begin
          EnterString (Name,'New file name: ',79,True,True) ;
          if not EscPressed
             then begin
                  Name := FExpand (Name) ;
                  SaveFile (CurrentWsnr) ;
                  end ;
          end ;
    317 : { F3 }
          begin
          if Length (Name) > 0
             then LoadfileName := Name
             else LoadfileName := '*.*' ;
          EnterString (LoadfileName,'Load file: ',79,True,True) ;
          if Wildcarded(LoadfileName) and (not EscPressed)
             then LoadfileName := GetFileFromList (LoadfileName) ;
          if not EscPressed
             then
               begin
               if ChangesMade
                  then
                    begin
                    if Answer ('File has been changed. Save?')
                       then SaveFile (CurrentWsnr) ;
                    end ;
               if not EscPressed
                  then LoadFile (LoadfileName) ;
               end ;
          end ;
    342 : { shift-F3 }
          begin
          LoadfileName := '*.*' ;
          EnterString (LoadfileName,'Insert file: ',79,True,True) ;
          if Wildcarded(LoadfileName) and (not EscPressed)
             then LoadfileName := GetFileFromList (LoadfileName) ;
          if not EscPressed
             then InsertFile (LoadfileName,CurPos) ;
          end ;
    305 : { alt-N }
          begin
          EscPressed := False ;
          if ChangesMade
             then
               begin
               if Answer ('File has been changed. Save?')
                  then SaveFile (CurrentWsnr) ;
               end ;
          if not EscPressed
             then
               begin
               ClearWorkspace (CurrentWsnr) ;
               end ;
          end ;
    318,343,
    275 : { F4,shift-F4,alt-R }
          begin
          if KeyNr <> 275
             then
               begin
               { if block selected: copy block contents to FindString }
               if Mark <> Inactive
                  then begin
                       if Mark < CurPos.Index
                          then begin
                               BlockStart := Mark ;
                               BlockStop := CurPos.Index ;
                               end
                          else begin
                               BlockStart := CurPos.Index ;
                               BlockStop := Mark ;
                               end ;
                       if (BlockStop - BlockStart) <= 255
                          then begin
                               Move (Buffer^[BlockStart],FindString[1],
                                     BlockStop-BlockStart) ;
                               FindString[0] := Chr(BlockStop-BlockStart) ;
                               end ;
                       end ;
               { enter new search parameters }
               EnterString (FindString,'Find: ',255,False,False) ;
               if (KeyNr = 343) and (not EscPressed)
                  then EnterString (ReplaceString,'Replace with: ',
                                    255,False,False) ;
               if not EscPressed
                  then
                    begin
                    if KeyNr = 318
                       then begin
                            EnterString (SearchOptions,'Options (I,R): ',
                                         4,True,True) ;
                            SearchType := Find ;
                            end
                       else begin
                            EnterString (SearchOptions,'Options (I,N,R): ',
                                         4,True,True) ;
                            SearchType := FindAndReplace ;
                            end ;
                    IgnoreCase := Pos ('I',SearchOptions) <> 0 ;
                    ReverseSearch := Pos ('R',SearchOptions) <> 0 ;
                    NoQuery := Pos ('N',SearchOptions) <> 0 ;
                    end ;
               end ;
          if (not EscPressed) or (KeyNr = 275)
             then
               begin
               { start search }
               OldCurPos := CurPos ;
               SearchString (FindString,CurPos) ;
               if not Found
                  then
                    begin
                    CurPos := OldCurPos ;
                    ErrorMessage (15) ;
                    end ;
               if Found and (SearchType = FindAndReplace)
                  then
                    begin
                    { Counter will contain number of replacements made }
                    Counter := 0 ;
                    repeat
                      { show found string if queried replace }
                      Mark := CurPos.Index + Length(FindString) ;
                      if not NoQuery
                         then RedrawScreen ;
                      { determine if string must be replaced }
                      if NoQuery or
                         (Choose ('Y = replace   N = do not replace') = 'Y')
                         then
                           begin
                           { OldCurPos will point to last replaced string }
                           OldCurPos := CurPos ;
                           { replace FindString with ReplaceString }
                           if Length (FindString) >= Length (ReplaceString)
                              then
                                begin
                                { adapt buffer size }
                                Shrink (CurPos.Index,Length(FindString)-
                                                     Length(ReplaceString)) ;
                                { write ReplaceString }
                                Move (ReplaceString[1],Buffer^[CurPos.Index],
                                      Length(ReplaceString)) ;
                                if not ReverseSearch
                                   then
                                     begin
                                     { resume search after ReplaceString }
                                     SkipDown (CurPos,
                                               Length(ReplaceString)) ;
                                     end ;
                                Inc (Counter) ;
                                end
                              else
                                begin
                                if Grow (CurPos.Index,
                                         Length(ReplaceString) -
                                         Length(FindString))
                                   then
                                     begin
                                     { write ReplaceString }
                                     Move (ReplaceString[1],
                                           Buffer^[CurPos.Index],
                                           Length (ReplaceString)) ;
                                     if not ReverseSearch
                                        then
                                          begin
                                          { resume search after ReplaceString }
                                          SkipDown (CurPos,
                                                    Length(ReplaceString)) ;
                                          end ;
                                     Inc (Counter) ;
                                     end
                                   else
                                     { no room for replace: stop search }
                                     EscPressed := True ;
                                end ;
                           { show replacement counter }
                           Message (WordToString(Counter,0) +
                                    ' replacement(s) made') ;
                           end ;
                      if not EscPressed
                         then SearchString (FindString,CurPos) ;
                    until (not Found) or EscPressed ;
                    { return to last replaced string }
                    CurPos := OldCurPos ;
                    end ;
               { erase block mark }
               Mark := Inactive ;
               end ;
          end ;
    319 : { F5 }
          begin
          Mark := CurPos.Index ;
          end ;
    344 : { shift-F5 }
          begin
          Mark := Inactive ;
          end ;
    320 : { F6 }
          begin
          if CopyBlock
             then begin
                  DeleteBlock ;
                  end ;
          end ;
    345 : { shift-F6 }
          begin
          DeleteBlock ;
          end ;
    321 : { F7 }
          begin
          if CopyBlock
             then begin
                  Mark := Inactive ;
                  Message ('Block copied into paste buffer') ;
                  end ;
          end ;
    346 : { shift-F7 }
          begin
          if Mark = Inactive
             then ErrorMessage (5)
             else begin
                  if Mark < CurPos.Index
                     then begin
                          BlockStart := Mark ;
                          BlockStop := CurPos.Index ;
                          end
                     else begin
                          BlockStart := CurPos.Index ;
                          BlockStop := Mark ;
                          end ;
                  Counter := BlockStart ;
                  while (Buffer^[Counter] =
                         PasteBuffer^[Counter-BlockStart+1]) and
                        (Counter < BlockStop) do
                        Inc (Counter) ;
                  if (Counter >= BlockStop) and
                     ((BlockStop-BlockStart) = PasteBufferSize)
                     then Message ('Block is equal to paste buffer')
                     else Message ('Block is not equal to paste buffer') ;
                  end ;
          end ;
    322 : { F8 }
          begin
          InsertBlock ;
          end ;
    347 : { shift-F8 }
          begin
          if Mark = Inactive
             then ErrorMessage (5)
             else begin
                  if Mark < CurPos.Index
                     then PrintBlock (Buffer,Mark,CurPos.Index-1)
                     else PrintBlock (Buffer,CurPos.Index,Mark-1) ;
                  end ;
          end ;
    281 : { alt-P }
          begin
          if Answer ('Print entire file buffer?')
             then PrintBlock (Buffer,1,BufferSize-1) ;
          end ;
    323 : { F9 }
          if CurrentWsnr = NrOfWorkspaces
             then CurrentWsnr := 1
             else Inc (CurrentWsnr) ;
    348 : { shift-F9 }
          if CurrentWsnr = 1
             then CurrentWsnr := NrOfWorkspaces
             else Dec (CurrentWsnr) ;
    324 : { F10 }
          begin
          { restore screen settings }
          TextAttr := OrigTextAttr ;
          SetCursor (OrigCursorType) ;
          ClrScr ;
          Writeln ('Type EXIT to return to AE ...') ;
          SwapVectors ;
          Exec (GetEnv('COMSPEC'),'') ;
          SwapVectors ;
          if DosError <> 0
             then ErrorMessage (14) ;
          { reset screen settings }
          TextAttr := ScreenColorArray[Config.Setup.ScreenColors].NormAttr ;
          SetCursor (Config.Setup.CursorType) ;
          end ;
    274 : { alt-E }
          begin
          Write (Lst,FF) ;
          CheckDiskError ;
          end ;
    286 : { alt-A }
          CurrentWsnr := 1 ;
    376..
    385 : { alt-1 .. alt-0 }
          begin
          MacroNumber := KeyNr - 375 ;
          if MacroDefining = MacroNumber
             then begin
                  Dec (Config.Macro.Length[MacroDefining]) ;
                  ErrorMessage (9) ;
                  end
             else begin
                  if Config.Macro.Length[MacroNumber] > 0
                     then begin
                          if MacroStackpointer = MacroStackDepth
                             then begin
                                  MacroStackpointer := Inactive ;
                                  ErrorMessage (10) ;
                                  end
                             else begin
                                  { push macro onto MacroStack }
                                  Inc (MacroStackpointer) ;
                                  with MacroStack[MacroStackpointer] do
                                       begin
                                       Macronr := MacroNumber ;
                                       Index := 1 ;
                                       end ;
                                  end ;
                          end ;
                  end ;
          end ;
    288 : { alt-D }
          begin
          if MacroDefining = Inactive
             then begin
                  { Start define mode }
                  MacroNumber := 1 ;
                  EnterWord (MacroNumber,
                             'Define keyboard Macro nr. (1-10): ',1,10) ;
                  if not EscPressed
                     then begin
                          { reset old macro }
                          Config.Macro.Length[MacroNumber] := 0 ;
                          MacroDefining := MacroNumber ;
                          end ;
                  end
             else { end define mode }
                  MacroDefining := Inactive ;
          end ;
    289 : { alt-F }
          begin
          if Config.Setup.WordWrapLength = Inactive
             then ErrorMessage (11)
             else begin
                  if Buffer^[CurPos.Index] in WordSeparators
                     then WordDown (CurPos) ;
                  NextPos := CurPos ;
                  WordDown (NextPos) ;
                  { NextPos points to start of next word after CurPos }
                  while ((NextPos.Linenr - CurPos.Linenr) < 2) and
                        (CurPos.Index < BufferSize) do
                    begin
                    if NextPos.Linenr > CurPos.Linenr
                       then { replace old CR+LF with spaces }
                            with Nextpos do
                                 begin
                                 Buffer^[Index-Colnr] := ' ' ;
                                 if Buffer^[Index-Colnr-1] = CR
                                    then Buffer^[Index-Colnr-1] := ' ' ;
                                 { NextPos now is on same line as Curpos }
                                 Dec (Linenr) ;
                                 Colnr := CurPos.Colnr +
                                          (Index - CurPos.Index) ;
                            end ;
                    { replace multiple spaces with single space }
                    Counter := 2 ;
                    while Buffer^[NextPos.Index-Counter] = ' ' do
                          Inc (Counter) ;
                    if Counter > 2
                       then with NextPos do
                                 begin
                                 { calculate number of redundant spaces }
                                 Dec (Counter,2) ;
                                 { remove redundant spaces }
                                 Shrink (Index-Counter-1,Counter) ;
                                 { adapt NextPos }
                                 Dec (Index,Counter) ;
                                 Dec (Colnr,Counter) ;
                                 end ; { of if }
                    if NextPos.Colnr > Config.Setup.WordWrapLength
                       then begin
                            { break line at position CurPos }
                            InsertCRLF (CurPos) ;
                            { NextPos is now invalid }
                            WordDown (CurPos) ;
                            NextPos := CurPos ;
                            end
                       else CurPos := NextPos ;
                    { on to next word }
                    WordDown (NextPos) ;
                    end ; { of while }
                  if CurPos.Index < BufferSize
                     then begin
                          { check if last line of paragraph must be broken }
                          NextPos := CurPos ;
                          EndOfLine (NextPos) ;
                          { remove spaces at end of line }
                          Counter := 0 ;
                          while Buffer^[NextPos.Index-1] = ' ' do
                                begin
                                Dec (NextPos.Index) ;
                                Dec (NextPos.Colnr) ;
                                Inc (Counter) ;
                                end ;
                          Shrink (NextPos.Index,Counter) ;
                          if NextPos.Colnr > Config.Setup.WordWrapLength
                             then InsertCRLF (CurPos) ;
                          end ; { of if }
                  { move to first word in new paragraph }
                  WordDown (CurPos) ;
                  end ;
          end ;
292,302 : { alt-J, alt-C }
          begin
          if Config.Setup.WordWrapLength = Inactive
             then ErrorMessage (11)
             else begin
                  { measure line length }
                  EndOfLine (CurPos) ;
                  { remove trailing spaces }
                  Counter := 1 ;
                  while (Buffer^[CurPos.Index-Counter] = ' ') and
                        (Counter < CurPos.Colnr) do
                        Inc (Counter) ;
                  Dec (CurPos.Index,Counter-1) ;
                  Dec (CurPos.Colnr,Counter-1) ;
                  Shrink (CurPos.Index,Counter-1) ;
                  LineLength := CurPos.Colnr - 1 ;
                  { remove leading spaces }
                  Home (CurPos) ;
                  Counter := 0 ;
                  while (Buffer^[CurPos.Index+Counter] = ' ') and
                        (Counter <= LineLength) do
                        Inc (Counter) ;
                  Shrink (CurPos.Index,Counter) ;
                  Dec (LineLength,Counter) ;
                  NewSpaces := (Config.Setup.WordWrapLength-LineLength) ;
                  if KeyNr = 302
                     then NewSpaces := NewSpaces div 2 ;
                  if NewSpaces > 0
                     then InsertSpaces (CurPos,NewSpaces) ;
                  end
          end ;
    306 : { alt-M }
          begin
          OldCurPos := CurPos ;
          Found := True ;
          case Buffer^[CurPos.Index] of
               '{' : MatchBracketsDown ('{','}',CurPos) ;
               '}' : MatchBracketsUp ('{','}',CurPos) ;
               '(' : MatchBracketsDown ('(',')',CurPos) ;
               ')' : MatchBracketsUp ('(',')',CurPos) ;
               '[' : MatchBracketsDown ('[',']',CurPos) ;
               ']' : MatchBracketsUp ('[',']',CurPos) ;
               '<' : MatchBracketsDown ('<','>',CurPos) ;
               '>' : MatchBracketsUp ('<','>',CurPos) ;
               else Message ('Cursor must be on bracket ({[<>]})') ;
               end ; { of case }
          if not Found
             then begin
                  Message ('No matching bracket found') ;
                  CurPos := OldCurPos ;
                  end ;
          end ;
    287 : { alt-S }
          begin
          if PosStackpointer = PosStackDepth
             then ErrorMessage (12)
             else begin
                  Inc (PosStackpointer) ;
                  PosStack[PosStackpointer] := CurPos.Index ;
                  end ;
           end ;
    290 : { alt-G }
          begin
          if PosStackpointer = Inactive
             then ErrorMessage (13)
             else begin
                  if CurPos.Index < PosStack[PosStackpointer]
                     then SkipDown (CurPos,
                                    PosStack[PosStackpointer] - CurPos.Index)
                     else SkipUp (CurPos,
                                  CurPos.Index - PosStack[PosStackpointer]) ;
                  Dec (PosStackpointer) ;
                  end ;
          end ;
    276 : { alt-T }
          begin
          if Mark = Inactive
             then ErrorMessage (5)
             else begin
                  if Mark < CurPos.Index
                     then begin
                          BlockStart := Mark ;
                          BlockStop := CurPos.Index ;
                          end
                     else begin
                          BlockStart := CurPos.Index  ;
                          BlockStop := Mark ;
                          end ;
                  for Counter := BlockStart to (BlockStop-1) do
                      if Buffer^[Counter] in ['A'..'Z','a'..'z']
                         then begin
                              Buffer^[Counter] :=
                                     Chr(Ord(Buffer^[Counter]) xor $20) ;
                              ChangesMade := True ;
                              end ;
                  end ;
          end ;
 0..255 : { character-keys }
          begin
          if KeyNr = 26
             then Message ('Warning: Inserting end-of-file character') ;
          if (not Config.Setup.Insertmode) and
             (Buffer^[CurPos.Index] <> CR) and
             (CurPos.Index < Buffersize)
             then begin
                  { overwrite character if not in insertmode and not }
                  { at end of line or buffer }
                  Buffer^[CurPos.Index] := Chr(KeyNr) ;
                  Inc (CurPos.Index) ;
                  if KeyNr = 13
                     then begin
                          Inc (Curpos.Linenr) ;
                          CurPos.Colnr := 1 ;
                          end
                     else Inc (CurPos.Colnr) ;
                  ChangesMade := True ;
                  end
             else begin
                  if Grow (CurPos.Index,1)
                     then begin
                          Buffer^[CurPos.Index] := Chr(KeyNr) ;
                          Inc (CurPos.Index) ;
                          if KeyNr = 13
                             then begin
                                  Inc (Curpos.Linenr) ;
                                  CurPos.Colnr := 1 ;
                                  end
                             else Inc (CurPos.Colnr) ;
                          if (Config.Setup.WordWrapLength <> Inactive) and
                             (CurPos.Colnr > Config.Setup.WordWrapLength)
                             then
                               begin
                               OldCurPos := CurPos ;
                               WordUp (CurPos) ;
                               if Buffer^[CurPos.Index-1] = ' '
                                  then
                                    begin
                                    Shrink (CurPos.Index-1,1) ;
                                    Dec (CurPos.Index) ;
                                    Dec (CurPos.Colnr) ;
                                    Dec (OldCurpos.Index) ;
                                    end ;
                               NextPos := CurPos ;
                               InsertCRLF (CurPos) ;
                               SkipDown (CurPos,
                                         OldCurPos.Index-CurPos.Index+
                                         (CurPos.Index-NextPos.Index)) ;
                               Home (FirstVisiblePos) ;
                               end ;
                          end ;
                  end ;
          end ;
266,269 : { Enter,^Enter }
          begin
          InsertCRLF (CurPos) ;
          end ;
    265 : { Tab }
          begin
          if Config.Setup.TabSpacing = 0
             then begin
                  { find nearest beginning of word in previous line }
                  OldCurPos := CurPos ;
                  LineUp (Curpos) ;
                  while (CurPos.Colnr <= OldCurPos.Colnr) and
                        (CurPos.Linenr < OldCurpos.Linenr) do
                        WordDown (CurPos) ;
                  if CurPos.Linenr < OldCurpos.Linenr
                     then TabSteps := Curpos.Colnr - OldCurpos.Colnr
                     else TabSteps := 0 ;
                  CurPos := OldCurPos ;
                  end
             else begin
                  TabSteps := Config.Setup.TabSpacing -
                              ((CurPos.Colnr-1) mod Config.Setup.TabSpacing) ;
                  end ;
          if (not Config.Setup.Insertmode)
             then begin
                  { if in overwrite mode: skip tabsteps until eoln or eof }
                  while (TabSteps > 0) and (Buffer^[CurPos.Index] <> CR) and
                        (CurPos.Index < Buffersize) do
                        begin
                        Inc (CurPos.Index) ;
                        Inc (CurPos.Colnr) ;
                        Dec (TabSteps) ;
                        end ;
                  end ; { of if }
          if TabSteps > 0
             then InsertSpaces (CurPos,TabSteps) ;
          end ;
    271 : { shift-Tab }
          begin
          if Config.Setup.TabSpacing = 0
             then begin
                  OldCurPos := CurPos ;
                  LineUp (CurPos) ;
                  EndOfLine (CurPos) ;
                  if CurPos.ColNr > OldCurPos.Colnr
                     then begin
                          Dec (CurPos.Index,CurPos.Colnr-OldCurPos.Colnr) ;
                          CurPos.Colnr := OldCurpos.Colnr ;
                          end ;
                  WordUp (CurPos) ;
                  if CurPos.Linenr = (OldCurpos.Linenr-1)
                     then TabSteps := OldCurpos.Colnr - Curpos.Colnr
                     else TabSteps := OldCurPos.Colnr - 1 ;
                  CurPos := OldCurPos ;
                  end
             else if CurPos.Colnr > Config.Setup.TabSpacing
                     then begin
                          TabSteps := (CurPos.Colnr-1) mod
                                      Config.Setup.TabSpacing ;
                          if TabSteps = 0
                             then TabSteps := Config.Setup.TabSpacing ;
                          end
                     else TabSteps := CurPos.Colnr - 1 ;
          Dec (CurPos.Index,TabSteps) ;
          Dec (CurPos.Colnr,TabSteps) ;
          end ;
    338 : { Ins }
          begin
          Config.Setup.Insertmode := not Config.Setup.Insertmode ;
          end ;
    339 : { Del }
          begin
          if CurPos.Index < Buffersize
             then begin
                  if (Buffer^[CurPos.Index] = CR) and
                     (Buffer^[CurPos.Index+1] = LF)
                     then Shrink (CurPos.Index,2)
                     else Shrink (CurPos.Index,1) ;
                  end ;
          end ;
    264 : { Backspace }
          begin
          if CurPos.Index > 1
             then begin
                  if (Buffer^[CurPos.Index-1] = LF) and
                     (Buffer^[CurPos.Index-2] = CR)
                     then begin
                          SkipUp (CurPos,2) ;
                          Shrink (CurPos.Index,2) ;
                          end
                     else begin
                          SkipUp (CurPos,1) ;
                          Shrink (CurPos.Index,1) ;
                          end ;
                  end ;
          end ;
    273 : { alt-W }
          begin
          NextPos := CurPos ;
          WordDown (NextPos) ;
          if NextPos.Linenr > CurPos.Linenr
             then begin
                  { if start of next word is not on current line }
                  { then delete until next line }
                  NextPos := CurPos ;
                  LineDown (NextPos) ;
                  { only delete CRLF if CurPos is already at end of line }
                  if (NextPos.Index-CurPos.Index) > 2
                     then SkipUp (NextPos,2) ;
                  end ;
          Shrink (CurPos.Index,NextPos.Index-CurPos.Index) ;
          end ;
    294 : { alt-L }
          begin
          Home (CurPos) ;
          NextPos := CurPos ;
          LineDown (NextPos) ;
          Shrink (CurPos.Index,NextPos.Index-CurPos.Index) ;
          end ;
    301 : { alt-X }
          begin
          Counter := 1 ;
          EscPressed := False ;
          while (Counter <= NrOfWorkspaces) and (not EscPressed) do
                begin
                with Workspace[Counter] do
                     if ChangesMade
                        then begin
                             if Config.Setup.SaveOnExit
                                then SaveFile (Counter)
                                else if Answer('File in '+Chr(64+Counter) +
                                               ' has been changed. Save?')
                                        then begin
                                             SaveFile (Counter) ;
                                             { if save unsuccessful: }
                                             { stop exit procedure }
                                             if ChangesMade
                                                then EscPressed := true ;
                                             end ;
                             end ;
                Inc (Counter) ;
                end ; { of while }
          { do not exit from program if Escape was pressed }
          if EscPressed then KeyNr := 0 ;
          end ;
    300 : { alt-Z }
          begin
          Message ('Another Editor by Dick Alstein.  Version '
                   + Version + ', ' + Date + '.') ;
          end ;
    else  begin
          WarningBeep ;
          Message ('This key has no function') ;
          end ;
    end  ; { of case }
  case KeyNr of
    328,336,329,337 : { up,down,PgUp,PgDn }
                      begin
                      { when moving vertically through the buffer: }
                      { try to make Colnr equal to VirtualColnr }
                      { (i.e. the value that it "should" have) }
                      while (CurPos.Colnr < VirtualColnr) and
                            (Buffer^[CurPos.Index] <> CR) and
                            (CurPos.Index < BufferSize) do
                            begin
                            Inc (CurPos.Index) ;
                            Inc (CurPos.Colnr) ;
                            end ;
                      end ;
    else              { all other keys }
                      VirtualColnr := Curpos.Colnr ;
    end  ; { of case }
  end ; { of with }
end ; { of procedure }

{-----------------------------------------------------------------------------}

begin
Initialize ;
repeat if (not KeyPressed) and (MacroStackPointer = Inactive)
          then RedrawScreen ;
       KeyNumber := GetKeynr ;
       ExecKey (KeyNumber) ;
until KeyNumber = 301 ; { alt-X }
ShutOff ;
{$IFDEF DEVELOP }
Writeln (MinMemAvail,' bytes always available') ;
{$ENDIF }
end.

{-----------------------------------------------------------------------------}
{ DEVELOP is a compiler directive for compilation during program              }
{ development. It can be used to find out the amount of unused heap           }
{ memory. Set in the Options/Compiler menu, unset for final compilation       }
{-----------------------------------------------------------------------------}

