/*
 * SetIcon.c defines icon for X application
 *
 * usage: SetIcon(theDisplay, theWindow);
 *
 * do a global replace on "icon" and "mask"
 * GBP
 * Nov 16, 1992
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h> 

#include "icon.bit"
#include "mask.bit"

SetIcon(dsp, wnd)
    Display	*dsp;
    Window	wnd;
{

    Pixmap 	 icon_bmp, icon_mask_bmp;
    XWMHints 	 xwmh;

/* create icon bitmap */    
    if ((icon_bmp=XCreateBitmapFromData(dsp,wnd,
                                        icon_bits,
                                        icon_width,
                                        icon_height))==None)
        printf("Error on icon creation\n");

/* create mask bitmap */
    if ((icon_mask_bmp=XCreateBitmapFromData(dsp,wnd,
                                        mask_bits,
                                        mask_width,
                                        mask_height))==None)
        printf("Error on icon mask creation\n");

/* define the WM attributes */
    xwmh.flags = IconPixmapHint |
                 IconMaskHint;
    xwmh.icon_pixmap = icon_bmp;
    xwmh.icon_mask   = icon_mask_bmp;

/* set the Wm attribrutes */
    XSetWMHints(dsp,wnd,&xwmh);
} 
