/*  mmin2dos.c  -- copy a Minix file into a DOS file */
/*  Copyright 1988,1991 Steven W. Harrold - All rights reserved. */
/*  $Header: MMIN2DOS.C_V 1.3 91/03/19 13:50:17 SWH Exp $ */

#include    <stdio.h>
#include    <stdlib.h>
#include    "mfs.h"
#include    "dev.h"

READ_BLOCK

#define     CR      0x0d
#define     LF      0x0a
#define     CTLZ    0x1a


/*==================================================================*/
PRIVATE void mwrite (buf, flen, text, outfd)
byte            *buf ;
long            *flen ;
BOOL            text ;
FILE            *outfd ;
{
    int     ll, i ;

    ll = (*flen > BLOCK_SIZE) ? BLOCK_SIZE : *flen ;
    *flen -= ll ;

    if (text)
    {
        for (i = 0; i < ll; i++, buf++)
        {
            if (*buf == LF)
                fputc (CR, outfd) ;
            fputc(*buf, outfd) ;
        }
        if (*flen <= 0)
            fputc(CTLZ, outfd) ;
    }

    else
        fwrite (buf, 1, ll, outfd) ;

} /* mwrite() */


/*==================================================================*/
void minix_to_dos (text, ip, ddata, outfd)
BOOL            text ;
struct inode    *ip ;
struct devdata  *ddata ;
FILE            *outfd ;
{
    byte        *bp ;
    ushort      ind_block[BLOCK_SIZE/sizeof(ushort)] ;
    ushort      dbl_block[BLOCK_SIZE/sizeof(ushort)] ;

    int         lim = BLOCK_SIZE / sizeof(ushort) ;

    int         i, j, k, n ;
    int         blkno ;
    byte        buf[BLOCK_SIZE+1] ;
    long        flen ;


    flen = ip->i_size ;

    for (i=0; i<7; i++)
    {
        blkno = ip->i_zone[i] ;
        if (blkno == 0)
            break ;
        read_block(buf, blkno, ddata) ;
        mwrite (buf, &flen, text, outfd) ;
    }

    if (ip->i_ind)
    {
        read_block(ind_block, ip->i_ind, ddata) ;

        for (i=0; i<lim; i++)
        {
            blkno = ind_block[i] ;
            if (blkno == 0)
                break ;
            read_block(buf, blkno, ddata) ;
            mwrite (buf, &flen, text, outfd) ;
        }
    }

    if (ip->i_dbl_ind)
    {
        read_block(dbl_block, ip->i_dbl_ind, ddata) ;

        for (i=0; i<lim; i++)
        {

            blkno = dbl_block[i] ;
            if (blkno == 0)
                break ;
            read_block(ind_block, blkno, ddata) ;

            for (j=0; j<lim; j++)
            {
                blkno = ind_block[j] ;
                if (blkno == 0)
                    break ;
                read_block(buf, blkno, ddata) ;
                mwrite (buf, &flen, text, outfd) ;
            }
        }
    }

} /* minix_to_dos() */


/*---eof---*/
