/*  mgetinod.c  -- get requested inode entry */
/*  Copyright 1988,1991 Steven W. Harrold - All rights reserved.*/
/*  $Header: MGETINOD.C_V 1.2 91/03/19 09:57:56 SWH Exp $ */

#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    "mfs.h"
#include    "dev.h"

READ_FILE


/*==================================================================*/
struct inode *get_inode (ddata, iarea, ip, path)
struct devdata  *ddata ;
struct inode    *iarea ;
struct inode    *ip ;
char            **path ;
{
    struct directory    *darea, *dp ;
    int                 dn, dnz ;

    int         i, j, k, n ;
    char        c, *p ;
    char        npath[MAX_PATH+1] ;
    BOOL        found ;


    dn = ip->i_size / sizeof(struct directory) ;
    dnz = dn * sizeof(struct directory) + BLOCK_SIZE - 1 ;
    dnz /= BLOCK_SIZE ;
    dnz *= BLOCK_SIZE ;
    dnz /= sizeof(struct directory) ;
    darea = calloc (dnz+1, sizeof(struct directory)) ;
    if (!darea)
        exit(3) ;

    read_file (darea, ip, ddata) ;

/*  Scan the directory for the name of the current path component
 */
    dp = darea ;
    found = FALSE ;
    for (i=0; !found && i<dn; i++, dp++)
        if (strncmp (dp->d_name, *path, NAME_SIZE) == 0)
        {
            found = TRUE ;
            break ;
        }

    if (!found)
    {
        ip = NULL ;
        goto quit ;
    }

    ip = iarea + dp->d_inum ;

/*  Now, for those entries that are themselves directories,
 *  display them recursively.
 */
    path++ ;
    if (!*path)
    {
        goto quit ;
    }

    ip = get_inode(ddata, iarea, ip, path) ;

/*  Clean up
 */
quit:
    free (darea) ;
    return ip ;

} /* get_inode() */


/*---eof---*/
