/*  mrfile.c    -- read a Minix file into a buffer */
/*  Copyright 1988,1991 Steven W. Harrold - All rights reserved. */
/*  $Header: MRFILE.C_V 1.2 91/03/19 09:58:14 SWH Exp $ */

#include    <stdio.h>
#include    <stdlib.h>
#include    "mfs.h"
#include    "dev.h"

READ_BLOCK


/*==================================================================*/
void read_file(buf, ip, ddata)
void            *buf ;
struct inode    *ip ;
struct devdata  *ddata ;
{
    byte        *bp ;
    ushort      ind_block[BLOCK_SIZE/sizeof(ushort)] ;
    ushort      dbl_block[BLOCK_SIZE/sizeof(ushort)] ;

    int         lim = BLOCK_SIZE / sizeof(ushort) ;

    int         i, j, k, n ;
    int         blkno ;


    bp = buf ;
    for (i=0; i<7; i++, bp += BLOCK_SIZE)
    {
        blkno = ip->i_zone[i] ;
        if (blkno == 0)
            break ;
        read_block(bp, blkno, ddata) ;
    }

    if (ip->i_ind)
    {
        read_block(ind_block, ip->i_ind, ddata) ;

        for (i=0; i<lim; i++, bp += BLOCK_SIZE)
        {
            blkno = ind_block[i] ;
            if (blkno == 0)
                break ;
            read_block(bp, blkno, ddata) ;
        }
    }

    if (ip->i_dbl_ind)
    {
        read_block(dbl_block, ip->i_dbl_ind, ddata) ;

        for (i=0; i<lim; i++)
        {

            blkno = dbl_block[i] ;
            if (blkno == 0)
                break ;
            read_block(ind_block, blkno, ddata) ;

            for (j=0; j<lim; j++, bp += BLOCK_SIZE)
            {
                blkno = ind_block[j] ;
                if (blkno == 0)
                    break ;
                read_block(bp, blkno, ddata) ;
            }
        }
    }

} /* read_file() */


/*---eof---*/
