/*
	FIPS - the First nondestructive Interactive Partition Splitting program

	Module save.cpp

	RCS - Header:
	$Header: c:/daten/c/fips/source/cpp/RCS/save.c%v 3.0 1993/06/08 18:22:16 schaefer Exp schaefer $

	Copyright (C) 1993 Arno Schaefer

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


	Report problems and direct all questions to:

	schaefer@silene.imag.fr
*/

#include <stdio.h>
#include "global.h"
#include "hdstruct.h"

/* ----------------------------------------------------------------------- */
/* Save root- and bootsector to floppy disk                                */
/* ----------------------------------------------------------------------- */

void save_root_and_boot (harddrive *drive,partition *partition)
{
	FILE *save_file;

	if ((save_file = fopen ("a:\\rootboot.000","wb")) == NULL)
		error ("Can't open file A:\\ROOTBOOT.000");

	if (fwrite (drive->rootsector->data,1,512,save_file) != 512)
		error ("Error writing file A:\\ROOTBOOT.000");
	if (fwrite (partition->bootsector->data,1,512,save_file) != 512)
		error ("Error writing file A:\\ROOTBOOT.000");
	if (fputc (drive->number,save_file) != drive->number)
		error ("Error writing file A:\\ROOTBOOT.000");
	if (fputc (partition->number,save_file) != partition->number)
		error ("Error writing file A:\\ROOTBOOT.000");

	if (fclose (save_file))
		error ("Error closing file A:\\ROOTBOOT.000");
}

