/*
	FIPS - the First nondestructive Interactive Partition Splitting program

	Module input.cpp

	RCS - Header:
	$Header: c:/daten/c/fips/source/cpp/RCS/input.c%v 3.0 1993/06/08 18:22:08 schaefer Exp schaefer $

	Copyright (C) 1993 Arno Schaefer

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


	Report problems and direct all questions to:

	schaefer@silene.imag.fr
*/

#include <ctype.h>
#include <stdlib.h>
#include "types.h"
#include "disk_io.h"
#include "global.h"
#include "input.h"

/* ----------------------------------------------------------------------- */
/* User Input                                                              */
/* ----------------------------------------------------------------------- */

static void wait_for_key (void)
{
	printx ("\nPress any Key\n");
	getx();
}

int ask_for_drive_number (void)
{
	int number_of_drives = 0;
	int drive_table[] = {0,0,0,0,0,0,0,0,0};

	for (int i=128;i<256;i++) if (get_disk_type(i))
	{
		drive_table[number_of_drives++] = i;
		if (number_of_drives == 10)
			error ("Too many drives found");
	}

	if (number_of_drives == 0)
		error ("No Compatible Harddisk found");
	if (number_of_drives == 1) return (drive_table[0]);

	printx ("Which Drive (");

	for (i=0;i<number_of_drives;i++) printx ("%u/",i+1);
	printx ("\b)? ");

	while (true)
	{
		i = getx ();
		if (isdigit (i)) if (i > '0') if (drive_table[i - '1']) break;
	}
	printx ("%c\n",i);
	return (drive_table[i - '1']);
}

int ask_for_partition_number (partition_info parts[])
{
	int number_of_partitions = (parts[0].system != 0) + (parts[1].system != 0) +
		 (parts[2].system != 0) + (parts[3].system != 0);

	if (number_of_partitions == 0)
		error ("No valid partition found");

	if (number_of_partitions == 4)
		error ("No free partition");

	if (number_of_partitions == 1)
	{
		if (!global.quiet_mode) wait_for_key();
		for (int i=0;i<4;i++) if (parts[i].system) return i;
	}

	printx ("\nWhich Partition do you want to split (");

	for (int i=0;i<4;i++) if (parts[i].system) printx ("%u/",i+1);
	printx ("\b)? ");

	while (true)
	{
		i = getx ();
		if (isdigit (i)) if (('0' < i) && (i <= '4')) if (parts[i-'1'].system) break;
	}
	printx ("%c\n",i);
	return (i-'1');
}

static int readnumber (int max_length)
{
	int number = 0;
	int length = 0;

	while (true)
	{
		int character = getx();
		if (isdigit(character))
		{
			if (length < max_length)
			{
				printx ("%c",character);
				number = 10 * number + character - '0';
				length++;
			}
		}
		else if (character == '\b')
		{
			if (length > 0)
			{
				printx ("\b \b");
				number = number / 10;
				length--;
			}
		}
		else if (character == '\r') return (number);
	}
}

dword ask_for_new_start_cylinder (int min_cylinder,int max_cylinder)
{
	while (true)
	{
		printx ("Enter start cylinder for new partition (%u - %u):     \b\b\b\b",min_cylinder,max_cylinder);
		int cylinder=readnumber((max_cylinder > 99) ? ((max_cylinder > 999) ? 4 : 3) : 2);
		printx("\r");
		if ((cylinder >= min_cylinder) && (cylinder <= max_cylinder))
		{
			printx("\n\n");
			return (cylinder);
		}
	}
}

void ask_for_write_permission (void)
{
	if (global.quiet_mode) return;

	printx ("\nReady to write new partition scheme to disk\n");
	printx ("Do you want to proceed (y/n)? ");

	int character;
	do character = getx(); while ((character != 'y') && (character != 'n'));
	printx ("%c\n",character);
	if (character == 'n') exit (0);
}

boolean ask_if_continue (void)
{
	if (global.quiet_mode) return (true);

	printx ("\nDo you want to continue or reedit the partition table (c/r)? ");

	int character;
	do character = getx(); while ((character != 'c') && (character != 'r'));
	printx ("%c\n",character);
	if (character == 'r') return (false);
	return (true);
}

boolean ask_if_save (void)
{
	if (global.ask_if_backup)
	{
		int character;

		printx ("Do you want to make a backup copy of your root- and bootsector before\nproceeding (y/n)? ");
		do character = getx(); while ((character != 'y') && (character != 'n'));
		printx ("%c\n\n",character);
		if (character == 'n') return (false);

		printx ("Do you have a bootable floppy disk in drive A: as described in the\ndocumentation (y/n)? ");
		do character = getx(); while ((character != 'y') && (character != 'n'));
		printx ("%c\n\n",character);
		if (character == 'n')
		{
			printx ("Please read the file FIPS.DOC!\n");
			exit (0);
		}
	}

	if (!global.backup_root) return (false);

	return (true);
}
