;
;  Name:             CONIO.ASM
;  Purpose:          keyboard & text video functions
;  Calling Language: Borland Turbo Pascal 5.50
;  Date:             December 8, 1989
;  Assembler:        Borland Turbo Assembler 1.00
;  Author:           J. Rockford Cogar
;  Company:          Nucleus Inc. 761 Emory Valley Road, Oak Ridge TN 37830
;  Rights:           You MAY use this code for ANY purpose private or commercial
;
        .MODEL  TPASCAL
        .CODE
; prototype: void near cursorxy(byte col, byte row);
        PUBLIC cursorxy
;***********************************************************************
cursorxy proc   near col: BYTE, row: BYTE
         mov    ah,02                           ; set cursor position function
         mov    bh,0                            ; page zero
         mov    dh,row                          ; set glyph row number
         mov    dl,col                          ; set glyph column number
         int    010h                            ; do BIOS video interrupt call
         ret
cursorxy        ENDP
;***********************************************************************

; prototype: int near cgets(char *strg);
; purpose:   emulate the Turbo C cgets() function
;            *strg is the string to input into
;
        PUBLIC cgets
;***********************************************************************
cgets    proc   near strg: DWORD
         push   ds
         lds    si,dword ptr strg;      ; load the pointer
         mov    dx,si                   ; PASS ptr in DS:DX
         mov    ah,10;                  ; DOS bufferd KBD input function
         int    21h                     ; call DOS
         mov    si,dx
         inc    si                      ; point to the next (strg[1]) byte
         cld
         lodsb                          ; fetch strg[1]
         mov    ah,0                    ; zero the hi byte
         pop    ds
         ret
cgets    ENDP
;***********************************************************************

;       Function Name:        getscode
;       Function Prototype:   integer getscode(void);
;       Calling Language:     Turbo Pascal 5.50
;       Purpose:              Read the current scan code
;       External Code:        None
;       Returns:              scan code in 'AH'. Ascii Code in 'AL', zero if no key was ready
;
        PUBLIC getscode
;***********************************************************************
getscode proc near
        mov     ah,1
        int     016h                    ; bios kbd int service
        jnz     kready                  ; jmp to get the key that is ready
                                        ; top of key not ready block
        xor     ax,ax                   ; set AX to say no key was ready
        jmp     retgsc                  ; return to calling function
kready:
        mov     ah,0
        int     016h                    ; bios kbd int service
retgsc:
        ret
getscode endp
;***********************************************************************

;       Function Name:        readkbd
;       Function Prototype:   integer readkbd(void);
;       Calling Language:     Turbo Pascal 5.50
;       Purpose:              Pause and Read the current scan code
;       External Code:        None
;       Returns:              scan code in AX register
;
        PUBLIC readkbd
;***********************************************************************
readkbd proc near
        mov     ah,0
        int     016h                    ; bios kbd int service
        int     016h                    ; bios kbd int service
        xchg    al,ah                   ; puts scan code in AL
        mov     ah,0                    ; zero out the ascii code
        ret
readkbd endp
;***********************************************************************

; integer near getvmode(void)
;  used to get the current BIOS video mode
;
       PUBLIC getvmode
;***********************************************************************
getvmode proc near
         mov    ah,0fh                          ; BIOS service to get the current video mode
         int    010h                            ; call BIOS
         mov    ah,0                            ; zero out width of text mode screen
         ret
getvmode endp
;***********************************************************************
;
;   void near snowwrite(int col, int row, char color, char *strg, int soff, int maxchars, int clrchar);
;   col      : int      ;  CRT column
;   row      : int      ;  CRT row
;   color    : byte     ;  color to write the string in
;   strg     : *char    ;  string to write
;   soff     : int      ;  position of (array index) of first char to write
;   maxchars : int      ;  maximum number of chars to write
;   clrchar  : int      ;  number of chars to clear (field width)
; Write a string to the CRT and clear the specified nunber of spaces
; providing the string does not fill the entire field
; also start the write from sourceof and only write maxchars
; * for text modes only!
;
           PUBLIC snowwrite
;***********************************************************************
snowwrite   proc near col:WORD, row:WORD, color:BYTE, strg:DWORD, soff:WORD, maxchars:WORD, clrchar:WORD
            LOCAL strlen:WORD, toclear:WORD=AUTO_SIZE
            push    ds
            cld                         ; clear direction flag
            les     di,strg             ; load seg & off dor large data models
            mov     al,byte ptr es:[di] ; fetch length byte
            mov     ah,0                ; limit length to 255 bytes
            mov     bx,word ptr soff    ; sourceof.  get the string source offset
            cmp     ax,bx               ; compare str length (AX) with str offset (BX)
            jg      itsok               ; jump to assignment if string offset < string length
            jmp     SHORT notok         ; if string offset > string length goto notok:
itsok:      sub     ax,bx               ; adjust the string length for the new offset
            jmp     SHORT assgn         ; jump dowm to assgn
notok:      mov     ax,0000H            ; zero out AX (string length) cause the specified string offset was too big
assgn:      mov     [strlen],ax         ; store the string length in strlen (vaiable)
            sub     ax,ax               ; zero out AX
            mov     es,ax               ; put zero in for extra segment
            mov     al,es:[0449h]       ; offset of 449h is needed
            cmp     al,7                ; is value in al 7 ?
            je      mdabase             ; if 7 then its monochrome
            mov     ax,0b800h           ; if not then use CGA for base address
            jmp     SHORT assign        ; goto assign: label
mdabase:                                ; label: where MDA address is put in AX
            mov     ax,0b000h           ; MDA adapter
assign:                                 ; label: where extra seg is assigned
            mov     es,ax               ; point to start of video buffer
            lds     si,dword ptr strg   ; load seg & off for large data models
            inc     si                  ; jump past the length byte
            add     si,bx               ; add the string source offset to SI
            mov     bl,byte ptr color   ; color. get the attribute value
            mov     cx,word ptr col     ; col  . column address
            mov     ax,word ptr row     ; row  . row address
            mov     dx,160              ; bytes per line in CGA
            mul     dx                  ; 160 * row number
            add     ax,cx               ; add column number to offset in CGA buffer
            add     ax,cx               ; add column number to offset in CGA: again
            mov     di,ax               ; put address in CGA into DI
            mov     cx,[strlen]         ; count of chars to write
            cmp     cx,0000h            ; is CX set to zero
            je      gclrchar            ; jump to gclrchar: if CX is zero (there are only chars to clear. none to write)
            mov     ax,word ptr maxchars; maxchars.  get the maximum number of chars to write parameter
            cmp     cx,ax               ; compare string length with maxchars (max allowed chars to write)
            jg      toolong             ; make the string length shorter (it exceeds the max)
            jmp     SHORT gclrchar      ; jump around the next assignment instruction
toolong:    mov     cx,ax               ; set string length to maxchars
gclrchar:   mov     dx,word ptr clrchar ; clrchar. get the number of chars to clear (parameter)
            sub     dx,cx               ; subtract chars to write from clrchar (causes extra work in rare cases)
            cmp     dx,1                ; compare the difference with one
            jl      tooshort            ; if DX is less than one goto tooshort:
            jmp     SHORT alright       ; else goto alright:
tooshort:   mov     dx,0000h            ; set DX to zero (there are no chars to clear)
alright:    mov     [toclear],dx        ; set toclear to the value of DX
oklength:   mov     ah,bl               ; put in an attribute byte in AH (one time !)
            cmp     cx,0000h            ; compare CX to zero. if (cx == 0) goto mdaclear:
            je      mdaclear            ; goto mdaclear: (if cx == 0)
monotop:
            lodsb                       ; get one character put in AL
            stosw                       ; move the word NOW! into the CRT
            loop    monotop             ; bottom of loop
mdaclear:   mov     cx,[toclear]        ; length of field to clear
            cmp     cx,1                ; compare toclear to one
            jl      endfast             ; no spaces need clearing so EXIT
            mov     al,20h              ; put a space char into AL
            rep     stosw               ; zing em all now! (clear the rest of the field)
endfast:                                ; end of effective code
            pop     ds
            ret
snowwrite endp
;***********************************************************************
;
;  SNOWPUTC.ASM  write a char(s) to the textmode screen
;                no 'snow' checking is done
;
; prototype: void far snowputc(int col, int row, char color, char outch, int numb);
;
        PUBLIC snowputc
snowputc proc    near col: WORD, row: WORD, color: BYTE, outch: BYTE, numb: WORD
        cld                         ; clear direction flag
        sub     ax,ax               ; zero out AX
        mov     es,ax               ; put zero in for extra segment
        mov     al,es:[0449h]       ; offset of 449h is needed
        cmp     al,7                ; is value in al 7 ?
        je      short mdabasepc     ; if 7 then its monochrome
        mov     ax,0b800h           ; if not then use CGA for base address
        jmp     short assignpc      ; goto assign: label
mdabasepc:                          ; label: where MDA address is put in AX
        mov     ax,0b000h           ; MDA adapter
assignpc:                           ; label: where extra seg is assigned
        mov     es,ax               ; point to address in video buffer
        mov     bl,byte ptr outch   ; get the character
        mov     bh, byte ptr color  ; get the attribute
        mov     cx,col              ; column address
        mov     ax,row              ; row address
        mov     dx,160              ; bytes per line in CGA
        mul     dx                  ; 160 * row number
        add     ax,cx               ; add column number to offset in CGA buffer
        add     ax,cx               ; add column number to offset in CGA: again
        mov     di,ax               ; put address in CGA into DI
        mov     cx,numb             ; get the count of chars to write
        mov     ax,bx               ; put in an attribute byte in AX (one time !)
        rep     stosw               ; move the number of char+atribb pairs
        ret
snowputc       ENDP

; prototype: void near puts(char *strg);
; purpose:   emulate the Turbo C puts() function (text output (slow) in any video mode }
;            *strg is the string to output to STDOUT
;
        PUBLIC puts
;***********************************************************************
puts    proc   near strg: DWORD
         push   ds
         cld
         lds    si,dword ptr strg;      ; load the pointer
         lodsb                          ; load length byte inc pointer
         mov    cx,ax                   ; copy length
         mov    ch,0                    ; max output is 255 bytes
         mov    dx,si                   ; PASS ptr in DS:DX
         mov    bx,1;                   ; STDOUT
         mov    ah,40h;                 ; DOS write file
         int    21h                     ; call DOS
         pop    ds
         ret
puts    ENDP
;***********************************************************************


        END
