;dbvid.asm 
;Debugger video routines
;
.386P
;---------------------------------------------------------------------------- 
;Copyright 1991, 1992 ASMicro Co. 
;7/6/91	   Rick Knoblaugh
;-----------------------------------------------------------------------------
                include dbequ.inc
                include dbstruc.inc

data            segment para public 'data16' use16
                extrn   save_curs_pos:word
                extrn   config_attrib:byte 
                extrn   debug_page:byte                        
                extrn   wrk_vid_offset:word
                extrn   user_page:byte
                extrn   debug_page_off:word
                extrn   prompt_char:byte
data            ends

zcode            segment para public 'code16' use16

                public  prt_err_msg, prt_string, scroll_cmds_up, scroll_up              
                public  set_video_page, set_cursor_pos, calc_offset     
                public  prt_prompt, get_cursor_pos          
                public  clear_window                    

	assume cs:zcode, ds:data, es:nothing

;----------------------------------------------------------------------
; prt_err_msg - scroll window and print error message.                |
;                                                                     |
;             Enter: si = offset of error message.                    |
;                                                                     |
;              Exit: Carry flag set as many callers would also do     |
;                    this.                                            |
;----------------------------------------------------------------------
prt_err_msg     proc    near
                mov     di, wrk_vid_offset              ;prompt location
                add     di, 2                           ;just after prompt
                mov     ah, config_attrib
                call    prt_string
                call    scroll_cmds_up
                stc
                ret
prt_err_msg     endp

;----------------------------------------------------------------------
; prt_string - display string on screen.                              |
;                                                                     |
;             Enter: si = offset of string (STR_TERM terminated)      |
;                    es = video segment                               |
;                    di = offset into video buffer for display        |
;                    ah = attribute to be used for display.           |
;                                                                     |
;----------------------------------------------------------------------

prt_char:
                stosw

prt_string      proc    near
                lodsb
                cmp     al, STR_TERM
                jne     short prt_char
                ret
prt_string      endp


;----------------------------------------------------------------------
; scroll_cmds_up - scroll command area up 1 line.                     |
;                                                                     |
;            Enter:             es = segment of video buffer.         |
;                   wrk_vid_offset = offset of prompt in video buffer.|
;                                                                     |
;             Exit:             di = offset of next location past     |
;                                    prompt char in video buffer.     |
;                                                                     |
;             ax, cx, dx, si saved.                                   |
;----------------------------------------------------------------------
scroll_cmds_up  proc    near
                push    ax
                push    cx
                push    dx
                push    si
                mov     si, debug_page_off
                add     si, (DEBUG_COL * 2) + 2
                mov     cx, DEBUG_ROW           ;number of rows
                mov     dx, CMD_MAX_LEN         ;number of columns
                mov     ah, config_attrib       ;attribute for bottom line
                mov     al, ' '                 ;fill char for bottom line
                call    scroll_up
                mov     di, wrk_vid_offset      ;get prompt location
                add     di, 2                   ;just past prompt
                pop     si
                pop     dx
                pop     cx
                pop     ax
                ret
scroll_cmds_up  endp
;----------------------------------------------------------------------
; scroll_up - scroll window up 1 line.                                |
;                                                                     |
;             Enter: es = segment of video buffer.                    |
;                    si = offset of upper left hand corner            |
;                    cx = number of rows to move up                   |
;                    dx = number of columns in width                  |
;                    ax = attribute/char for filling bottom line      |
;                                                                     |
;         DS saved.                                                   |
;                                                                     |
;----------------------------------------------------------------------
scroll_up       proc    near
                jcxz    short scroll_up999      ;if none to scroll
                push    ds

                push    es
                pop     ds                      ;ds=es=video
scroll_up100:
                push    cx
                mov     di, si
                add     si, 160                 ;next line up
                push    si
                mov     cx, dx
                rep     movsw
                pop     si
                pop     cx
                loop    scroll_up100
                mov     cx, dx
                mov     di, si
                rep     stosw
                pop     ds

scroll_up999:
                ret
scroll_up       endp

;----------------------------------------------------------------------
;set_video_page - Make video page active.                             |
;                                                                     |
;             Enter: bl = page to make active                         |
;             All registers saved.                                    |
;----------------------------------------------------------------------
set_video_page  proc    near
                push    ax
                push    bx
                push    dx
                push    es
                mov     al, bl
                cbw
                mov     dx, PAGE_SIZE/2 ;page size in words
                mul     dx
                push    ax              ;save page offset in words

                mov     dx, 40h         ;bios data area
                mov     es, dx
                mov     dx, es:[ADDR_6845]      ;get address register
                mov     al, 0ch         ;start address high
                out     dx, al

                inc     dx              ;data register
                xchg    al, ah          ;get high portion into al
                out     dx, al          ;write it out
                dec     dx              ;back to address register
                mov     al, 0dh         ;start address low
                out     dx, al
                inc     dx              ;data register
                pop     ax              ;restore offset in words
                out     dx, al          ;write it out

                pop     es
                pop     dx
                pop     bx
                pop     ax
                ret
set_video_page  endp

;----------------------------------------------------------------------
;set_cursor_pos - Program hardware directly to set cursor position.   |
;                                                                     |
;                 Enter:  ax = video offset in words                  |
;                                                                     |
;----------------------------------------------------------------------
set_cursor_pos 	proc  near
                push    ax
                push    cx
                push    dx
                push    es
                mov     cl, al          ;save low portion

                mov     dx, 40h         ;bios data area
                mov     es, dx
                mov     dx, es:[ADDR_6845]      ;get address register
                
                mov     al, 0eh         ;cursor location high
                out     dx, al
                inc     dx
                xchg    ah, al
                out     dx, al          ;write high portion
                
                dec     dx
                mov     al, 0fh         ;cursor location low
                out     dx, al
                inc     dx
                mov     al, cl          ;get low ;portion
                out     dx, al
                pop     es
                pop     dx
                pop     cx
                pop     ax

                ret
set_cursor_pos 	endp    


;----------------------------------------------------------------------
;calc_offset - calculate offset (in words) into video buffer.         |
;                                                                     |
;                 Enter:  bl = video page                             |
;                         ch = row of cursor position (0-24)          |
;                         cl = column of cursor position (0-79)       |
;                                                                     |
;                 Exit:                                               |
;                         ax = offset in words                        |
;----------------------------------------------------------------------
calc_offset     proc    near
                mov     al, 80          ;words in a line
                mul     ch
                sub     ch, ch
                add     ax, cx

                mov     cx, ax          ;save it
                sub     bh, bh
                mov     ax, PAGE_SIZE/2
                mul     bx
                add     ax, cx          ;ax=total offset in words
                ret
calc_offset     endp

;----------------------------------------------------------------------
;prt_prompt - display prompt character at current buffer offset.      |
;                                                                     |
;                 Enter:  es = segment of video buffer                |
;                         di = video buffer offset                    |
;                                                                     |
;                                                                     |
;                 Exit: di advanced to next buffer position           |
;                                                                     |
;----------------------------------------------------------------------
prt_prompt      proc    near
                mov     al, prompt_char
                mov     ah, config_attrib
                stosw
                ret
prt_prompt      endp        


  
;----------------------------------------------------------------------
;get_cursor_pos - Retrieve cursor position for active video page      |
;                 from the BIOS data area.                            |
;                                                                     |
;                 Exit:                                               |
;                         ah = row of cursor position (0-24)          |
;                         al = column of cursor position (0-79)       |
;                         dl = active page                            |
;                                                                     |
;----------------------------------------------------------------------
get_cursor_pos  proc    near
                push    bx
                push    ds
                mov     ax, 40h         ;bios data area
                mov     ds, ax
                xor     bx, bx
                mov     bl, [bx + ACTIVE_PAGE]
                mov     dl, bl
                shl     bx, 1           ;index into words
                mov     ax, [bx + CURSOR_POS]
                pop     ds
                pop     bx
                ret
get_cursor_pos  endp        



;----------------------------------------------------------------------
;clear_window - Clear a window with a specified char and attribute.   |
;                                                                     |
;                 Enter:  bl = video page                             |
;                         es = video segment or selector              |
;                         dx = row, col of upper left hand corner     |
;                         cx = row, col of lower right hand corner    |
;                         ax = attribute, char to use                 |
;                                                                     |
;                 Exit:                                               |
;                         all registers saved.                        |
;                                                                     |
;----------------------------------------------------------------------
clear_window    proc    near
                push    bx
                push    cx
                push    dx
                push    di

                push    ax
                push    dx
                mov     ax, PAGE_SIZE
                sub     bh, bh
                mul     bx              ;compute start of buffer per page
                pop     dx
                mov     di, ax
                mov     al, 160         ;entire row of chars and attributes
                sub     ch, dh          ;ch=total rows to clear
                inc     ch
                mul     dh              ;ax=offset to starting row
                add     di, ax
                sub     dh, dh
                mov     al, dl          ;save starting column
                shl     dl, 1           ;count attributes also
                add     di, dx          ;add offset out to starting col
                sub     cl, al          ;get total columns in width
                inc     cl
                sub     dh, dh
                mov     dl, cl          ;put in dx
                mov     cl, ch
                sub     ch, ch
                pop     ax              ;restore attribute/char
                mov     bx, di          ;save starting offset for row
                
clear_w100:
                push    cx
                mov     cx, dx          ;width in columns
                rep     stosw
                pop     cx              ;row count
                add     bx, 160         ;offset for next row
                mov     di, bx
                loop    clear_w100

                pop     di
                pop     dx
                pop     cx
                pop     bx
                ret
clear_window    endp        

zcode            ends
        	end     

