;---------------------------------------------------------------    
;dbpdat.inc - data used mostly in protected mode areas of      |
;             debugger.                                        |
;--------------------------------------------------------------|
;
dbstack3        segment para stack 'data16' use16
                public  db_sp3
STACK3_BEG      EQU     $
db_stack3       dw      256 dup('S')
db_sp3          equ     $   
STACK3_END      EQU     $
dbstack3        ends

dbstack         segment para public 'data16' use16
STACK_BEG       EQU     $
db_stack        dw      256 dup('S')
db_sp           label   word
STACK_END       EQU     $
dbstack         ends

gdt_seg         segment para public 'data16' use16
                public  sel_databs, sel_stack, sel_video    
                public  sel_code, sel_data, sel_tss_alias
                public  sel_isrcode, sel_stack3      

GDT_BEG         EQU     $
sel_null        seg_descrip     <>
sel_tss         seg_descrip     <>
sel_tss_alias   seg_descrip     <>
sel_gdt_alias   seg_descrip     <>
sel_isrcode     seg_descrip     <>
sel_code        seg_descrip     <>
sel_databs      seg_descrip     <>
sel_stack       seg_descrip     <>
sel_stack3      seg_descrip     <>
sel_video       seg_descrip     <>
sel_data        seg_descrip     <>
GDT_END         EQU     $
gdt_seg         ends                              

idt_seg         segment para public 'data16' use16
IDT_BEG         EQU     $
                DEFIDTI 0
                idt     <isrcode:int_1,gdt_seg:sel_isrcode,,PRESENT+(DPL0 shl 5)+INT_GATE,>
                DEFIDTI 2
                idt     <,,,PRESENT + (DPL0 shl 5) + INT_GATE,> 
                
                irp     z, <4, 5, 6, 7>
                DEFIDTI &z
                endm

                irp     z, <8, 9, 0ah, 0bh, 0ch, 0dh, 0eh, 0fh>
                DEFIDTE &z
                endm

 idt       (1fh - 0fh)  dup(<,,,PRESENT + (DPL0 shl 5) + INT_GATE,>)

                irp     z, <20h, 21h, 22h, 23h, 24h, 25h, 26h, 27h>
                DEFIDTI &z
                endm
 idt       (6Fh - 27h)  dup(<,,,PRESENT + (DPL0 shl 5) + INT_GATE,>)

                irp     z, <70h, 71h, 72h, 73h, 74h, 75h, 76h, 77h>
                DEFIDTI &z
                endm

IDT_END         EQU     $
idt_seg         ends                              


tss_seg         segment para public 'data16' use16
TSS_BEG         EQU     $
                tss_dat <>
TSS_END         EQU     $
tss_seg         ends                              

