;dbinit.asm
;Debugger initialization routines
;
.386P
;---------------------------------------------------------------------------- 
;Copyright 1991, 1992 ASMicro Co. 
;7/6/91	   Rick Knoblaugh
;-----------------------------------------------------------------------------
                include dbequ.inc
                include dbstruc.inc
                include dbmac.inc
                include dbpdat.inc

data            segment para public 'data16' use16

                extrn   gdtl:fword, gdtlim:word, gdtadrs:dword
                extrn   idtl:fword, idtlim:word, idtadrs:dword
                extrn   DATA_BEG:abs, DATA_END:abs, video_seg:word

data            ends


;--------------------------------------------------------------
;EXTERNALS                                                    |
;--------------------------------------------------------------
isrcode         segment para public 'icode16' use16
                extrn   int_0:far, int_1:far, int_2:far, int_3:far, int_4:far
                extrn   int_5:far, int_6:far, int_7:far, except_8:far
                extrn   except_9:far, except_0ah:far, except_0bh:far
                extrn   except_0ch:far, except_0dh:far, except_0eh:far
                extrn   except_0fh:far, int_20h:far, int_21h:far
                extrn   int_22h:far, int_23h:far, int_24h:far, int_25h:far
                extrn   int_26h:far, int_27h:far, int_70h:far, int_71h:far
                extrn   int_72h:far, int_73h:far, int_74h:far, int_75h:far
                extrn   int_76h:far, int_77h:far
isrcode         ends                               


zcode            segment para public 'code16' use16
                assume cs:zcode, ds:data, es:data   
                .8086
last_code       label   byte
sign_msg1       db      'DB Version 1.0', CR, LF, '$'
sign_msg2       db      'Copyright ASMicro Co. 1991, 1992', CR, LF , CR, LF, '$'
noprot_msg      db      'Can not run if already in protected mode.',BEEP, CR, LF, '$'
not386_msg      db      'Program requires at least an 80386.', BEEP, CR, LF, '$'

start           proc    far 

                push    ds              ;save psp seg
                mov     ax, data
                mov     es, ax
                mov     ds, ax

                call    verify_cpu
                jnc     short start_200       ;continue if 386/486 in real mode

                assume  ds:zcode
                push    cs
                pop     ds              ;get segment for messages

                mov     ah, DOS_PRT_STRING
                int     21h
                mov     ax, 4c01h
                int     21h
.386P
start_200:
                call    init_gdt
                call    init_tss

                mov     ax, data   
                mov     ds, ax
                assume  ds:data   

                cli                     ;no ints until protected mode

                mov     ax, gdt_seg
                movzx   eax, ax
                shl     eax,  4
                mov     gdtadrs, eax
                mov     gdtlim, (GDT_END-GDT_BEG)-1


                mov     ax, idt_seg
                movzx   eax, ax
                shl     eax,  4
                mov     idtadrs, eax
                mov     idtlim, (IDT_END-IDT_BEG)-1

                call    reprogram_pic

                lgdt    gdtl
                lidt    idtl

                mov     dx, dbstack3    ;get stack segment
                mov     bx, sp          ;and pointer
                mov     eax, cr0
                or      eax, 1          ;turn on protected mode bit
                mov     cr0, eax        ;go into protected mode

;
;jump to clear prefetch queue
;
                db      0eah            ;far jump
                dw      offset zcode:start_400
                dw      gdt_seg:sel_code
start_400:
                mov     ax, offset gdt_seg:sel_tss
                ltr     ax
                xor     ax, ax
                lldt    ax              ;null ldt
                mov     ax, seg data
                movzx   eax, ax
                push    eax             ;gs
                push    eax             ;fs
                push    eax             ;ds
                push    eax             ;es

                push    0
                push    dx              ;stack segment
                push    0
                push    bx              ;stack pointer

                push    2               ;VM bit set in upper eflags
                push    3000h           ;NT=0, IOPL=3, CLI in lower eflags
                push    0
                push    seg zcode        ;cs of where to return
                push    0
                push    offset zcode:start_500  ;ip of where to return
;
;Must ensure that Nested Task bit is not set in eflags.  If it were,
;processor would attempt to switch to a task via the selector in
;the TSS backlink field.  Since that field is now zero, an invalid TSS
;fault would occur.
;
                pushf
                pop     ax
                btr     ax, nest_taskf
                push    ax
                popf
                iretd

start_500:                              ;begin vm86 task here
                pop     bx              ;get saved psp seg
                sti                     ;interrupts ok now

                assume ds:zcode
                push    cs
                pop     ds
                mov     dx, offset sign_msg1    
                mov     ah, DOS_PRT_STRING
                int     21h
                mov     dx, offset sign_msg2    
                mov     ah, DOS_PRT_STRING
                int     21h
                mov     dx, zcode + 1    
                mov     ax, offset last_code
                shr     ax, 4
                add     dx, ax
                sub     dx, bx                  ;paragraphs to keep
                mov     ax, (DOS_TSR_FUNC SHL 8) ;exit code 0      
                int     21h

start           endp        



reprogram_pic   proc    near
                in      al, 21h
                mov     ah, al
                mov     al, 11h         ;init
                out     20h, al
                mov     al, 20h         ;irq0 to int 20h
                out     21h, al
                jmp     short $ + 2
                jmp     short $ + 2
                mov     al, 4
                out     21h, al
                jmp     short $ + 2
                jmp     short $ + 2
                mov     al, 1
                out     21h, al
                jmp     short $ + 2
                jmp     short $ + 2
                mov     al, ah
                out     21h, al
                ret
reprogram_pic   endp

.8086


verify_cpu      proc    near
                xor     ax, ax
                push    ax
                popf
                pushf
                pop     ax
                and     ax, 0f000h
                cmp     ax, 0f000h
                jz      verify_c800     ;not 386
                mov     ax, 0f000h
                push    ax
                popf
                pushf
                pop     ax
                and     ax, 0f000h
                jz      verify_c800     ;not 386        
                mov     dx, offset noprot_msg
.386P
                smsw    ax              ;get pm flag into carry 
                rcr     ax, 1
                jmp     short verify_c999
verify_c800:
                mov     dx, offset not386_msg
                stc
verify_c999:
                ret
verify_cpu      endp


init_gdt        proc    near
                mov     ax, gdt_seg
                mov     ds, ax
                assume  ds:gdt_seg

                mov     dx, tss_seg
                movzx   edx, dx                 ;base data segment
                mov     ecx, (TSS_END - TSS_BEG  ) - 1  ;limit
                mov     ah, TSS_DESC
                mov     si, offset sel_tss   
                call    make_entry

                mov     dx, tss_seg
                movzx   edx, dx                 ;base data segment
                mov     ecx, (TSS_END - TSS_BEG  ) - 1  ;limit
                mov     ah, RW_DATA             ;alias as r/w for editing
                mov     si, offset sel_tss_alias
                call    make_entry

                mov     dx, gdt_seg
                movzx   edx, dx                 ;base data segment
                mov     ecx, (GDT_END - GDT_BEG  ) - 1  ;limit
                mov     ah, RW_DATA             ;alias as r/w for editing
                mov     si, offset sel_gdt_alias
                call    make_entry

                mov     dx, isrcode
                movzx   edx, dx                 ;base of isr code segment
                mov     ecx, 0ffffh             ;max segment size
                mov     ah, ER_CODE
                mov     si, offset sel_isrcode 
                call    make_entry

                mov     dx, zcode
                movzx   edx, dx                 ;base code segment
                mov     ecx, 0ffffh             ;max segment size
                mov     ah, ER_CODE
                mov     si, offset sel_code 
                call    make_entry

                xor     edx, edx                ;zero base
                mov     ecx, 8fffffh            ;page granularity and 4 gig limit
                mov     ah, RW_DATA
                mov     si, offset sel_databs    
                call    make_entry

                mov     dx, dbstack             ;PL0 stack
                movzx   edx, dx                 ;base stack segment
                mov     ecx, (STACK_END - STACK_BEG  ) - 1  ;limit
                mov     ah, RW_DATA
                mov     si, offset sel_stack 
                call    make_entry

                mov     dx, dbstack3            ;PL3 stack
                movzx   edx, dx                 ;base stack segment
                mov     ecx, (STACK3_END - STACK3_BEG  ) - 1  ;limit
                mov     ah, RW_DATA
                mov     si, offset sel_stack3
                call    make_entry

                mov     dx, data
                movzx   edx, dx                 ;base data segment
                mov     cx, DATA_END
                sub     cx, DATA_BEG
                dec     cx
                movzx   ecx, cx

                mov     ah, RW_DATA
                mov     si, offset sel_data  
                call    make_entry

                int     11h                     ;equipment check
                mov     edx, 0b800h             ;color segment
                and     al, 30h                 ;monitor bits
                cmp     al, 30h                 ;30h=monochrome
                jne     init_gdt500
                mov     edx, 0b000h             ;monochrome segment

init_gdt500:
                mov     es:video_seg, dx        ;save video segment

                mov     ecx, (PAGE_SIZE * 4)  - 1    
                mov     ah, RW_DATA             
                mov     si, offset sel_video     
                call    make_entry

                ret
init_gdt        endp

;--------------------------------------------------------------
;make_entry - Load a GDT entry from information passed as     |
;             follows:                                        |
;                                                             |
;             ds=gdt segent                                   |
;             si=offset of gdt entry to load                  |
;             ah=type | dpl                                   |
;            ecx=limit (also, bits 23:20 are g, b, 0, and avl)|
;            edx=base segment (convert it to linear)          |
;--------------------------------------------------------------
make_entry      proc    near
                shl     edx, 4                  ;convert seg to linear
                mov     [si].seg_limit_low, cx 
                mov     [si].seg_base_low, dx  
                shr     edx, 16
                mov     [si].seg_base_mid, dl   
                mov     [si].seg_type_dpl, ah  
                shr     ecx, 16                 
                mov     [si].seg_limit_gran, cl 
                mov     [si].seg_base_top, dh  

                ret
make_entry      endp

;--------------------------------------------------------------
;init_tss - Initilize TSS with base of I/O bit map and set    |
;           appropriate bits in I/O bit map per cmd line.     |
;                                                             |
;--------------------------------------------------------------
init_tss        proc    near
                mov     ax, tss_seg
                mov     ds, ax
                assume  ds:tss_seg
                xor     si, si
                mov     ax, offset gdt_seg:sel_stack
                mov     [si].t_ess0, ax
                mov     ax, offset dbstack:db_sp   
                movzx   eax, ax
                mov     [si].t_esp0, eax
                lea     bx, [si].t_iomap 
                mov     [si].t_iobase, bx
                ret
init_tss        endp      
  
zcode            ends
                end  start

