;---------------------------------------------------------------    
;dbequ.inc - equates for debugger                              |
;--------------------------------------------------------------|
;  
TRUE		EQU	1 
FALSE		EQU	0
TAB             EQU     9
LF              EQU     0ah
CR              EQU     0dh
NULL            EQU     0
DOS_PRT_STRING  EQU     9  
DOS_TSR_FUNC    EQU     31h
BEEP            EQU     7

KBD_FLAG        EQU     17h
DEF_UD_INT      EQU     1               ;default int to enter user debugger        
DEFAULT_ATTRIB  EQU     17h             ;default video attribute 

MAX_DR_BRK_POINTS  EQU     3            ;user can have this many debug
                                        ;register type break points
MAX_BRK_POINTS  EQU     16              ;user can have this many break points
AVAIL           EQU     7fh             ;a break point is available for use
ACTIVE          EQU     1

ESC_KEY         EQU     1bh
LEFT_ARROW      EQU     4b00h
RUB_OUT         EQU     0e08h
RIGHT_ARROW     EQU     4d00h
INSERT          EQU     5200h
DELETE          EQU     5300h
SPACE_KEY       EQU     3920h

KEY_BUF_MAX     EQU     32
KEY_DAT         EQU     60h
KEY_CNTRL       EQU     61h
ADDR_6845       EQU     63h
CRT_START       EQU     4eh
DEF_DB_PAGE     EQU     2               ;video page debugger uses
PAGE_SIZE       EQU     1000h      
CURSOR_POS      EQU     50h
ACTIVE_PAGE     EQU     62h
DEBUG_ROW       EQU     22
DEBUG_COL       EQU     1               ;column where prompt prints        
CMD_MAX_LEN     EQU     78  
STR_TERM        EQU     0
LR_SHIFT        EQU     3
BYTES_TO_DUMP   EQU     128             ;dump this many bytes on each dump

DEB_DAT_LEN1    EQU     0               ;values placed in debug registers
DEB_DAT_LEN2    EQU     1               ;indicating length of data
DEB_DAT_LEN4    EQU     3               ;being accessed

IO_TYPE_READ    EQU     2
DEB_TYPE_EXEC   EQU     0               ;exec type break point        
DEB_TYPE_WRITE  EQU     1               ;write break point        
DEB_TYPE_RW     EQU     3               ;read/write break point        
DEB_TYPE_INT    EQU     4               ;break on interrupt
DEB_TYPE_IO     EQU     5               ;break on I/O

EQ_CODE         EQU     10h             ;codes stored indicating conditions
NE_CODE         EQU     0
INT_AL_COMP     EQU     1               ;al used to condition int break point
INT_AH_COMP     EQU     2               ;ah used to condition int break point
INT_AX_COMP     EQU     3               ;ax used to condition int break point
NO_CONDITION    EQU     0               ;no additional conditions on break
DEB_TEMP_DISAB  EQU     80h             

PRESENT         EQU     80H
DPL0            EQU     0
DPL3            EQU     3
INT_GATE        EQU     0eh             ;80386 int gate
USER_INT        EQU     61h
RW_DATA         EQU     92h             ;read/write data
ER_CODE         EQU     9ah             ;execute/read code
TSS_DESC        EQU     89h             ;Task State Segment descriptor
IO_MAP_SIZE     EQU     8192
GEN_PROT_EXCEP  EQU     0dh             ;General Protection int number

INPUT           EQU     2               ;used in io_table to describe
OUTPUT          EQU     1               ;the various I/O instructions
ABYTE           EQU     4
AWORD           EQU     8
CONSTANT        EQU     10h
STRING          EQU     20h
SEG_OVER        EQU     40h

REP_PREFIX      EQU     0f3h            
INT_OPCODE      EQU     0cdh
INT3_OPCODE     EQU     0cch
;------end of dbequ.inc
