/* --------- emm.h ---------- */

#ifndef EMM_H
#define EMM_H

#define EMM      0x67		/* EMM interrupt vector */

/* ------- EMM Function Codes ----------- */
#define TESTEMM  	0x40
#define FRAME    	0x41
#define PAGECT   	0x42
#define ALLOCATE 	0x43
#define MAPEMM   	0x44
#define RELEASEEMM 	0x45
#define SAVE     	0x47
#define RESTOREEMM 	0x48

/* -------- EMM prototypes ---------- */
BOOL emm_present(void);
BOOL emm_working(void);
int emm_pageframe(void);
int emm_pages_available(void);
int emm_allocate(int);
int emm_map(int,int,int,int);
int emm_release(int);
int emm_version(void);
int emm_savecontext(int);
int emm_restorecontext(int);
int emmint(void);

#endif

