/**************************************************************************************************
*
*		Title:	TEST1.C
*		Copyright (c) January 1992, Ryu Consulting, 916/722-1939
*		Written by Rahner James
*
*		This file contains the code used to test the xpx_ stream functions.
*		It performs packet transactions with any other nodes on the network that are
*		running this same package.
*
**************************************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "network.h"


#define	PSIZE	500
char Buffer[600];

main( int argc, char *argv[] )
{
	int				rv, i, read_packets, write_packets, total_streams=0, broadcast_count=0;
	unsigned short	socket=0;
	NET_ADDRESS_T	n;
	XPX_STREAM_T	far *sp[10], far *sp_broadcast;
	unsigned char	destination[6], string[20];
	long			last_time;

/*
** Setup our program and initialize IPX
*/
	printf( "\nTest IPX Program, version 0.50" );
	if ( argc > 1 )
		socket = atoi( argv[1] );
	printf( "\nReturn from xpx_init(%d) = %d", rv=xpx_init(socket) );
	if ( rv == 0 )
	{
		printf( "\nNetwork address = %ld", _Our_Address.network );
		addrtoa( string, _Our_Address.node );
		printf( "\nNode address =    %s", string );
		printf( "\nSocket = %d", _Our_Address.socket );
	}
	else
		exit( 1 );
	for ( i=0 ; i<10 ; ++i )
		sp[i] = NULL;

/*
** Setup our broadcasting stream
*/
	n.network = _Our_Address.network;
	n.socket = _Our_Address.socket;
	farset( n.node, 0xff, 6 );
	printf( "\n\nReturn from xpx_open() = %d", rv=xpx_open( &n, XPX_RW, &sp_broadcast ) );
	if ( rv != 0 )
		exit( 1 );
	getchar();

	printf( "\nTest Program" );
	last_time = clock();
	while ( !kbhit() )
	{
/*
** See if we need to broadcast
*/
		if ( clock() > last_time )
		{
			printf( "Sending broadcast %5d", ++broadcast_count );
			printf( " (%d)", xpx_write( sp_broadcast, &_Our_Address, sizeof(_Our_Address), NULL ) );
			last_time = clock() + CLOCKS_PER_SEC*4L;
		}

/*
** Now see if we have been broadcast to
*/
		if ( xpx_read_status(sp_broadcast) > 0 )
		{
			rv = xpx_read( sp_broadcast, Buffer, PSIZE );
			if ( rv == sizeof(_Our_Address) )
			{
				if ( xpx_open((NET_ADDRESS_T *)Buffer,XPX_RW,&sp[total_streams]) == 0 )
					++total_streams;
			}
		}

/*
** Now, see how our specific streams are doing
*/
		for ( i=0 ; i<total_streams ; ++i )
		{
			if ( xpx_write_status(sp[i]) == sp[i]->total_talkers )
				xpx_write( sp[i], Buffer, PSIZE, NULL );
			if ( xpx_read_status(sp[i]) )
				xpx_read( sp[i], Buffer, PSIZE );
			addrtoa( string, sp[i]->dest.node );
			printf( "%d %lX:%s:%d:  reads=%ld  writes=%ld  free=%2d  unread=%2d %2d",
				i, sp[i]->dest.network, string, sp[i]->dest.socket, sp[i]->total_receptions, sp[i]->total_transmissions,
				sp[i]->free_count, sp[i]->maximum_unread, sp[i]->error_count );
		}
	}

	for ( i=0 ; i<total_streams ; ++i )
		printf( "\nReturn from xpx_close() = %d", rv=xpx_close( sp[i] ) );
}
