Global Const TRUE = -1
Global Const FALSE = 0


Type CheckRec
    NumField As String
    DateField As String
    PayToField As String
    DollarField As String
    CentField As String
    AmountStr As String
    RemarksField As String
    SignatureField As Integer
End Type


Global balance As Currency
Global check As CheckRec

'====================================================================='
'=    PENAPI.TXT  -   Windows for Pens - Visual Basic Declarations   ='
'=                                                                   ='
'=                    Version 1.0                                    ='
'=                                                                   ='
'=                    Copyright (c)  1992, Microsoft Corp.           ='
'=                    All rights reserved.                           ='
'=                                                                   ='
'====================================================================='

'====================================================================='
'=   Register Pen Applications                                       ='
'====================================================================='

Declare Function RegisterPenApps Lib "penwin" (ByVal wFlags As Integer, ByVal fRegister As Integer) As Integer
Declare Function IsPenAware Lib "penwin" () As Integer
Declare Function GetVersionPenWin Lib "penwin" () As Integer

'====================================================================='
'=   ALC CODES                                                       ='
'====================================================================='
        ' These constants are used when defining the CHarSet param
        ' of HEdits and BEdits

Global Const ALC_ALL = &H43FF
Global Const ALC_DEFAULT = &H0
Global Const ALC_LCALPHA = &H1
Global Const ALC_UCALPHA = &H2
Global Const ALC_ALPHA = &H3
Global Const ALC_NUMERIC = &H4
Global Const ALC_ALPHANUMERIC = &H7
Global Const ALC_PUNC = &H8
Global Const ALC_MATH = &H10
Global Const ALC_MONETARY = &H20
Global Const ALC_OTHER = &H40
Global Const ALC_WHITE = &H100
Global Const ALC_NONPRINT = &H200
Global Const ALC_GESTURE = &H4000
Global Const ALC_USEBITMAP = &H8000
Global Const ALC_DBCS = &H400
Global Const ALC_HIRAGANA = &H100000
Global Const ALC_KATAKANA = &H200000
Global Const ALC_KANJI = &H40000
Global Const ALC_OEM = &HFF80000
Global Const ALC_RESERVED = &H43FF
Global Const ALC_NONPRIORITY = &H0
Global Const ALC_sysminimum = (ALC_ALPHANUMERIC Or ALC_WHITE Or ALC_GESTURE)



'====================================================================='
'=   Point Structure                                                 ='
'====================================================================='
Type PointShort
    x As Integer
    y As Integer
End Type                               ' 4 bytes

'====================================================================='
'=   Rectangle Structure                                       ='
'====================================================================='
Type RECTSHORT
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type                               ' 8 bytes


'====================================================================='
'=   Synthetic Keyboard Constants and Calls                          ='
'====================================================================='
Type SKBINFO
    hWnd As Integer                     'Handle to onscreen keyboard window
    nPad As Integer                     'Current view of keyboard (full, basic or numeric)
    fVisible As Integer                 'If TRUE, the on-screen keyboard is available and visible
    fMinimized As Integer               'If TRUE, the on-screen keyboard is minimized
    rect As RECTSHORT                   'The screen co-ordinates of the restored keyboard rectangle
    dwReserved As Long
End Type


Declare Function ShowKeyboard Lib "penwin" (ByVal hWnd As Integer, ByVal wCmd As Integer, lppoint As Any, lpSKBInfo As Any) As Integer

        ' ** ShowKeyboard() returns a TRUE if the requested wCmd was successful.
        '
        '    hWnd    = Handle to window (form) invoking the on-screen keyboard
        '    wCmds   = Command(s) requested. Commands can be OR'ed together
        '              (SKB_??? OR SKB_??? OR ... )
        '    lpPoint = Pointer to initial keyboard position in screen coordinates or NULL
        '    lpSKBInfo = Pointer to a SKBINFO structure to be filled by the keyboard or NULL.

Global Const SKB_QUERY = &H0
Global Const SKB_SHOW = &H1
Global Const SKB_HIDE = &H2
Global Const SKB_CENTER = &H10
Global Const SKB_MOVE = &H20
Global Const SKB_MINIMIZE = &H40
Global Const SKB_FULL = &H100
Global Const SKB_BASIC = &H200
Global Const SKB_NUMPAD = &H400


'====================================================================='
'=   Maniplating Pen Data                                            ='
'====================================================================='
Type PENDATAHEADER
    wVersion As Integer             'Pen Data format Version
    cbSizeUsed As Integer           'Size of Pen data memory block
    cStrokes As Integer             'Number of strokes (each pen up and pen down run in a single stroke)
    cPnt As Integer                 'Total number of points
    cPntStrokeMax As Integer        'length of longest stroke in points
    rectBound As RECTSHORT          'Coordinates of bounding rectangle
    wPndts As Integer               'State of various PDTS_??? bits
    nInkWidth As Integer            'Ink Width
    rgbInk As Long                  'Ink color
End Type

Global Const PDTS_LOMETRIC = &H0        'Each logical unit is mapped to 0.01mm. Positive X to right; Positive Y down.
Global Const PDTS_HIMETRIC = &H1        'Logical mapped to 0.001mm. X+ to right; Y+ down
Global Const PDTS_HIENGLISH = &H2       'Logical mapped to 0.001 inch. X+ to right; y+ is down
Global Const PDTS_SCALEMAX = &H3        'Maximum scaling allowed
Global Const PDTS_DISPLAY = &H4         'Logical mapped to display pixel.  X+ to right; Y+ is down
Global Const PDTS_ARBITRARY = &H5       'Arbitrary scale, application dependent
Global Const PDTS_SCALEMASK = &HF       'Mask for bits of scale
Global Const PDTS_STANDARDSCALE = PDTS_HIENGLISH

Global Const PDTS_NOPENINFO = &H100         'No PENINFO structure
Global Const PDTS_NOUPPOINTS = &H200        'The data points on pen up have been removed
Global Const PDTS_NOOEMDATA = &H400         'No OEM data present
Global Const PDTS_NOCOLINEAR = &H800
Global Const PDTS_COMPRESSED = &H8000       'The data is compressed
Global Const PDTS_COMPRESSMETHOD = &HF0     'Bits have been saved to encode which compression scheme was used
Global Const PDTS_COMPRESS2NDDERIV = &H10   'The second derivative betwen points is stored

Global Const PDTT_DEFAULT = &H0                 'reallocates memory block to fit data.  Should be run before GlobalSize(hpendata) is taken
Global Const PDTT_PENINFO = PDTS_NOPENINFO      'removes PenInfo from the header
Global Const PDTT_UPPOINTS = PDTS_NOUPPOINTS    'Throws away all data from points collected when pen is not in contact with the tablet.
Global Const PDTT_OEMDATA = PDTS_NOOEMDATA      'Removes All OEM Data that is not x,y (such as presure and angle)
Global Const PDTT_COLINEAR = PDTS_NOCOLINEAR    'Removes successive idetical points and colinear points from pendata
Global Const PDTT_COMPRESS = PDTS_COMPRESSED    'Compresses data without loss of any information.
                                                '  NOTE: After compression, on CompactPenData, GetPenInfo and DuplicatePenData can be used
                                                '        on the hPenData
Global Const PDTT_DECOMPRESS = &H4000           'Decompresses Data.  Cannot be used in conjunction with other timing options.
Global Const PDTT_ALL = (PDTT_PENINFO Or PDTT_UPPOINTS Or PDTT_OEMDATA Or PDTT_COLINEAR)



Type STROKEINFO
    cPnts As Integer        'Count of points in stroke
    cbPnts As Integer       'count of bytes used for stroke
    wPdk As Integer         'state of stroke
    dwTick As Long          'Time of stroke
End Type



Type OEMPENINFO
    wPdts As Integer
    wValMax As Integer
    wDistinct As Integer
End Type



Type PENINFO
    cxRawWidth As Integer           ' Max x & width of tablet in 0.01 of inch
    cyRawHeight As Integer          ' Max y & height of tablet " " " "
    wDistinctWidth As Integer       ' Num of distinct X values returned by tablet
    wDistinctHieght As Integer      ' Num of distinct Y values returned by tablet
    nSamplingRate As Integer        ' Samples/second
    nSamplingDist As Integer        ' Minimum distance moved in either direction
    lPdc As Long                    ' Pen Device capabilities
    cbOemData As Integer            ' Width of OEM Packet
    rgoempeninfo0 As OEMPENINFO
    rgoempeninfo1 As OEMPENINFO
    rgoempeninfo2 As OEMPENINFO
    rgoempeninfo3 As OEMPENINFO
    rgoempeninfo4 As OEMPENINFO
    rgoempeninfo5 As OEMPENINFO
    rgwReserved0 As Integer
    rgwReserved1 As Integer
    rgwReserved2 As Integer
    rgwReserved3 As Integer
    rgwReserved4 As Integer
    rgwReserved5 As Integer
    rgwReserved6 As Integer
    rgwReserved7 As Integer
End Type

Global Const PDT_NULL = 0
Global Const PDT_PRESSURE = 1
Global Const PDT_HEIGHT = 2
Global Const PDT_ANGLEXY = 3
Global Const PDT_ANGLEZ = 4
Global Const PDT_BARRELROTATION = 5
Global Const PDT_OEMSPECIFIC = 16

Global Const MAXOEMDATAWORDS = 6

Global Const PDC_INTEGRATED = &H1
Global Const PDC_PROXIMITY = &H2
Global Const PDC_RANGE = &H4
Global Const PDC_INVERT = &H8
Global Const PDC_RELATIVE = &H10
Global Const PDC_BARREL1 = &H20
Global Const PDC_BARREL2 = &H40
Global Const PDC_BARREL3 = &H80










Declare Function DuplicatePenData Lib "penwin" (ByVal hPenData As Integer, ByVal gMemFlags As Integer) As Integer
                ' DuplicatePenData takes a handle to ink (hpenData or hInk) and returns
                ' a new hInk/hPenData that has a copy of the ink.
                ' NOTE: Whenever this function is used, a GlobalFree() call must be issued
                '       to release the memory.

Declare Function CompactPenData Lib "penwin" (ByVal hPenData As Integer, ByVal wTrimOptions As Integer) As Integer
                ' CompactPenData trims pen data in hPenData based on wTrimOptions (PDTT_???)

Declare Function BeginEnumStrokes Lib "penwin" (ByVal hPenData As Integer) As Long
                'Locks the hPenData and returns a long pointer to the data


Declare Function GetPenDataInfo Lib "penwin" (ByVal hPenData As Integer, lppendataheader As PENDATAHEADER, lppeninfo As Any, ByVal dwReserve As Long) As Integer
Declare Function GetPenDataStroke Lib "penwin" (ByVal lppendata As Long, ByVal wStroke As Integer, lplpPoint As Any, lplpvOem As Any, lpsi As STROKEINFO) As Integer
Declare Function GetPointsFromPenData Lib "penwin" (ByVal hPenData As Integer, ByVal wStroke As Integer, ByVal wPnts As Integer, ByVal cPnts As Integer, lppoint As Any) As Integer
Declare Function AddPointsPenData Lib "penwin" (ByVal hPenData As Integer, lpPnt As Any, lpvOemData As Any, lpsiNew As Any) As Integer



'====================================================================='
'=   RcResult Structures                                             ='
'====================================================================='

'=== Array of Point Structures ======================================='
Type PointArray
    rgpntHotSpots0 As PointShort
    rgpntHotSpots1 As PointShort
    rgpntHotSpots2 As PointShort
    rgpntHotSpots3 As PointShort
    rgpntHotSpots4 As PointShort
    rgpntHotSpots5 As PointShort
    rgpntHotSpots6 As PointShort
    rgpntHotSpots7 As PointShort
End Type                               ' 28 bytes

'=== Symbol Character array =========================================='

Type SYC
    wStrokeFirst As Integer
    wPntFirst As Integer
    wStrokeLast As Integer
    wPntLast As Integer
    fLastSyc As Integer
End Type


'=== Symbol Graph element ============================================'

Type syg
    rgpntHotSpotsArray As PointArray   ' 28 bytes
    cHotSpot As Integer                '  2
    nFirstBox As Integer               '  2
    lRecogVal As Long                  '  4
    lpSye As Long                      '  4
    cSye As Integer                    '  2
    lpSyc As Long                      '  4
    csyc As Integer                    '  2
End Type                               ' 48 bytes total

'=== Symbol Element =================================================='
Type SYE
    Syv As Long                         '  4 bytes
    lRecogVal As Long                   '  4
    cl As Integer                       '  2
    iSyc As Integer                     '  2
End Type                                ' 12 bytes total

    
' to convert syv to ANSI character   ->   Chr$(syv and &HFF)
    ' to convert ANSI character to syv   ->   ((chr% and &HFF) or &H10000)

    '=== SYV values with special meanings to Windows For Pens
Global Const SYV_NULL = &H0
Global Const SYV_UNKNOWN = &H1
Global Const SYV_EMPTY = &H3
Global Const SYV_BEGINOR = &H10
Global Const SYV_ENDOR = &H11
Global Const SYV_OR = &H12
Global Const SYV_SOFTNEWLINE = &H20
Global Const SYV_SPACENULL = (&H10000)

    '=== SYV values for gestures
Global Const SYV_CLEAR = &H2FFD5
Global Const SYV_EXTENDSELECT = &H2FFD8
Global Const SYV_UNDO = &H2FFD9
Global Const SYV_COPY = &H2FFDA
Global Const SYV_CUT = &H2FFDB
Global Const SYV_PASTE = &H2FFDC
Global Const SYV_CLEARWORD = &H2FFDD
Global Const SYV_USER = &H2FFDE
Global Const SYV_CORRECT = &H2FFDF

Global Const SYV_BACKSPACE = &H20008
Global Const SYV_TAB = &H20009
Global Const SYV_RETURN = &H2000D
Global Const SYV_SPACE = &H20020

    '=== Application Specific gestures circle a-z and circle A-Z
Global Const SYV_APPGESTUREMASK = &H20000
Global Const SYV_CIRCLEUPA = &H224B6
Global Const SYV_CIRCLEUPZ = &H224CF
Global Const SYV_CIRCLELOA = &H224D0
Global Const SYV_CIRCLELOZ = &H224E9

    '=== SYV for Shapes (if recognizer installed)
Global Const SYV_SHAPELINE = &H40001
Global Const SYV_SHAPEELLIPSE = &H40002
Global Const SYV_SHAPERECT = &H40003
Global Const SYV_SHAPEMIN = SYV_SHAPELINE
Global Const SYV_SHAPEMAX = SYV_SHAPERECT

    '=== To detect if SYV is a particular type, let SyvHi=(syv\&H10000)
    '=== Compare SyvHi with below

Global Const SYVHI_SPECIAL = 0
Global Const SYVHI_ANSI = 1
Global Const SYVHI_GESTURE = 2
Global Const SYVHI_KANJI = 3
Global Const SYVHI_SHAPE = 4
Global Const SYVHI_UNICODE = 5
Global Const SYVHI_VKEY = 6



'====================================================================='
'=   RcResult Structures                                             ='
'====================================================================='


Type RcResult
    SYGraph As syg                     ' 48 bytes
    wREsultsType As Integer            '  2
    cSyv As Integer                    '  2
    lpsyv As Long                      '  4
    hSyv As Integer                    '  2
    nBaseLine As Integer               '  2
    nMidLine As Integer                '  2
    hPenData As Integer                '  2
    rectboundink As RECTSHORT          '  8
    pntEnd As PointShort               '  4
    lprc As Long                       '  4
End Type                               ' 80 bytes


Global Const RCRT_DEFAULT = &H0
Global Const RCRT_UNIDENTIFIED = &H1
Global Const RCRT_GESTURE = &H2
Global Const RCRT_NOSYMBOLMATCH = &H3
Global Const RCRT_PRIVATE = &H4000
Global Const RCRT_NORECOG = &H8000
Global Const RCRT_ALREADYPROCESSED = &H8
Global Const RCRT_GESTURETRANSLATED = &H10
Global Const RCRT_GESTURETOKEYS = &H20



Declare Function GetSymbolMaxLength Lib "penwin" (lpsyg As Any) As Integer
Declare Function GetSymbolCount Lib "penwin" (lpsyg As Any) As Integer
Declare Function SymbolToCharacter Lib "penwin" (lpsyv As Any, ByVal cSyv As Any, ByVal lpstr As String, lpnCnvt As Any)

'========================================================================'
'=== RC Definition                                                    ==='
'========================================================================'

Global Const CL_NULL = 0
Global Const CL_MINIMUM = 1
Global Const CL_MAXIMUM = 100
Global Const INKWIDTH_MINIMUM = 0
Global Const INKWIDTH_MAXIMUM = 15
Global Const ENUM_MINIMUM = 1
Global Const ENUM_MAXIMUM = 4096
Global Const MAXDICTIONARIES = 16

Type GUIDE
    xOrigin As Integer
    yOrigin As Integer
    cxBox As Integer
    cyBox As Integer
    cxBase  As Integer
    cyBase As Integer
    cHorzBox  As Integer
    cVertBox  As Integer
    cyMid As Integer
End Type

Global Const cbRcLanguageMax = 44
Global Const cbRcUserMax = 32
Global Const cbRcrgbfAlcMax = 32
Global Const cwRcReservedMax = 8

Type RCstruct
    hRec As Integer
    hWnd As Integer
    wEventRef As Integer
    wRcPreferences As Integer
    lRcOptions As Long
    lpFnYield As Long
    lpUser0_3 As Long
    lpUser4_7 As Long
    lpUser8_11 As Long
    lpUser12_15 As Long
    lpUser16_19 As Long
    lpUser20_23 As Long
    lpUser24_27 As Long
    lpUser28_31 As Long
    wCountry As Integer
    wIntlPreferences As Integer
    lpLanguage0_3 As Long
    lpLanguage4_7 As Long
    lpLanguage8_11 As Long
    lpLanguage12_15 As Long
    lpLanguage16_19 As Long
    lpLanguage20_23 As Long
    lpLanguage24_27 As Long
    lpLanguage28_31 As Long
    lpLanguage32_35 As Long
    lpLanguage36_39 As Long
    lpLanguage40_43 As Long
    rglpdf0 As Long
    rglpdf1 As Long
    rglpdf2 As Long
    rglpdf3 As Long
    rglpdf4 As Long
    rglpdf5 As Long
    rglpdf6 As Long
    rglpdf7 As Long
    rglpdf8 As Long
    rglpdf9 As Long
    rglpdf10 As Long
    rglpdf11 As Long
    rglpdf12 As Long
    rglpdf13 As Long
    rglpdf14 As Long
    rglpdf15 As Long
    rglpdf16 As Long
    wTryDictinary As Integer
    clErrorLevel As Integer
    alc As Long
    alcPriority As Long
    rgbfAlc0_3 As Long
    rgbfAlc4_7 As Long
    rgbfAlc8_11 As Long
    rgbfAlc12_15 As Long
    rgbfAlc16_19 As Long
    rgbfAlc20_23 As Long
    rgbfAlc24_27 As Long
    rgbfAlc28_31 As Long
    wResultMode As Integer
    wTimeOut As Integer
    lPcm As Long
    rectBound As RECTSHORT
    rectExclude As RECTSHORT
    guid As GUIDE
    wRcOrient As Integer
    wRcDirect As Integer
    nInkWidth As Integer
    rgbInk As Long
    dwAppParam As Long
    dwDictParam As Long
    dwRecognizer As Long
    rgwReserved0 As Integer
    rgwReserved1 As Integer
    rgwReserved2 As Integer
    rgwReserved3 As Integer
    rgwReserved4 As Integer
    rgwReserved5 As Integer
    rgwReserved6 As Integer
    rgwReserved7 As Integer
End Type


Declare Function GetGlobalRC Lib "penwin" (lprc As Any, ByVal lpDefRecog As String, ByVal lpDefRecog As String, ByVal cbDefDictMax As Integer) As Integer

Global Const GGRC_OK = 0
Global Const GGRC_DICTBUFTOOSMALL = 1
Global Const GGRC_PARAMERROR = 2


Declare Function SetGlobalRC Lib "penwin" (lprc As Any, ByVal lpDefRecog As String, ByVal lpDefDict As String) As Integer

Global Const SGRC_OK = &H0
Global Const SGRC_USER = &H1
Global Const SGRC_PARAMERROR = &H2
Global Const SGRC_RC = &H4
Global Const SGRC_RECOGNIZER = &H8
Global Const SGRC_DICTIONARY = &H10
Global Const SGRC_INIFILE = &H20


Declare Function InitRc Lib "penwin" (ByVal hWnd As Integer, lpSrc As RCstruct) As Integer


Declare Function InstallRecognizer Lib "penwin" (ByVal lpszRecogName As String) As Integer
Declare Function UnInstallRecognizer Lib "penwin" (ByVal hRec As Integer) As Integer

'========================================================================'
'=== Training And Correcting                                          ==='
'========================================================================'

Declare Function TrainInk Lib "penwin" (lprc As RCstruct, ByVal hPenData As Integer, lpsyv As Any) As Integer
Declare Function TrainContext Lib "penwin" (lprcResult As RCstruct, lpSye As Any, ByVal cSye As Integer, lpSyc As Any, ByVal csyc As Integer) As Integer

Declare Function CorrectWriting Lib "penwin" (ByVal hWnd As Integer, ByVal lpstr As String, ByVal cBuf As Integer, lprc As RCstruct, ByVal dwCwrFlags As Any, ByVal dwReserved As Any) As Integer

Global Const CWR_STRIPCR = &H1
Global Const CWR_STRIPLF = &H2
Global Const CWR_STRIPTAB = &H4
Global Const CWR_SINGLELINEEDIT = &H7
Global Const CWR_TITLE = &H10



'========================================================================'
'=== Other Windows For Pens API's                                     ==='
'========================================================================'

Declare Function BoundingRectFromPoints Lib "penwin" (lpPnt As Any, ByVal cPnt, lprectBound As RECTSHORT) As Integer
        'Returns the bounding rectangle given a series of points pointed to by lpPnt
        'and the number of points is cPnts

Declare Function TPtoDP Lib "penwin" (lpPnts As Any, ByVal cPnts As Integer) As Integer
        'Convert an array of points from tablet coordinates to screen coordinates

Declare Function DPtoTP Lib "penwin" (lpPnts As Any, ByVal cPnts As Integer) As Integer
        ' Converts an array of points from screen to tablet coordinates


Declare Function DrawPenData Lib "penwin" (ByVal hDC As Integer, lpRect As RECTSHORT, ByVal hPenData As Integer) As Integer
Declare Function MetricScalePenData Lib "penwin" (ByVal hPenData As Integer, ByVal wPdts) As Integer
Declare Function OffsetPenData Lib "penwin" (ByVal hPenData As Integer, ByVal dx As Integer, ByVal dy As Integer) As Integer
Declare Function RecognizePenData Lib "penwin" (lprc As RCstruct, ByVal hPenData As Integer) As Integer
Declare Function CreatePenData Lib "penwin" (lppenifo As PENINFO, ByVal cbOemData As Integer, ByVal wPdtScal As Integer, ByVal gMemFlags As Integer) As Integer

Declare Function ExecuteGesture Lib "penwin" (ByVal hWnd As Integer, ByVal Syv As Long, lprcResult As RCstruct)


'=== Message Routines Constants =========================================='

Global Const WM_PENWINFIRST = &H380                     'Main Offset for PEN msgs
Global Const WM_RCRESULT = (WM_PENWINFIRST + 1)
Global Const WM_HOOKRCRESULT = (WM_PENWINFIRST + 2)
Global Const WM_GLOBALRCCHANGE = (WM_PENWINFIRST + 3)
Global Const WM_SKB = (WM_PENWINFIRST + 4)
Global Const WM_HEDITCTL = (WM_PENWINFIRST + 5)         'Configures HEdits and BEdits

        '** The constants below are used as wParam with WM_HEDITCTL msg
Global Const HE_GETRC = 3
Global Const HE_SETRC = 4
Global Const HE_GETINFLATE = 5
Global Const HE_SETINFLATE = 6
Global Const HE_GETUNDERLINE = 7
Global Const HE_SETUNDERLINE = 8
Global Const HE_GETINKHANDLE = 9
Global Const HE_SETINKMODE = 10         'Set lParam to hPenData/hInk. Ink must be relative to top-left of client rectangle.
Global Const HE_STOPINKMODE = 11
Global Const HE_GETRCRESULTCODE = 12
Global Const HE_DEFAULTFONT = 13
Global Const HE_CHARPOSITION = 14
Global Const HE_CHAROFFSET = 15
Global Const HE_GETRCRESULT = 22



'


'====================================================================='
'==================== END WINDOWS FOR PEN API ========================'
'====================================================================='




'========================================================================'
'============ PENCNTRL.VBX's API   ======================================'
'========================================================================'

Declare Sub VBTypeToCPointer Lib "pencntrl.vbx" (lpSrc As Any, ByVal lpDest As Long, ByVal cb As Integer)
        ' VBTypeToCPointer copies data from a VB string into a memory pointed to be a long

Declare Sub CPointerToVBType Lib "pencntrl.vbx" (ByVal lpSrc As Long, lpDest As Any, ByVal cb As Integer)
        ' CPointerToVBType copies data from memory pointed to by lpSrc into a VBString

'========================================================================'
'========================================================================'
'========================================================================'




'========================================================================'
'=== Useful Windows Calls And Constants
'========================================================================'

'=== Graphics Routines =================================================='

Declare Function ClientToScreen Lib "user" (ByVal hWnd As Integer, lpPnt As Any) As Integer
        '** Returns the screen coordinates of the hWnd window


'=== Memory Routines ===================================================='

Declare Function GlobalFree Lib "kernel" (ByVal hMem As Integer) As Long
        '** Frees up memory.  Used after a DuplicatePenData()

Declare Function GlobalSize Lib "kernel" (ByVal hMem As Integer) As Long
        '** Returns the size of memory associated with a handle

Declare Function GlobalLock Lib "kernel" (ByVal hMem As Integer) As Long
        '** Returns a pointer to memory allocated to hMem

Declare Function GlobalUnLock Lib "kernel" (ByVal hMem As Integer) As Integer
        '** Returns TRUE if successful

Declare Function GlobalAlloc Lib "kernel" (ByVal wFlags As Integer, ByVal dwBytes As Long) As Integer
        '** Allocate a certain amount of space

Global Const GMEM_FIXED = &H0
Global Const GMEM_MOVEABLE = &H2
Global Const GMEM_NOCOMPACT = &H10
Global Const GMEM_NODISCARD = &H20
Global Const GMEM_ZEROINIT = &H40
Global Const GMEM_MODIFY = &H80
Global Const GMEM_DISCARDABLE = &H100
Global Const GMEM_NOT_BANKED = &H1000
Global Const GMEM_SHARE = &H2000
Global Const GMEM_DDESHARE = &H2000
Global Const GMEM_NOTIFY = &H4000
Global Const GMEM_LOWER = GMEM_NOT_BANKED




'=== Message Routines ===================================================='

Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParm As Integer, ByVal lParam As Any) As Long
        '** General Message Sending function of Windows.  Below are some messages that can be sent to HEdits or BEdits
        

'========================================================================'
'====================== END WINDOWS DECLARATIONS ========================'
'========================================================================'

'========================================================================'
'========================================================================'
'====================== END WINDOWS PENWIN.TXT   ========================'
'========================================================================'
'========================================================================'




'---------------------------------------------------------------------
'-- Global Variables used in Synthetic Keyboard Sample Code
'---------------------------------------------------------------------

Global CurrentFocus  As Integer

'---------------------------------------------------------------------
'-- Global Variables used in Ink Storage Example
'---------------------------------------------------------------------

Global Dup_hInk As Integer




