/* Rotates and moves polygon-based objects (only balls, at the moment). */
#include "polygon.h"

#define X_BALL_MOVE 1.0
#define Y_BALL_MOVE 1.0
#define Z_BALL_MOVE 4.0

void RotateAndMoveBall(PObject * ObjectToMove)
{
   /* Rotate the ball as needed */
   if (--ObjectToMove->RDelayCount == 0) {   /* rotate */
      ObjectToMove->RDelayCount = ObjectToMove->RDelayCountBase;
      if (ObjectToMove->Rotate.RotateX != 0.0)
         AppendRotationX(ObjectToMove->XformToWorld,
               ObjectToMove->Rotate.RotateX);
      if (ObjectToMove->Rotate.RotateY != 0.0)
         AppendRotationY(ObjectToMove->XformToWorld,
               ObjectToMove->Rotate.RotateY);
      if (ObjectToMove->Rotate.RotateZ != 0.0)
         AppendRotationZ(ObjectToMove->XformToWorld,
               ObjectToMove->Rotate.RotateZ);
      ObjectToMove->RecalcXform = 1;
   }

   /* Move the ball in response to recorded key events */
   if (BallEvent & MOVE_LEFT) {
      if (ObjectToMove->XformToWorld[0][3] > DOUBLE_TO_FIXED(-15000.0)) {
         ObjectToMove->XformToWorld[0][3] -= DOUBLE_TO_FIXED(X_BALL_MOVE);
         ObjectToMove->RecalcXform = 1;
      }
      BallEvent &= ~MOVE_LEFT;
   }
   if (BallEvent & MOVE_RIGHT) {
      if (ObjectToMove->XformToWorld[0][3] < DOUBLE_TO_FIXED(15000.0)) {
         ObjectToMove->XformToWorld[0][3] += DOUBLE_TO_FIXED(X_BALL_MOVE);
         ObjectToMove->RecalcXform = 1;
      }
      BallEvent &= ~MOVE_RIGHT;
   }
   if (BallEvent & MOVE_UP) {
      if (ObjectToMove->XformToWorld[1][3] < DOUBLE_TO_FIXED(15000.0)) {
         ObjectToMove->XformToWorld[1][3] += DOUBLE_TO_FIXED(Y_BALL_MOVE);
         ObjectToMove->RecalcXform = 1;
      }
      BallEvent &= ~MOVE_UP;
   }
   if (BallEvent & MOVE_DOWN) {
      if (ObjectToMove->XformToWorld[1][3] > DOUBLE_TO_FIXED(-15000.0)) {
         ObjectToMove->XformToWorld[1][3] -= DOUBLE_TO_FIXED(Y_BALL_MOVE);
         ObjectToMove->RecalcXform = 1;
      }
      BallEvent &= ~MOVE_DOWN;
   }
   if (BallEvent & MOVE_TOWARD) {
      if (ObjectToMove->XformToWorld[2][3] < DOUBLE_TO_FIXED(-100.0)) {
         ObjectToMove->XformToWorld[2][3] += DOUBLE_TO_FIXED(Z_BALL_MOVE);
         ObjectToMove->RecalcXform = 1;
      }
      BallEvent &= ~MOVE_TOWARD;
   }
   if (BallEvent & MOVE_AWAY) {
      if (ObjectToMove->XformToWorld[2][3] > DOUBLE_TO_FIXED(-15000.0)) {
         ObjectToMove->XformToWorld[2][3] -= DOUBLE_TO_FIXED(Z_BALL_MOVE);
         ObjectToMove->RecalcXform = 1;
      }
      BallEvent &= ~MOVE_AWAY;
   }
}

