#define WAVE_MGT
#include <alloc.h>
#include "wave_mgt.h"

double **BuildTreeStorage(int inlength, int levels)
{
	double **tree;
	int i, j;

	/* create decomposition tree */
	tree = (double **) calloc(2 * levels, sizeof(double *));
	j = inlength;
	for (i = 0; i < levels; i++)
	{
		j /= 2;
		if (j == 0)
		{
			levels = i;
/*			printf("\nToo many levels requested for available data\n");
			printf("Number of transform levels now set to %d\n", levels); */
			continue;
		}
		tree[2 * i] = (double *) calloc((j + 5), sizeof(double));
		tree[2 * i + 1] = (double *) calloc((j + 5), sizeof(double));
	}
	return tree;
}


void DestroyTreeStorage(double **tree, int levels)
{
	char i;

	for (i = (2 * levels - 1); i >= 0; i--)
		free(tree[i]);

	free(tree);
}


void TreeCopy(double **TreeDest, double **TreeSrc, int siglen, int levels)
{
	int i, j;

	for (i = 0; i < levels; i++)
	{
		siglen /= 2;
		for (j = 0; j < siglen + 5; j++)
		{
			if ((i + 1) == levels)
				TreeDest[2 * i][j] = TreeSrc[2 * i][j];
			else
				TreeDest[2 * i][j] = 0.0;

			TreeDest[(2 * i) + 1][j] = TreeSrc[(2 * i) + 1][j];
		}
	}
}


void TreeZero(double **Tree, int siglen, int levels)
{
	int i, j;

	for (i = 0; i < levels; i++)
	{
		siglen /= 2;
		for (j = 0; j < siglen + 5; j++)
		{
			Tree[2 * i][j] = 0.0;
			Tree[(2 * i) + 1][j] = 0.0;
		}
	}
}


void ZeroTreeDetail(double **Tree, int siglen, int levels)
{
	int i, j;

	for (i = 0; i < levels; i++)
	{
		siglen /= 2;
		for (j = 0; j < siglen + 5; j++)
			Tree[(2 * i) + 1][j] = 0.0;
	}
}
