;---------------------------------------------------------------    
;loginit - initialization code for device driver monitor       |
;--------------------------------------------------------------|
;Copyright 1990, 1992 ASMicro Co.                              |
;--------------------------------------------------------------|
;                                                              |
; 4/15/90                      Rick Knoblaugh                  |
;--------------------------------------------------------------|
;include files                                                 |
;---------------------------------------------------------------    
                include logequ.inc
                include logstruc.inc


code            segment public  'CODE'
                assume cs:code, ds:code, es:code
;--------------------------------------------------------------
;PUBLIC                                                       |
;--------------------------------------------------------------
                public  drv_init

;--------------------------------------------------------------
;EXTERNALS                                                    |
;--------------------------------------------------------------
                extrn   req_header:dword
                extrn   get_key:near
                extrn   monitor_process:near
                extrn   save_patch:word
                extrn   patch_flag:byte
                extrn   old_user_int:dword
                extrn   drv_state:word

;--------------------------------------------------------------
;drv_init - Perform driver initialization.  Parse command     |
;           line for switch.  Take over user interrupt        |
;           for gaining control from another device driver.   |
;--------------------------------------------------------------
drv_init        proc    near
                mov     dx, offset sign_on1 
                mov     ah, DOS_PRINT_STRING
                int     21h

                mov     patch_flag, FALSE       ;default to no patching

                push    ds              
                lds     si, req_header
                lds     si, [si].cmd0_bpb_ptr   ;ptr to cmd line
                call    val_switch              ;return carry if invalid
                pop     ds
                jnc     drv_i500
                xor     dx, dx                  ;error, keep no code    
                mov     ax, ERR_GENFAIL         ;return status
                jmp     short drv_i800



drv_i500:

                push    ds
                pop     es
                mov     bx, USER_INT            ;interrupt to take over
                mov     di, offset old_user_int ;place to store previous isr
                mov     dx, offset monitor_process ;new isr
                call    get_int                     
                mov     dx, offset drv_init     ;drop code after this
                mov     ax, OK_STATUS           ;return status
                mov     drv_state, EXPECT_STRAT

drv_i800:
                les     di, req_header
                mov     es:[di].cmd0_eadrs_off, dx
                mov     es:[di].cmd0_eadrs_seg, cs


                ret


sign_on1        db      'Device Driver Monitor   Version 1.0', CR, LF
                db      'Copyright ASMicro Co. 1990, 1992', CR, LF , CR, LF, '$'

bad_swtch_msg   db      'Invalid switch - driver not loaded', CR, LF, CR, LF 
                db      'Press any key to exit...', CR, LF, CR, LF, '$'
drv_init        endp        

;--------------------------------------------------------------
;get_int - For a given interrupt vector, store contents and   |
;          load with new isr address.                         |
;                                                             |
;          bx = int number                                    |
;          es:di = location to store contents                 |
;          dx = offset new isr                                |
;--------------------------------------------------------------
get_int         proc    near
                push    ds
                xor     ax, ax
                mov     ds, ax
                shl     bx, 1
                shl     bx, 1
                mov     ax, [bx]
                stosw                
                mov     ax, [bx].d_segment
                stosw          
                cli
                mov     [bx].d_offset, dx
                mov     [bx].d_segment, cs
                pop     ds
                sti
                ret
get_int         endp        

;--------------------------------------------------------------
;val_switch - Search command line.  Values expected are as    |
;             follows:                                        |
;                                                             |
;                     /Pxxxx                                  |
;                                                             |
;         where xxxx are 4 hex digits representing the bytes  |
;         of code that were overlaid when the user patched    |
;         in the int xx instruction which gives this program  |
;         control.                                            |
;                                                             |
;         If the switch is present and invalid, report it     |
;         to user and set carry flag.  If valid values are    |
;         found save them.                                    |
;                                                             |
;         Enter:  ds:si pointing after "device=".             |
;                                                             |
;--------------------------------------------------------------
val_switch      proc    near


                mov     cx, MAX_CMD_LINE
val_s100:
                lodsb                           
                cmp  al, LF
                je      val_s500                ;no cmd tail
                cmp  al, CR
                je      val_s400                ;parms, but not right
                cmp  al, SWITCH_CHAR
                loopne  val_s100                ;go get switch

val_s200:       
                lodsb                           
                and     al, 0dfh                ;force to upper case
                cmp     al, PATCH_SWITCH
                jne     val_s400                ;if not valid, report it

                call    skip_white_sp
                jcxz    val_s400                ;report bad switch               


                mov     di, si                  ;save start of patch codes
                mov     cx, NUM_PATCH_BYTES
val_s300:
                lodsb
                cmp     al, 'a'
                jb      val_s340
                and     al, 0dfh                ;force to upper case
                mov     [si - 1], al
val_s340:
                cmp     al, '0'                 ;within valid range for code?
                jb      val_s400                ;report bad value
                cmp     al, 'F'                 
                ja      val_s400                ;report bad value
                cmp     al, 'A'                 
                jae     val_s350                ;ok
                cmp     al, '9'
                ja      val_s400                ;report bad value
val_s350:
                loop    val_s300
                mov     si, di                  ;get back to start of digits
                push    cs
                pop     es                      ;get our ds in es

                mov     di, offset cs:save_patch

                mov     cx, NUM_PATCH_BYTES / 2 ;convert both sets of two digits

val_s380:
                lodsb                           ;get a digit of patch code
                call    asc2bin                 ;return binary value in al
                shl     al, 1                                              
                shl     al, 1                                              
                shl     al, 1                                              
                shl     al, 1                                              
                mov     dl, al                  
                lodsb                           ;get a digit of patch code
                call    asc2bin                 ;return binary value in al
                add     al, dl
                stosb                           ;save first byte of patch code
                loop    val_s380
                mov     cs:patch_flag, TRUE     ;indicate that user patched

                jmp     short val_s500

val_s400:
                push    cs
                pop     ds                     ;get our ds
                mov     dx, offset bad_swtch_msg
                mov     ah, DOS_PRINT_STRING
                int     21h
                call    get_key
                stc
                jmp     short val_s999

val_s500:                       
                
                clc                             ;no errors
val_s999:
                ret
val_switch      endp       
                

asc2bin         proc    near
                cmp     al, '9'                 ;see if 0-9 or A-F
                ja      asc2b_500
                sub     al, '0'                 ;convert to binary
                jmp     short asc2b_900
asc2b_500:
                sub     al, 'A' - 10

asc2b_900:
                ret
asc2bin         endp        



skip_white_sp   proc    near
                cmp     byte ptr [si], ' '
                je      skip_w200
                cmp     byte ptr [si], TAB
                jne     skip_w900

skip_w200:
                inc     si
                loop    skip_white_sp
skip_w900:
                ret
skip_white_sp   endp


code            ends
                end
