	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

	PortB		EQU	61h		;Sound port address

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
	INCLUDE	video.mac
ENDIF

	EXTRN	Self:WORD

	.CODE

COMMENT	%
==============================================================================
Makes an "Alert" sound.
=============================================================================%
alertSound	PROC	NEAR
	mov		si,880
	mov		di,440
	call		makeSound
	ret
alertSound	ENDP



COMMENT	%
==============================================================================
Makes an "Error" sound.
=============================================================================%
errorSound	PROC	NEAR
	mov		si,7040
	mov		di,3520
	call		makeSound
	ret
errorSound	ENDP



COMMENT	%
==============================================================================
Makes the specified sound.

Passed:	si - Sound frequency one
	di - Sound frequency two
=============================================================================%
makeSound	PROC	NEAR
	in		al,PortB			;Read port B
	push		ax				;Save contents

	mov		dx,0Bh
mks1:	mov		bx,si				;Pass frequency
	call		speakerOn

	mov		cx,2600h
mks2:	loop		mks2

	mov		bx,di				;Pass frequency
	call		speakerOn

	mov		cx,1300h
mks3:	loop		mks3

	dec		dx
	jnz		mks1

	pop		ax				;Restore contents
	out		PortB,al			;Turn off speaker
	ret
makeSound	ENDP



COMMENT	%
==============================================================================
Turns on the speaker.

Passed:	bx - Sound frequency
=============================================================================%
speakerOn	PROC	NEAR
	mov		al,10110110b			;Write LSB/MSB
	out		43h,al				;Mode 3
	mov		ax,bx				;Send counter LSB
	out		42h,al				;MSB into timer2
	mov		al,ah				;Send counter MSB
	out		42h,al				;MSB into timer2
	in		al,PortB			;Read port B
	or		al,00000011b			;Enable speaker
	out		PortB,al			;Turn on speaker
	ret
speakerOn	ENDP



	.DATA

defMsg	Sound,\
	Alert,\
	<alertSound,,>

defMsg	Sound,\
	Error,\
	<errorSound,,>

defObj	Sound,\
	<>,\
	<>\
	<Alert,Error>



	END
