	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

	ShadowColor	EQU	08h		;Shadow color

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
	INCLUDE	strings.mac
ENDIF

	EXTRN	Self:WORD

	.CODE

IF Dbug
	PUBLIC	disShadow
ENDIF
COMMENT	%
==============================================================================
Displays a shadow.

=============================================================================%
disShadow	PROC	NEAR
	getInst		dh,Row2,Self		;Get lower row
	getInst		dl,Col1			;Get left column
	getInst		bh,Col2			;Get right column

	push		dx
	inc		dh			;Move beyond last row
	add		dl,2			;Move right two columns
	add		bh,2
	disAttr		dh,dl,bh,ShadowColor	;Change attributes
	pop		dx

	mov		cl,dh			;Get last row
	getInst		dh,Row1			;Get upper row
	sub		cl,dh			;Get number of rows
	xor		ch,ch
	getInst		dl,Col2			;Get right column
	inc		dl
dsh1:	inc		dh			;Start at next row
	pushData	<cx,dx>
	disAttr		dh,dl,bh,ShadowColor	;Change attributes
	popData		<dx,cx>
	loop		dsh1
	ret
disShadow	ENDP



COMMENT	%
==============================================================================
Sets the shadow flag so other objects know that a shadow is being drawn.
=============================================================================%
setShadowFlag	PROC	NEAR
	setInst		?Shadow,1,Shadow,1	;Set shadow flag
	ret
setShadowFlag	ENDP



COMMENT	%
==============================================================================
Resets the shadow flag.
=============================================================================%
resetShadowFlag	PROC	NEAR
	setInst		?Shadow,Nil,Shadow,1	;Reset shadow flag
	ret
resetShadowFlag	ENDP



	.DATA

defMsg	Shadow,\
	Refresh,\
	<setShadowFlag,,disShadow>

defMsg	Shadow,\
	Clear,\
	<,,resetShadowFlag>

defObj	Shadow,\
	<>,\
	<?Shadow,1,Nil>,\
	<Refresh,Clear>



	END

