	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
ENDIF

	EXTRN	sendMsg:NEAR

	EXTRN	Self:WORD

	.CODE

COMMENT	%
==============================================================================
For all slaves pointed to by SlaveTbl, sets their MasterObj pointer to 
point to Self.

=============================================================================%
enslave	PROC	NEAR
	getInst		bx,SlaveTbl,Self	;Get slave tbl ptr
	iterate		bx,2,setMaster		;Call setMaster for each obj
	ret
enslave	ENDP



COMMENT	%
==============================================================================
Sets a slave's MasterObj pointer to point to Self.

Passed:	bx - Ptr to slave tbl

=============================================================================%
setMaster	PROC	NEAR
	push		Self
	mov		ax,Wptr[Self]		;Save Self
	push		Wptr[bx]		;Reset Self to slave obj
	pop		Self
	setInst		MasterObj,ax,Self	;Set slave's master ptr
	pop		Self
	ret
setMaster	ENDP



COMMENT	%
==============================================================================
Passes the Refresh message to slave objects.

=============================================================================%
slaveRefresh	PROC	NEAR
	getInst		bx,SlaveTbl,Self	;Get slave tbl ptr
	sendSlaves	bx,Refresh		;Send Refresh to all slaves
	ret
slaveRefresh	ENDP



COMMENT	%
==============================================================================
Passes the Read message to slave objects.

=============================================================================%
slaveRead	PROC	NEAR
	getInst		bx,SlaveTbl,Self	;Get slave tbl ptr
	sendSlaves	bx,Read			;Send Read to all slaves
	ret
slaveRead	ENDP



IF Dbug
	PUBLIC	slaveSelect
ENDIF
COMMENT	%
==============================================================================
Passes the Select message to slave objects.

=============================================================================%
slaveSelect	PROC	NEAR
	getInst		bx,SlaveTbl,Self	;Get slave tbl ptr
	sendSlaves	bx,Select		;Send Select to all slaves
	ret
slaveSelect	ENDP



	PUBLIC	makeActive
COMMENT	%
==============================================================================
Makes a slave object active by stuffing a pointer to it in the master's
ActiveSlave instance variable.

=============================================================================%
makeActive	PROC	NEAR
	mov		ax,Wptr[Self]		;Get current object ptr
	setInst$	ActiveSlave,ax,MasterObj
	ret
makeActive	ENDP



	.DATA

defMsg	Master,\
	Refresh,\
	<enslave,,slaveRefresh>

defMsg	Master,\
	Read,\
	<,,slaveRead>

defMsg	Master,\
	Select,\
	<,,slaveSelect>

defObj	Master,\
	<>,\
	<>,\
	<Refresh,Read,Select>



	END


