	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

	MaxDirEntries	EQU	200		;Maximum number of file names
	MenuWidth	EQU	15		;Menu width

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
ENDIF

	EXTRN	disVertMenu:NEAR
	EXTRN	makeActive:NEAR

	EXTRN	Clock:WORD
	EXTRN	DBorder:WORD
	EXTRN	HorzMenu:WORD
	EXTRN	Menu:WORD
	EXTRN	Self:WORD
	EXTRN	Window:WORD

	.CODE

COMMENT	%
==============================================================================
Sets Dir's instance variables with values handed down from the master.

=============================================================================%
initDirVars	PROC	NEAR
	push		Self
	getInst$	ch,Row1,MasterObj	;Get upper row from master
	getInst		dh,Row2			;Get lower row
	getInst		dl,Col2			;Get right column

	inc		ch			;Add row offset
	dec		dh			;Subtract row offset
	sub		dl,ColOffset		;Subtract column offset

	setInst		Row1,ch,Dir		;Set upper row
	setInst		Row2,dh			;Set lower row
	setInst		Col2,dl			;Set right column

	sub		dl,MenuWidth		;Subtract menu width
	setInst		Col1,dl			;Set left column
	setInst		InxPtr,0,,2		;Clear index pointer
	pop		Self
	ret
initDirVars	ENDP



COMMENT	%
==============================================================================
Create directory menu of all files in current directory.

=============================================================================%
createDirMenu	PROC	NEAR
	getInst		dx,?ReadDir,Dir		;Directory already read
	identity	dx,cdm1			;Exit if not Nil
	call		setDTA			;Setup data transfer area
	lea		dx,FilePattern		;Pass ptr to search pattern
	call		findFirst		;Find first occurence of file
	call		findRest		;Find rest of files
	call		makeMenu		;Make directory menu
	setInst		?ReadDir,0,Dir,2	;Flag as haven been read
cdm1:	ret
createDirMenu	ENDP



COMMENT	%
==============================================================================
Setups data transfer area.

=============================================================================%
setDTA	PROC	NEAR
	lea		dx,DTA			;Pass DTA address
	mov		ah,1Ah			;Pass service number
	int		DosInt			;DOS interrupt
	ret
setDTA	ENDP



	PUBLIC	findFirst
COMMENT	%
==============================================================================
Finds first occurence of file that matches file pattern.

Passed: dx - File pattern to search for

=============================================================================%
findFirst	PROC	NEAR
	mov		cx,111111b		;All file attributes
	mov		ah,4Eh			;Pass service number
	int		DosInt			;DOS interrupt
	ret
findFirst	ENDP



COMMENT	%
==============================================================================
Finds rest of files that matches file pattern.

=============================================================================%
findRest	PROC	NEAR
	xor		cx,cx			;Clear counter
	cld					;Clear direction flag
	lea		di,DirBuf		;Get destination addr
	lea		si,FileName		;Get source addr
fndr1:	call		movString		;Copy from source to dest
	mov		ah,4Fh			;Pass service number
	int		DosInt			;DOS interrupt
	inc		cx			;Increment count
	jnc		fndr1			;Jump if more matches

	dec		cx			;Zero based counting
	mov		Bptr[di],Nil		;Mark end of file list
	ret
findRest	ENDP



COMMENT	%
==============================================================================
Copies an ASCIIZ string from source to destination. Adds blanks to both ends.

Passed:	di - Destination addresss
	si - Source address

=============================================================================%
movString	PROC	NEAR
	push		si
	mov		Bptr[di],Space		;Copy space into first byte
mvs1:	inc		di			;Point to next byte
	lodsb					;Get byte from source
	zero		al,mvs2			;Is it zero? - Jump
	mov		Bptr[di],al		;Else - Copy to destination
	jmp		mvs1			;Continue
mvs2:	mov		Bptr[di],Space		;Copy space to destination
	mov		Bptr[di+1],0		;Copy zero into last byte
	add		di,2			;Point to next open byte
	pop		si
	ret
movString	ENDP



COMMENT	%
==============================================================================
Makes a menu of directory entries.

=============================================================================%
makeMenu	PROC	NEAR
	lea		si,DirBuf		;Get ptr to directory list
	lea		di,DirTbl		;Get ptr to directory menu
mkm1:	mov		al,Bptr[si]		;Get char
	null		al,mkm2			;No more files? - Exit
	call		fillEntry		;Else - Fill in a menu entry
	jmp		mkm1			;Continue
mkm2:	mov		Wptr[di],Nil		;Mark end of menu
	ret
makeMenu	ENDP



COMMENT	%
==============================================================================
Fills in a menu entry.

Passed:	di - Pointer to 4-byte menu entry.
	si - Pointer to first char of file name.

Passes:	di - Pointer to next menu entry.
	si - Pointer to first char of next file name.

=============================================================================%
fillEntry	PROC	NEAR
	mov		Wptr[di],0		;Save row/col of menu item
	mov		Wptr[di+2],si		;Save ptr to file name
	add		di,4			;Point to next menu entry
fll1:	lodsb					;Get char
	notZero		al,fll1			;More chars in name? - Loop
	ret
fillEntry	ENDP



IF Dbug
	PUBLIC	copyTxtPtr
ENDIF
COMMENT	%
==============================================================================
Stuffs the currently hilited menu item into memory for use by master object.
Clears the menu index pointer to avoid normal Menu,Select activity.

=============================================================================%
copyTxtPtr	PROC	NEAR
	getInst		bx,InxPtr,Self		;Get index pointer
	getInst		di,MenuPtr		;Get menu pointer
	mov		bx,Wptr[di+bx+2]	;Get text ptr
	inc		bx			;Skip leading space
	setInst		TxtPtr,bx		;Copy it to text ptr inst var
	setInst		InxPtr,Nil,,2		;Clear index pointer
	ret
copyTxtPtr	ENDP



	.DATA

	PUBLIC	FileAttr
	PUBLIC	FileTime
	PUBLIC	FileDate
	PUBLIC	FileSize
	PUBLIC	FileName
DTA		DB	21 DUP (0)		;Reserved
FileAttr	DB	0			;File attribute
FileTime	DW	0			;File time
FileDate	DW	0			;File date
FileSize	DD	0			;File size
FileName	DB	64 DUP (0)		;File name
DirBuf		DB	MaxDirEntries*15 DUP (0)
IF Dbug
	PUBLIC	DirTbl
ENDIF
DirTbl		DB	MaxDirEntries*4 DUP (Nil)
FilePattern	DB	"*.*",0			;Search for all files

defMsg	Dir,\
	Refresh,\
	<initDirVars,createDirMenu,disVertMenu>

defMsg	Dir,\
	Read,\
	<makeActive,,>

defMsg	Dir,\
	Next,\
	<makeActive,,>

defMsg	Dir,\
	Prev,\
	<makeActive,,>

defMsg	Dir,\
	Select,\
	<copyTxtPtr,,>

defObj	Dir,\
	<Window,DBorder,Menu>,\
	<Row1,1,10,\
	Col1,1,53,\
	Row2,1,15,\
	Col2,1,63,\
	Color,1,31h,\
	Unused,1,Nil,\
	?ReadDir,2,Nil,\
	InxPtr,2,0,\
	MasterObj,2,Nil,\
	DispTbl,2,Nil,\
	MenuPtr,2,DirTbl>,\
	<Refresh,Read,Next,Prev,Select,Clear,ScrollUp,ScrollDown,Hilite>



	END
